/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.reporting.ui;

import com.debortoliwines.openerp.reporting.di.OpenERPFilterInfo;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;

public class OpenERPFilterDetailTable
extends AbstractTableModel {
    private static final long serialVersionUID = -4866256815912624560L;
    private String currentModelPath = "";
    private int currentInstanceNum = 0;
    private ArrayList<OpenERPFilterInfo> fullList = new ArrayList();

    public void addFilter(String operator, String fieldName, String comparator, String value) {
        if (this.currentModelPath.length() == 0) {
            return;
        }
        OpenERPFilterInfo newInfo = new OpenERPFilterInfo(this.currentModelPath, this.currentInstanceNum, operator, fieldName, comparator, value);
        this.fullList.add(newInfo);
        this.fireTableDataChanged();
    }

    public void setCurrentView(String modelPath, int instanceNum) {
        this.currentModelPath = modelPath;
        this.currentInstanceNum = instanceNum;
        this.fireTableDataChanged();
    }

    private ArrayList<OpenERPFilterInfo> getCurrentModelList() {
        ArrayList<OpenERPFilterInfo> modelPathList = new ArrayList<OpenERPFilterInfo>();
        for (OpenERPFilterInfo item : this.fullList) {
            if (item.getModelPath() == null || !item.getModelPath().equals(this.currentModelPath) || item.getInstanceNum() != this.currentInstanceNum) continue;
            modelPathList.add(item);
        }
        return modelPathList;
    }

    public void removeFilter(int rowIndex) {
        if (rowIndex < 0) {
            return;
        }
        OpenERPFilterInfo filter = this.getCurrentModelList().get(rowIndex);
        this.fullList.remove(filter);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    public void removeFilters(int[] rowIndexes) {
        Arrays.sort(rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            this.removeFilter(rowIndexes[i]);
        }
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public int getRowCount() {
        return this.getCurrentModelList().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        OpenERPFilterInfo filterRow = this.getCurrentModelList().get(rowIndex);
        if (columnIndex == 0) {
            return rowIndex;
        }
        if (columnIndex == 1) {
            return filterRow.getOperator();
        }
        if (columnIndex == 2) {
            return filterRow.getFieldName();
        }
        if (columnIndex == 3) {
            return filterRow.getComparator();
        }
        if (columnIndex == 4) {
            return filterRow.getValue();
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return "#";
        }
        if (columnIndex == 1) {
            return "Operator";
        }
        if (columnIndex == 2) {
            return "Field";
        }
        if (columnIndex == 3) {
            return "Comparator";
        }
        if (columnIndex == 4) {
            return "Value";
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue == null) {
            return;
        }
        if (rowIndex >= this.getCurrentModelList().size()) {
            return;
        }
        OpenERPFilterInfo filterRow = this.getCurrentModelList().get(rowIndex);
        if (columnIndex == 1) {
            filterRow.setOperator(aValue.toString());
        } else if (columnIndex == 2) {
            filterRow.setFieldName(aValue.toString());
        } else if (columnIndex == 3) {
            filterRow.setComparator(aValue.toString());
        } else if (columnIndex == 4) {
            filterRow.setValue(aValue.toString());
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex > 0;
    }

    public ArrayList<OpenERPFilterInfo> getFilterData() {
        return this.fullList;
    }

    public void setFilterData(ArrayList<OpenERPFilterInfo> filterData) {
        this.fullList = filterData;
        this.fireTableDataChanged();
    }
}

