/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.libsparklines;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class PieGraphDrawable {
    private static final Color DEFAULT_MEDIUM_COLOR = Color.YELLOW;
    private static final Color DEFAULT_HIGH_COLOR = Color.RED;
    private static final Color DEFAULT_LOW_COLOR = Color.GREEN;
    private static final Double DEFAULT_LOW_SLICE = new Double(0.3);
    private static final Double DEFAULT_MEDIUM_SLICE = new Double(0.7);
    private static final Double DEFAULT_HIGH_SLICE = new Double(1.0);
    private Color color = Color.LIGHT_GRAY;
    private Color background;
    private Color mediumColor = DEFAULT_MEDIUM_COLOR;
    private Color highColor;
    private Color lowColor = DEFAULT_LOW_COLOR;
    private Number mediumSlice;
    private Number highSlice;
    private Number lowSlice;
    private boolean counterClockWise = false;
    private int startAngle = 0;
    private Number value;

    public PieGraphDrawable() {
        this.highColor = DEFAULT_HIGH_COLOR;
        this.mediumSlice = DEFAULT_MEDIUM_SLICE;
        this.lowSlice = DEFAULT_LOW_SLICE;
        this.highSlice = DEFAULT_HIGH_SLICE;
    }

    public void draw(Graphics2D graphics, Rectangle2D drawArea) {
        double adjustX = drawArea.getWidth() < drawArea.getHeight() ? 0.0 : (drawArea.getHeight() - drawArea.getWidth()) / 2.0;
        double adjustY = drawArea.getHeight() < drawArea.getWidth() ? 0.0 : (drawArea.getWidth() - drawArea.getHeight()) / 2.0;
        Graphics2D g = (Graphics2D)graphics.create();
        if (this.background != null) {
            g.setBackground(this.background);
            g.clearRect(0, 0, (int)drawArea.getWidth(), (int)drawArea.getHeight());
        }
        g.translate(drawArea.getX() - adjustX, drawArea.getY() - adjustY);
        int radius = (int)(drawArea.getWidth() < drawArea.getHeight() ? drawArea.getWidth() : drawArea.getHeight());
        g.setPaint(this.color);
        g.fillOval(0, 0, radius, radius);
        int endArc = (int)(this.value.doubleValue() * 360.0);
        g.setBackground(Color.BLUE);
        if (this.value.doubleValue() <= this.lowSlice.doubleValue()) {
            g.setPaint(this.lowColor);
        } else if (this.value.doubleValue() <= this.mediumSlice.doubleValue()) {
            g.setPaint(this.mediumColor);
        } else if (this.value.doubleValue() <= this.highSlice.doubleValue()) {
            g.setPaint(this.highColor);
        }
        int counterClockWise = this.counterClockWise ? 1 : -1;
        g.fillArc(0, 0, radius, radius, -this.startAngle + 90, counterClockWise * endArc);
        g.dispose();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getMediumColor() {
        return this.mediumColor;
    }

    public void setMediumColor(Color mediumColor) {
        this.mediumColor = mediumColor;
    }

    public Color getHighColor() {
        return this.highColor;
    }

    public void setHighColor(Color highColor) {
        this.highColor = highColor;
    }

    public Color getLowColor() {
        return this.lowColor;
    }

    public void setLowColor(Color lowColor) {
        this.lowColor = lowColor;
    }

    public Number getMediumSlice() {
        return this.mediumSlice;
    }

    public void setMediumSlice(Number mediumSlice) {
        this.mediumSlice = mediumSlice;
    }

    public Number getHighSlice() {
        return this.highSlice;
    }

    public void setHighSlice(Number highSlice) {
        this.highSlice = highSlice;
    }

    public Number getLowSlice() {
        return this.lowSlice;
    }

    public void setLowSlice(Number lowSlice) {
        this.lowSlice = lowSlice;
    }

    public Number getValue() {
        return this.value;
    }

    public void setValue(Number value) {
        this.value = value;
    }

    public boolean isCounterClockWise() {
        return this.counterClockWise;
    }

    public void setCounterClockWise(boolean counterClockWise) {
        this.counterClockWise = counterClockWise;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(int startAngle) {
        this.startAngle = startAngle;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color background) {
        this.background = background;
    }
}

