/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.TimeZone;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Hour;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.Minute;
import org.jfree.data.time.Month;
import org.jfree.data.time.Quarter;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.Second;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.jfree.data.time.Week;
import org.jfree.data.time.Year;
import org.pentaho.plugin.jfreereport.reportcharts.BaseCollectorFunction;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.Function;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;

public class TimeSeriesCollectorFunction
extends BaseCollectorFunction {
    private static final long serialVersionUID = -8138304452870844825L;
    public static final String DAY_PERIOD_TYPE_STR = "Day";
    public static final String FIXEDMILLISECOND_PERIOD_TYPE_STR = "FixedMillisecond";
    public static final String HOUR_PERIOD_TYPE_STR = "Hour";
    public static final String MILLISECOND_PERIOD_TYPE_STR = "Millisecond";
    public static final String MINUTE_PERIOD_TYPE_STR = "Minute";
    public static final String MONTH_PERIOD_TYPE_STR = "Month";
    public static final String QUARTER_PERIOD_TYPE_STR = "Quarter";
    public static final String SECOND_PERIOD_TYPE_STR = "Second";
    public static final String WEEK_PERIOD_TYPE_STR = "Week";
    public static final String YEAR_PERIOD_TYPE_STR = "Year";
    private ArrayList valueColumns = new ArrayList();
    private ArrayList timeValueColumns = new ArrayList();
    private String domainPeriodType = "Millisecond";

    public void setValueColumn(int index, String field) {
        if (this.valueColumns.size() == index) {
            this.valueColumns.add(field);
        } else {
            this.valueColumns.set(index, field);
        }
    }

    public void setTimeValueColumn(int index, String field) {
        if (this.timeValueColumns.size() == index) {
            this.timeValueColumns.add(field);
        } else {
            this.timeValueColumns.set(index, field);
        }
    }

    public String getValueColumn(int index) {
        return (String)this.valueColumns.get(index);
    }

    public int getValueColumnCount() {
        return this.valueColumns.size();
    }

    public String[] getValueColumn() {
        return this.valueColumns.toArray(new String[this.valueColumns.size()]);
    }

    public void setValueColumn(String[] fields) {
        this.valueColumns.clear();
        this.valueColumns.addAll(Arrays.asList(fields));
    }

    public String getTimeValueColumn(int index) {
        return (String)this.timeValueColumns.get(index);
    }

    public int getTimeValueColumnCount() {
        return this.timeValueColumns.size();
    }

    public String[] getTimeValueColumn() {
        return this.timeValueColumns.toArray(new String[this.timeValueColumns.size()]);
    }

    public void setTimeValueColumn(String[] fields) {
        this.timeValueColumns.clear();
        this.timeValueColumns.addAll(Arrays.asList(fields));
    }

    public void itemsAdvanced(ReportEvent reportEvent) {
        if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)reportEvent)) {
            return;
        }
        if (!this.isSummaryOnly()) {
            this.buildDataset();
        }
    }

    public void groupFinished(ReportEvent reportEvent) {
        if (!FunctionUtilities.isDefinedPrepareRunLevel((Function)this, (ReportEvent)reportEvent)) {
            return;
        }
        if (this.isSummaryOnly() && FunctionUtilities.isDefinedGroup((String)this.getGroup(), (ReportEvent)reportEvent)) {
            this.buildDataset();
        }
    }

    private void buildDataset() {
        Object o = this.getDatasourceValue();
        if (!(o instanceof TimeSeriesCollection)) {
            return;
        }
        TimeSeriesCollection timeSeriesDataset = (TimeSeriesCollection)o;
        int maxIndex = Math.min(this.getSeriesNameCount(), Math.min(this.valueColumns.size(), this.timeValueColumns.size()));
        for (int i = 0; i < maxIndex; ++i) {
            Object tmp;
            String seriesName = this.getSeriesName(i);
            String column = (String)this.valueColumns.get(i);
            Object valueObject = this.getDataRow().get(column);
            String timeColumn = (String)this.timeValueColumns.get(i);
            Object timeValueObject = this.getDataRow().get(timeColumn);
            if (this.isSeriesColumn() && (tmp = this.getDataRow().get(seriesName)) != null) {
                seriesName = tmp.toString();
            }
            Number value = valueObject instanceof Number ? (Number)((Number)valueObject) : (Number)null;
            Date timeValue = timeValueObject instanceof Date ? (Date)timeValueObject : new Date();
            TimeSeries series = null;
            try {
                series = timeSeriesDataset.getSeries((Comparable)((Object)seriesName));
            }
            catch (Exception ignored) {
                // empty catch block
            }
            Class timePeriodClass = TimeSeriesCollectorFunction.getTimePeriodClass(this.getDomainPeriodType());
            if (series == null) {
                series = new TimeSeries((Comparable)((Object)seriesName), timePeriodClass);
                timeSeriesDataset.addSeries(series);
            }
            RegularTimePeriod regularTimePeriod = RegularTimePeriod.createInstance((Class)timePeriodClass, (Date)timeValue, (TimeZone)TimeZone.getDefault());
            TimeSeriesDataItem timeSeriesDataItem = new TimeSeriesDataItem(regularTimePeriod, value);
            series.add(timeSeriesDataItem);
        }
    }

    @Override
    public Dataset createNewDataset() {
        return new FastTimeSeriesCollection();
    }

    public String getDomainPeriodType() {
        return this.domainPeriodType;
    }

    public void setDomainPeriodType(String domainPeriodType) {
        this.domainPeriodType = domainPeriodType;
    }

    @Override
    public Expression getInstance() {
        TimeSeriesCollectorFunction fn = (TimeSeriesCollectorFunction)super.getInstance();
        fn.valueColumns = (ArrayList)this.valueColumns.clone();
        fn.timeValueColumns = (ArrayList)this.timeValueColumns.clone();
        return fn;
    }

    private static Class getTimePeriodClass(String timePeriodStr) {
        Class<Millisecond> retClass = Millisecond.class;
        if (timePeriodStr.equalsIgnoreCase(SECOND_PERIOD_TYPE_STR)) {
            retClass = Second.class;
        } else if (timePeriodStr.equalsIgnoreCase(MINUTE_PERIOD_TYPE_STR)) {
            retClass = Minute.class;
        } else if (timePeriodStr.equalsIgnoreCase(HOUR_PERIOD_TYPE_STR)) {
            retClass = Hour.class;
        } else if (timePeriodStr.equalsIgnoreCase(DAY_PERIOD_TYPE_STR)) {
            retClass = Day.class;
        } else if (timePeriodStr.equalsIgnoreCase(WEEK_PERIOD_TYPE_STR)) {
            retClass = Week.class;
        } else if (timePeriodStr.equalsIgnoreCase(MONTH_PERIOD_TYPE_STR)) {
            retClass = Month.class;
        } else if (timePeriodStr.equalsIgnoreCase(QUARTER_PERIOD_TYPE_STR)) {
            retClass = Quarter.class;
        } else if (timePeriodStr.equalsIgnoreCase(YEAR_PERIOD_TYPE_STR)) {
            retClass = Year.class;
        }
        return retClass;
    }

    private static class FastTimeSeriesCollection
    extends TimeSeriesCollection {
        private static final long serialVersionUID = 2096209400748561882L;

        private FastTimeSeriesCollection() {
        }

        public int hashCode() {
            return this.getSeriesCount();
        }
    }
}

