/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.kettle;

import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.reporting.engine.classic.core.DataFactoryContext;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.AbstractKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.DocumentHelper;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.EmbeddedKettleTransformationProducer;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleTransformationProducer;
import org.pentaho.reporting.ui.datasources.kettle.KettleQueryEntry;
import org.pentaho.reporting.ui.datasources.kettle.embedded.KettleParameterInfo;
import org.pentaho.reporting.ui.datasources.kettle.embedded.XulDialogHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EmbeddedKettleQueryEntry
extends KettleQueryEntry {
    private static final Log logger = LogFactory.getLog(EmbeddedKettleQueryEntry.class);
    private static final String AUTO_GENERATED_PARAMETER = "AUTO.GENERATED.PARAMETER";
    private String pluginId;
    private XulDialogHelper dialogHelper;

    private EmbeddedKettleQueryEntry(String name, String pluginId, XulDialogHelper dialogHelper) throws KettleException {
        super(name);
        this.pluginId = pluginId;
        this.dialogHelper = dialogHelper;
        this.dialogHelper.addChangeListener(new ValidatePropertyBinding());
    }

    public static EmbeddedKettleQueryEntry createFromExisting(String name, EmbeddedKettleTransformationProducer producer, DataFactoryContext dataFactoryContext) throws KettleException, ReportDataFactoryException {
        XulDialogHelper dialogHelper = new XulDialogHelper(producer.loadTransformation(dataFactoryContext));
        EmbeddedKettleQueryEntry entry = new EmbeddedKettleQueryEntry(name, producer.getPluginId(), dialogHelper);
        entry.setArguments(producer.getArguments());
        entry.setParameters(producer.getParameter());
        entry.setStopOnErrors(producer.isStopOnError());
        return entry;
    }

    public static EmbeddedKettleQueryEntry createFromTemplate(String name, String pluginId) throws KettleException {
        XulDialogHelper dialogHelper = new XulDialogHelper(EmbeddedKettleQueryEntry.loadTemplate(pluginId));
        return new EmbeddedKettleQueryEntry(name, pluginId, dialogHelper);
    }

    private static TransMeta loadTemplate(String pluginId) throws KettleException {
        Document document = DocumentHelper.loadDocumentFromPlugin((String)pluginId);
        Node node = XMLHandler.getSubNode((Node)document, (String)"transformation");
        TransMeta meta = new TransMeta();
        meta.loadXML(node, null, true, null, null);
        return meta;
    }

    @Override
    public boolean validate() {
        return this.dialogHelper.validate();
    }

    @Override
    public KettleTransformationProducer createProducer() throws KettleException {
        EmbeddedKettleTransformationProducer p = new EmbeddedKettleTransformationProducer(this.getArguments(), this.getParameters(), this.pluginId, this.dialogHelper.getRawData());
        p.setStopOnError(this.isStopOnErrors());
        return p;
    }

    public JComponent createUI() throws ReportDataFactoryException {
        return this.dialogHelper.createEditor();
    }

    public void clear() {
        this.dialogHelper.clear();
    }

    @Override
    protected AbstractKettleTransformationProducer loadTransformation(DataFactoryContext context) throws KettleException {
        return new EmbeddedKettleTransformationProducer(this.getArguments(), this.getParameters(), this.pluginId, this.dialogHelper.getRawData());
    }

    @Override
    public KettleParameterInfo[] getDeclaredParameters(DataFactoryContext context) throws KettleException, ReportDataFactoryException {
        KettleParameterInfo[] declaredParameters = super.getDeclaredParameters(context);
        ArrayList<KettleParameterInfo> infos = new ArrayList<KettleParameterInfo>();
        for (KettleParameterInfo declaredParameter : declaredParameters) {
            if (!AUTO_GENERATED_PARAMETER.equalsIgnoreCase(declaredParameter.getDescription())) continue;
            infos.add(declaredParameter);
        }
        return infos.toArray(new KettleParameterInfo[infos.size()]);
    }

    private class ValidatePropertyBinding
    implements ChangeListener {
        private boolean recursionPrevention;

        private ValidatePropertyBinding() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stateChanged(ChangeEvent e) {
            if (this.recursionPrevention) {
                return;
            }
            try {
                this.recursionPrevention = true;
                EmbeddedKettleQueryEntry.this.setValidated(EmbeddedKettleQueryEntry.this.dialogHelper.validate());
            }
            finally {
                this.recursionPrevention = false;
            }
        }
    }
}

