/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class KeyOnlyFilter
extends FilterBase {
    boolean lenAsVal;

    public KeyOnlyFilter() {
        this(false);
    }

    public KeyOnlyFilter(boolean lenAsVal) {
        this.lenAsVal = lenAsVal;
    }

    @Override
    public Cell transformCell(Cell kv) {
        KeyValue v = KeyValueUtil.ensureKeyValue((Cell)kv);
        return v.createKeyOnly(this.lenAsVal);
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        Preconditions.checkArgument((filterArguments.size() == 0 || filterArguments.size() == 1 ? 1 : 0) != 0, (String)"Expected: 0 or 1 but got: %s", (Object[])new Object[]{filterArguments.size()});
        KeyOnlyFilter filter = new KeyOnlyFilter();
        if (filterArguments.size() == 1) {
            filter.lenAsVal = ParseFilter.convertByteArrayToBoolean(filterArguments.get(0));
        }
        return filter;
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.KeyOnlyFilter.Builder builder = FilterProtos.KeyOnlyFilter.newBuilder();
        builder.setLenAsVal(this.lenAsVal);
        return builder.build().toByteArray();
    }

    public static KeyOnlyFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.KeyOnlyFilter proto;
        try {
            proto = FilterProtos.KeyOnlyFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        return new KeyOnlyFilter(proto.getLenAsVal());
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KeyOnlyFilter)) {
            return false;
        }
        KeyOnlyFilter other = (KeyOnlyFilter)o;
        return this.lenAsVal == other.lenAsVal;
    }

    public boolean isLenAsVal() {
        return this.lenAsVal;
    }
}

