/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.LoadBalancer;

@InterfaceAudience.Private
public class ClusterStatusChore
extends Chore {
    private final HMaster master;
    private final LoadBalancer balancer;

    public ClusterStatusChore(HMaster master, LoadBalancer balancer) {
        super(master.getServerName() + "-ClusterStatusChore", master.getConfiguration().getInt("hbase.balancer.statusPeriod", 60000), (Stoppable)master);
        this.master = master;
        this.balancer = balancer;
    }

    protected void chore() {
        this.balancer.setClusterStatus(this.master.getClusterStatus());
    }
}

