/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;
import org.apache.hadoop.hbase.regionserver.compactions.DefaultCompactor;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class DefaultMobCompactor
extends DefaultCompactor {
    private static final Log LOG = LogFactory.getLog(DefaultMobCompactor.class);
    private long mobSizeThreshold;
    private HMobStore mobStore;

    public DefaultMobCompactor(Configuration conf, Store store) {
        super(conf, store);
        if (!(store instanceof HMobStore)) {
            throw new IllegalArgumentException("The store " + store + " is not a HMobStore");
        }
        this.mobStore = (HMobStore)store;
        this.mobSizeThreshold = store.getFamily().getMobThreshold();
    }

    @Override
    protected StoreFile.Writer createTmpWriter(Compactor.FileDetails fd, long smallestReadPoint) throws IOException {
        StoreFile.Writer writer = this.store.createWriterInTmp(fd.maxKeyCount, this.compactionCompression, true, fd.maxMVCCReadpoint >= smallestReadPoint, true);
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean performCompaction(Compactor.FileDetails fd, InternalScanner scanner, Compactor.CellSink writer, long smallestReadPoint) throws IOException {
        block23: {
            block21: {
                block22: {
                    bytesWritten = 0;
                    cells = new ArrayList<Cell>();
                    closeCheckInterval = HStore.getCloseCheckInterval();
                    path = MobUtils.getMobFamilyPath(this.conf, this.store.getTableName(), this.store.getColumnFamilyName());
                    fileName = null;
                    mobFileWriter = null;
                    mobCells = 0L;
                    tableNameTag = new Tag(6, this.store.getTableName().getName());
                    try {
                        try {
                            mobFileWriter = this.mobStore.createWriterInTmp(new Date(fd.latestPutTs), fd.maxKeyCount, this.store.getFamily().getCompression(), this.store.getRegionInfo().getStartKey());
                            fileName = Bytes.toBytes((String)mobFileWriter.getPath().getName());
                        }
                        catch (IOException e) {
                            DefaultMobCompactor.LOG.error((Object)"Fail to create mob writer, we will continue the compaction by writing MOB cells directly in store files", (Throwable)e);
                        }
                        while (true) {
                            hasMore = scanner.next(cells, this.compactionKVMax);
                            for (Cell c : cells) {
                                block20: {
                                    block25: {
                                        block26: {
                                            block24: {
                                                kv = KeyValueUtil.ensureKeyValue((Cell)c);
                                                if (kv.getMvccVersion() <= smallestReadPoint) {
                                                    kv.setMvccVersion(0L);
                                                }
                                                if (mobFileWriter != null && kv.getTypeByte() == KeyValue.Type.Put.getCode()) break block24;
                                                writer.append(kv);
                                                break block20;
                                            }
                                            if (!MobUtils.isMobReferenceCell((Cell)kv)) break block25;
                                            if (!MobUtils.hasValidMobRefCellValue((Cell)kv)) break block26;
                                            size = MobUtils.getMobValueLength((Cell)kv);
                                            if ((long)size > this.mobSizeThreshold) {
                                                writer.append(kv);
                                                break block20;
                                            } else {
                                                cell = this.mobStore.resolve((Cell)kv, false);
                                                if (cell.getValueLength() != 0) {
                                                    mobKv = KeyValueUtil.ensureKeyValue((Cell)cell);
                                                    mobKv.setMvccVersion(kv.getMvccVersion());
                                                    writer.append(mobKv);
                                                    break block20;
                                                } else {
                                                    writer.append(kv);
                                                }
                                            }
                                            break block20;
                                        }
                                        DefaultMobCompactor.LOG.warn((Object)("The value format of the KeyValue " + kv + " is wrong, its length is less than " + 4));
                                        writer.append(kv);
                                        break block20;
                                    }
                                    if ((long)kv.getValueLength() <= this.mobSizeThreshold) {
                                        writer.append(kv);
                                    } else {
                                        ++mobCells;
                                        mobFileWriter.append(kv);
                                        reference = MobUtils.createMobRefKeyValue((Cell)kv, fileName, tableNameTag);
                                        writer.append(reference);
                                    }
                                }
                                ++this.progress.currentCompactedKVs;
                                if (closeCheckInterval <= 0 || (bytesWritten += kv.getLength()) <= closeCheckInterval) continue;
                                bytesWritten = 0;
                                if (this.store.areWritesEnabled()) continue;
                                this.progress.cancel();
                                var19_19 = false;
                                if (mobFileWriter == null) break block21;
                                break block22;
                            }
                            ** GOTO lbl-1000
                            break;
                        }
                    }
                    catch (Throwable var22_23) {
                        if (mobFileWriter != null) {
                            this.appendMetadataAndCloseWriter(mobFileWriter, fd, false);
                        }
                        throw var22_23;
                    }
                }
                this.appendMetadataAndCloseWriter(mobFileWriter, fd, false);
            }
            return var19_19;
lbl-1000:
            // 1 sources

            {
                cells.clear();
                if (hasMore) ** continue;
                if (mobFileWriter == null) break block23;
            }
            this.appendMetadataAndCloseWriter(mobFileWriter, fd, false);
        }
        if (mobFileWriter != null) {
            if (mobCells > 0L) {
                this.mobStore.commitFile(mobFileWriter.getPath(), path);
            } else {
                try {
                    this.store.getFileSystem().delete(mobFileWriter.getPath(), true);
                }
                catch (IOException e) {
                    DefaultMobCompactor.LOG.error((Object)"Fail to delete the temp mob file", (Throwable)e);
                }
            }
        }
        this.progress.complete();
        return true;
    }
}

