/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.mapreduce;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class SweepJobNodeTracker
extends ZooKeeperListener {
    private String node;
    private String sweepJobId;

    public SweepJobNodeTracker(ZooKeeperWatcher watcher, String node, String sweepJobId) {
        super(watcher);
        this.node = node;
        this.sweepJobId = sweepJobId;
    }

    public void start() throws KeeperException {
        this.watcher.registerListener((ZooKeeperListener)this);
        if (ZKUtil.watchAndCheckExists((ZooKeeperWatcher)this.watcher, (String)this.node)) {
            byte[] data = ZKUtil.getDataAndWatch((ZooKeeperWatcher)this.watcher, (String)this.node);
            if (data != null && !this.sweepJobId.equals(Bytes.toString((byte[])data))) {
                System.exit(1);
            }
        } else {
            System.exit(1);
        }
    }

    public void nodeDeleted(String path) {
        if (this.node.equals(path)) {
            System.exit(1);
        }
    }
}

