/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.rmi.UnexpectedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.regionserver.GetClosestRowBeforeTracker;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueSkipListSet;
import org.apache.hadoop.hbase.regionserver.MemStore;
import org.apache.hadoop.hbase.regionserver.MemStoreChunkPool;
import org.apache.hadoop.hbase.regionserver.MemStoreLAB;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CollectionBackedScanner;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class DefaultMemStore
implements MemStore {
    private static final Log LOG = LogFactory.getLog(DefaultMemStore.class);
    static final String USEMSLAB_KEY = "hbase.hregion.memstore.mslab.enabled";
    private static final boolean USEMSLAB_DEFAULT = true;
    private Configuration conf;
    volatile KeyValueSkipListSet kvset;
    volatile KeyValueSkipListSet snapshot;
    final KeyValue.KVComparator comparator;
    final AtomicLong size;
    private volatile long snapshotSize;
    volatile long timeOfOldestEdit = Long.MAX_VALUE;
    TimeRangeTracker timeRangeTracker;
    TimeRangeTracker snapshotTimeRangeTracker;
    MemStoreChunkPool chunkPool;
    volatile MemStoreLAB allocator;
    volatile MemStoreLAB snapshotAllocator;
    volatile long snapshotId;
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + 10 * ClassSize.REFERENCE + 24));
    public static final long DEEP_OVERHEAD = ClassSize.align((long)(FIXED_OVERHEAD + (long)ClassSize.ATOMIC_LONG + (long)(2 * ClassSize.TIMERANGE_TRACKER) + (long)(2 * ClassSize.KEYVALUE_SKIPLIST_SET) + (long)(2 * ClassSize.CONCURRENT_SKIPLISTMAP)));

    public DefaultMemStore() {
        this(HBaseConfiguration.create(), KeyValue.COMPARATOR);
    }

    public DefaultMemStore(Configuration conf, KeyValue.KVComparator c) {
        this.conf = conf;
        this.comparator = c;
        this.kvset = new KeyValueSkipListSet(c);
        this.snapshot = new KeyValueSkipListSet(c);
        this.timeRangeTracker = new TimeRangeTracker();
        this.snapshotTimeRangeTracker = new TimeRangeTracker();
        this.size = new AtomicLong(DEEP_OVERHEAD);
        this.snapshotSize = 0L;
        if (conf.getBoolean(USEMSLAB_KEY, true)) {
            this.chunkPool = MemStoreChunkPool.getPool(conf);
            this.allocator = new MemStoreLAB(conf, this.chunkPool);
        } else {
            this.allocator = null;
            this.chunkPool = null;
        }
    }

    void dump() {
        for (KeyValue kv : this.kvset) {
            LOG.info((Object)kv);
        }
        for (KeyValue kv : this.snapshot) {
            LOG.info((Object)kv);
        }
    }

    @Override
    public MemStoreSnapshot snapshot() {
        if (!this.snapshot.isEmpty()) {
            LOG.warn((Object)"Snapshot called again without clearing previous. Doing nothing. Another ongoing flush or did we fail last attempt?");
        } else {
            this.snapshotId = EnvironmentEdgeManager.currentTimeMillis();
            this.snapshotSize = this.keySize();
            if (!this.kvset.isEmpty()) {
                this.snapshot = this.kvset;
                this.kvset = new KeyValueSkipListSet(this.comparator);
                this.snapshotTimeRangeTracker = this.timeRangeTracker;
                this.timeRangeTracker = new TimeRangeTracker();
                this.size.set(DEEP_OVERHEAD);
                this.snapshotAllocator = this.allocator;
                if (this.allocator != null) {
                    this.allocator = new MemStoreLAB(this.conf, this.chunkPool);
                }
                this.timeOfOldestEdit = Long.MAX_VALUE;
            }
        }
        return new MemStoreSnapshot(this.snapshotId, this.snapshot.size(), this.snapshotSize, this.snapshotTimeRangeTracker, new CollectionBackedScanner(this.snapshot, this.comparator));
    }

    @Override
    public void clearSnapshot(long id) throws UnexpectedException {
        MemStoreLAB tmpAllocator = null;
        if (this.snapshotId != id) {
            throw new UnexpectedException("Current snapshot id is " + this.snapshotId + ",passed " + id);
        }
        if (!this.snapshot.isEmpty()) {
            this.snapshot = new KeyValueSkipListSet(this.comparator);
            this.snapshotTimeRangeTracker = new TimeRangeTracker();
        }
        this.snapshotSize = 0L;
        this.snapshotId = -1L;
        if (this.snapshotAllocator != null) {
            tmpAllocator = this.snapshotAllocator;
            this.snapshotAllocator = null;
        }
        if (tmpAllocator != null) {
            tmpAllocator.close();
        }
    }

    @Override
    public long getFlushableSize() {
        return this.snapshotSize > 0L ? this.snapshotSize : this.keySize();
    }

    @Override
    public long add(Cell cell) {
        KeyValue toAdd = this.maybeCloneWithAllocator(KeyValueUtil.ensureKeyValue((Cell)cell));
        return this.internalAdd(toAdd);
    }

    @Override
    public long timeOfOldestEdit() {
        return this.timeOfOldestEdit;
    }

    private boolean addToKVSet(KeyValue e) {
        boolean b = this.kvset.add(e);
        this.setOldestEditTimeToNow();
        return b;
    }

    private boolean removeFromKVSet(KeyValue e) {
        boolean b = this.kvset.remove(e);
        this.setOldestEditTimeToNow();
        return b;
    }

    void setOldestEditTimeToNow() {
        if (this.timeOfOldestEdit == Long.MAX_VALUE) {
            this.timeOfOldestEdit = EnvironmentEdgeManager.currentTimeMillis();
        }
    }

    private long internalAdd(KeyValue toAdd) {
        long s = DefaultMemStore.heapSizeChange(toAdd, this.addToKVSet(toAdd));
        this.timeRangeTracker.includeTimestamp(toAdd);
        this.size.addAndGet(s);
        return s;
    }

    private KeyValue maybeCloneWithAllocator(KeyValue kv) {
        if (this.allocator == null) {
            return kv;
        }
        int len = kv.getLength();
        MemStoreLAB.Allocation alloc = this.allocator.allocateBytes(len);
        if (alloc == null) {
            return kv;
        }
        assert (alloc.getData() != null);
        System.arraycopy(kv.getBuffer(), kv.getOffset(), alloc.getData(), alloc.getOffset(), len);
        KeyValue newKv = new KeyValue(alloc.getData(), alloc.getOffset(), len);
        newKv.setMvccVersion(kv.getMvccVersion());
        return newKv;
    }

    @Override
    public void rollback(Cell cell) {
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
        KeyValue found = this.snapshot.get(kv);
        if (found != null && found.getMvccVersion() == kv.getMvccVersion()) {
            this.snapshot.remove(kv);
            long sz = DefaultMemStore.heapSizeChange(kv, true);
            this.snapshotSize -= sz;
        }
        if ((found = this.kvset.get(kv)) != null && found.getMvccVersion() == kv.getMvccVersion()) {
            this.removeFromKVSet(kv);
            long s = DefaultMemStore.heapSizeChange(kv, true);
            this.size.addAndGet(-s);
        }
    }

    @Override
    public long delete(Cell deleteCell) {
        long s = 0L;
        KeyValue toAdd = this.maybeCloneWithAllocator(KeyValueUtil.ensureKeyValue((Cell)deleteCell));
        this.timeRangeTracker.includeTimestamp(toAdd);
        this.size.addAndGet(s += DefaultMemStore.heapSizeChange(toAdd, this.addToKVSet(toAdd)));
        return s;
    }

    KeyValue getNextRow(KeyValue kv) {
        return this.getLowest(this.getNextRow(kv, this.kvset), this.getNextRow(kv, this.snapshot));
    }

    private KeyValue getLowest(KeyValue a, KeyValue b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return this.comparator.compareRows(a, b) <= 0 ? a : b;
    }

    private KeyValue getNextRow(KeyValue key, NavigableSet<KeyValue> set) {
        KeyValue result = null;
        NavigableSet<KeyValue> tail = key == null ? set : set.tailSet(key);
        for (KeyValue kv : tail) {
            if (this.comparator.compareRows(kv, key) <= 0) continue;
            result = kv;
            break;
        }
        return result;
    }

    @Override
    public void getRowKeyAtOrBefore(GetClosestRowBeforeTracker state) {
        this.getRowKeyAtOrBefore(this.kvset, state);
        this.getRowKeyAtOrBefore(this.snapshot, state);
    }

    private void getRowKeyAtOrBefore(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state) {
        if (set.isEmpty()) {
            return;
        }
        if (!this.walkForwardInSingleRow(set, state.getTargetKey(), state)) {
            this.getRowKeyBefore(set, state);
        }
    }

    private boolean walkForwardInSingleRow(SortedSet<KeyValue> set, KeyValue firstOnRow, GetClosestRowBeforeTracker state) {
        KeyValue kv;
        boolean foundCandidate = false;
        SortedSet<KeyValue> tail = set.tailSet(firstOnRow);
        if (tail.isEmpty()) {
            return foundCandidate;
        }
        Iterator i = tail.iterator();
        while (i.hasNext() && !state.isTooFar(kv = (KeyValue)i.next(), firstOnRow)) {
            if (state.isExpired(kv)) {
                i.remove();
                continue;
            }
            if (!state.handle(kv)) continue;
            foundCandidate = true;
            break;
        }
        return foundCandidate;
    }

    private void getRowKeyBefore(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state) {
        KeyValue firstOnRow = state.getTargetKey();
        Member p = this.memberOfPreviousRow(set, state, firstOnRow);
        while (p != null && state.isTargetTable(p.kv) && state.isBetterCandidate(p.kv) && !this.walkForwardInSingleRow(p.set, firstOnRow = new KeyValue(p.kv.getRowArray(), p.kv.getRowOffset(), (int)p.kv.getRowLength(), Long.MAX_VALUE), state)) {
            p = this.memberOfPreviousRow(p.set, state, firstOnRow);
        }
    }

    @Override
    public long updateColumnValue(byte[] row, byte[] family, byte[] qualifier, long newValue, long now) {
        KeyValue kv;
        KeyValue snKv;
        KeyValue firstKv = KeyValue.createFirstOnRow((byte[])row, (byte[])family, (byte[])qualifier);
        SortedSet<KeyValue> snSs = this.snapshot.tailSet(firstKv);
        if (!snSs.isEmpty() && (snKv = snSs.first()).matchingRow(firstKv) && snKv.matchingQualifier(firstKv) && snKv.getTimestamp() == now) {
            ++now;
        }
        SortedSet<KeyValue> ss = this.kvset.tailSet(firstKv);
        Iterator i$ = ss.iterator();
        while (i$.hasNext() && (kv = (KeyValue)i$.next()).matchingColumn(family, qualifier) && kv.matchingRow(firstKv)) {
            if (kv.getTypeByte() != KeyValue.Type.Put.getCode() || kv.getTimestamp() <= now || !firstKv.matchingQualifier(kv)) continue;
            now = kv.getTimestamp();
        }
        ArrayList<Cell> cells = new ArrayList<Cell>(1);
        cells.add((Cell)new KeyValue(row, family, qualifier, now, Bytes.toBytes((long)newValue)));
        return this.upsert(cells, 1L);
    }

    @Override
    public long upsert(Iterable<Cell> cells, long readpoint) {
        long size = 0L;
        for (Cell cell : cells) {
            size += this.upsert(cell, readpoint);
        }
        return size;
    }

    private long upsert(Cell cell, long readpoint) {
        KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)cell);
        long addedSize = this.internalAdd(kv);
        KeyValue firstKv = KeyValue.createFirstOnRow((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])kv.getQualifierArray(), (int)kv.getQualifierOffset(), (int)kv.getQualifierLength());
        SortedSet<KeyValue> ss = this.kvset.tailSet(firstKv);
        Iterator it = ss.iterator();
        int versionsVisible = 0;
        while (it.hasNext()) {
            KeyValue cur = (KeyValue)it.next();
            if (kv == cur) continue;
            if (!kv.matchingRow(cur) || !kv.matchingQualifier(cur)) break;
            if (cur.getTypeByte() != KeyValue.Type.Put.getCode() || cur.getMvccVersion() > readpoint) continue;
            if (versionsVisible > 1) {
                long delta = DefaultMemStore.heapSizeChange(cur, true);
                addedSize -= delta;
                this.size.addAndGet(-delta);
                it.remove();
                this.setOldestEditTimeToNow();
                continue;
            }
            ++versionsVisible;
        }
        return addedSize;
    }

    private Member memberOfPreviousRow(NavigableSet<KeyValue> set, GetClosestRowBeforeTracker state, KeyValue firstOnRow) {
        NavigableSet<KeyValue> head = set.headSet(firstOnRow, false);
        if (head.isEmpty()) {
            return null;
        }
        Iterator<KeyValue> i = head.descendingIterator();
        while (i.hasNext()) {
            KeyValue found = i.next();
            if (state.isExpired(found)) {
                i.remove();
                continue;
            }
            return new Member(head, found);
        }
        return null;
    }

    @Override
    public List<KeyValueScanner> getScanners(long readPt) {
        return Collections.singletonList(new MemStoreScanner(readPt));
    }

    public boolean shouldSeek(Scan scan, long oldestUnexpiredTS) {
        return (this.timeRangeTracker.includesTimeRange(scan.getTimeRange()) || this.snapshotTimeRangeTracker.includesTimeRange(scan.getTimeRange())) && Math.max(this.timeRangeTracker.getMaximumTimestamp(), this.snapshotTimeRangeTracker.getMaximumTimestamp()) >= oldestUnexpiredTS;
    }

    static long heapSizeChange(KeyValue kv, boolean notpresent) {
        return notpresent ? ClassSize.align((long)((long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + kv.heapSize())) : 0L;
    }

    private long keySize() {
        return this.heapSize() - DEEP_OVERHEAD;
    }

    public long heapSize() {
        return this.size.get();
    }

    @Override
    public long size() {
        return this.heapSize();
    }

    public static void main(String[] args) {
        int i;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
        LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        DefaultMemStore memstore1 = new DefaultMemStore();
        long size = 0L;
        int count = 10000;
        byte[] fam = Bytes.toBytes((String)"col");
        byte[] qf = Bytes.toBytes((String)"umn");
        byte[] empty = new byte[]{};
        for (i = 0; i < 10000; ++i) {
            size += memstore1.add((Cell)new KeyValue(Bytes.toBytes((int)i), fam, qf, (long)i, empty));
        }
        LOG.info((Object)("memstore1 estimated size=" + size));
        for (i = 0; i < 10000; ++i) {
            size += memstore1.add((Cell)new KeyValue(Bytes.toBytes((int)i), fam, qf, (long)i, empty));
        }
        LOG.info((Object)("memstore1 estimated size (2nd loading of same data)=" + size));
        DefaultMemStore memstore2 = new DefaultMemStore();
        for (int i2 = 0; i2 < 10000; ++i2) {
            size += memstore2.add((Cell)new KeyValue(Bytes.toBytes((int)i2), fam, qf, (long)i2, new byte[i2]));
        }
        LOG.info((Object)("memstore2 estimated size=" + size));
        int seconds = 30;
        LOG.info((Object)"Waiting 30 seconds while heap dump is taken");
        for (int i3 = 0; i3 < 30; ++i3) {
        }
        LOG.info((Object)"Exiting.");
    }

    protected class MemStoreScanner
    extends NonLazyKeyValueScanner {
        private KeyValue kvsetNextRow = null;
        private KeyValue snapshotNextRow = null;
        private KeyValue kvsetItRow = null;
        private KeyValue snapshotItRow = null;
        private Iterator<KeyValue> kvsetIt;
        private Iterator<KeyValue> snapshotIt;
        private KeyValueSkipListSet kvsetAtCreation;
        private KeyValueSkipListSet snapshotAtCreation;
        private KeyValue theNext;
        volatile MemStoreLAB allocatorAtCreation;
        volatile MemStoreLAB snapshotAllocatorAtCreation;
        private boolean stopSkippingKVsIfNextRow = false;
        private long readPoint;

        MemStoreScanner(long readPoint) {
            this.readPoint = readPoint;
            this.kvsetAtCreation = DefaultMemStore.this.kvset;
            this.snapshotAtCreation = DefaultMemStore.this.snapshot;
            if (DefaultMemStore.this.allocator != null) {
                this.allocatorAtCreation = DefaultMemStore.this.allocator;
                this.allocatorAtCreation.incScannerCount();
            }
            if (DefaultMemStore.this.snapshotAllocator != null) {
                this.snapshotAllocatorAtCreation = DefaultMemStore.this.snapshotAllocator;
                this.snapshotAllocatorAtCreation.incScannerCount();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private KeyValue getNext(Iterator<KeyValue> it) {
            KeyValue startKV = this.theNext;
            KeyValue v = null;
            try {
                while (it.hasNext()) {
                    v = it.next();
                    if (v.getMvccVersion() <= this.readPoint) {
                        KeyValue keyValue = v;
                        return keyValue;
                    }
                    if (!this.stopSkippingKVsIfNextRow || startKV == null || DefaultMemStore.this.comparator.compareRows(v, startKV) <= 0) continue;
                    KeyValue keyValue = null;
                    return keyValue;
                }
                KeyValue keyValue = null;
                return keyValue;
            }
            finally {
                if (v != null) {
                    if (it == this.snapshotIt) {
                        this.snapshotItRow = v;
                    } else {
                        this.kvsetItRow = v;
                    }
                }
            }
        }

        @Override
        public synchronized boolean seek(KeyValue key) {
            if (key == null) {
                this.close();
                return false;
            }
            this.kvsetIt = this.kvsetAtCreation.tailSet(key).iterator();
            this.snapshotIt = this.snapshotAtCreation.tailSet(key).iterator();
            this.kvsetItRow = null;
            this.snapshotItRow = null;
            return this.seekInSubLists(key);
        }

        private synchronized boolean seekInSubLists(KeyValue key) {
            this.kvsetNextRow = this.getNext(this.kvsetIt);
            this.snapshotNextRow = this.getNext(this.snapshotIt);
            this.theNext = this.getLowest(this.kvsetNextRow, this.snapshotNextRow);
            return this.theNext != null;
        }

        @Override
        public synchronized boolean reseek(KeyValue key) {
            this.kvsetIt = this.kvsetAtCreation.tailSet(this.getHighest(key, this.kvsetItRow)).iterator();
            this.snapshotIt = this.snapshotAtCreation.tailSet(this.getHighest(key, this.snapshotItRow)).iterator();
            return this.seekInSubLists(key);
        }

        @Override
        public synchronized KeyValue peek() {
            return this.theNext;
        }

        @Override
        public synchronized KeyValue next() {
            if (this.theNext == null) {
                return null;
            }
            KeyValue ret = this.theNext;
            if (this.theNext == this.kvsetNextRow) {
                this.kvsetNextRow = this.getNext(this.kvsetIt);
            } else {
                this.snapshotNextRow = this.getNext(this.snapshotIt);
            }
            this.theNext = this.getLowest(this.kvsetNextRow, this.snapshotNextRow);
            return ret;
        }

        private KeyValue getLowest(KeyValue first, KeyValue second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = DefaultMemStore.this.comparator.compare((Cell)first, (Cell)second);
                return compare <= 0 ? first : second;
            }
            return first != null ? first : second;
        }

        private KeyValue getHighest(KeyValue first, KeyValue second) {
            if (first == null && second == null) {
                return null;
            }
            if (first != null && second != null) {
                int compare = DefaultMemStore.this.comparator.compare((Cell)first, (Cell)second);
                return compare > 0 ? first : second;
            }
            return first != null ? first : second;
        }

        @Override
        public synchronized void close() {
            this.kvsetNextRow = null;
            this.snapshotNextRow = null;
            this.kvsetIt = null;
            this.snapshotIt = null;
            if (this.allocatorAtCreation != null) {
                this.allocatorAtCreation.decScannerCount();
                this.allocatorAtCreation = null;
            }
            if (this.snapshotAllocatorAtCreation != null) {
                this.snapshotAllocatorAtCreation.decScannerCount();
                this.snapshotAllocatorAtCreation = null;
            }
            this.kvsetItRow = null;
            this.snapshotItRow = null;
        }

        @Override
        public long getSequenceID() {
            return Long.MAX_VALUE;
        }

        @Override
        public boolean shouldUseScanner(Scan scan, SortedSet<byte[]> columns, long oldestUnexpiredTS) {
            return DefaultMemStore.this.shouldSeek(scan, oldestUnexpiredTS);
        }

        @Override
        public synchronized boolean backwardSeek(KeyValue key) {
            this.seek(key);
            if (this.peek() == null || DefaultMemStore.this.comparator.compareRows(this.peek(), key) > 0) {
                return this.seekToPreviousRow(key);
            }
            return true;
        }

        @Override
        public synchronized boolean seekToPreviousRow(KeyValue key) {
            SortedSet<KeyValue> snapshotHead;
            KeyValue snapshotBeforeRow;
            KeyValue firstKeyOnRow = KeyValue.createFirstOnRow((byte[])key.getRow());
            SortedSet<KeyValue> kvHead = this.kvsetAtCreation.headSet(firstKeyOnRow);
            KeyValue kvsetBeforeRow = kvHead.isEmpty() ? null : kvHead.last();
            KeyValue lastKVBeforeRow = this.getHighest(kvsetBeforeRow, snapshotBeforeRow = (snapshotHead = this.snapshotAtCreation.headSet(firstKeyOnRow)).isEmpty() ? null : snapshotHead.last());
            if (lastKVBeforeRow == null) {
                this.theNext = null;
                return false;
            }
            KeyValue firstKeyOnPreviousRow = KeyValue.createFirstOnRow((byte[])lastKVBeforeRow.getRow());
            this.stopSkippingKVsIfNextRow = true;
            this.seek(firstKeyOnPreviousRow);
            this.stopSkippingKVsIfNextRow = false;
            if (this.peek() == null || DefaultMemStore.this.comparator.compareRows(this.peek(), firstKeyOnPreviousRow) > 0) {
                return this.seekToPreviousRow(lastKVBeforeRow);
            }
            return true;
        }

        @Override
        public synchronized boolean seekToLastRow() {
            KeyValue second;
            KeyValue first = this.kvsetAtCreation.isEmpty() ? null : this.kvsetAtCreation.last();
            KeyValue higherKv = this.getHighest(first, second = this.snapshotAtCreation.isEmpty() ? null : this.snapshotAtCreation.last());
            if (higherKv == null) {
                return false;
            }
            KeyValue firstKvOnLastRow = KeyValue.createFirstOnRow((byte[])higherKv.getRow());
            if (this.seek(firstKvOnLastRow)) {
                return true;
            }
            return this.seekToPreviousRow(higherKv);
        }
    }

    private static class Member {
        final KeyValue kv;
        final NavigableSet<KeyValue> set;

        Member(NavigableSet<KeyValue> s, KeyValue kv) {
            this.kv = kv;
            this.set = s;
        }
    }
}

