/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.NavigableSet;
import java.util.UUID;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.mob.MobCacheConfig;
import org.apache.hadoop.hbase.mob.MobFile;
import org.apache.hadoop.hbase.mob.MobFileName;
import org.apache.hadoop.hbase.mob.MobStoreEngine;
import org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hadoop.hbase.mob.MobZookeeper;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MobReferenceOnlyFilter;
import org.apache.hadoop.hbase.regionserver.MobStoreScanner;
import org.apache.hadoop.hbase.regionserver.ReversedMobStoreScanner;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreEngine;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class HMobStore
extends HStore {
    private MobCacheConfig mobCacheConfig;
    private Path homePath;
    private Path mobFamilyPath;
    private List<Path> mobDirLocations;

    public HMobStore(HRegion region, HColumnDescriptor family, Configuration confParam) throws IOException {
        super(region, family, confParam);
        this.mobCacheConfig = (MobCacheConfig)this.cacheConf;
        this.homePath = MobUtils.getMobHome(this.conf);
        this.mobFamilyPath = MobUtils.getMobFamilyPath(this.conf, this.getTableName(), family.getNameAsString());
        this.mobDirLocations = new ArrayList<Path>();
        this.mobDirLocations.add(this.mobFamilyPath);
        TableName tn = region.getTableDesc().getTableName();
        this.mobDirLocations.add(HFileArchiveUtil.getStoreArchivePath(this.conf, tn, MobUtils.getMobRegionInfo(tn).getEncodedName(), family.getNameAsString()));
    }

    @Override
    protected void createCacheConf(HColumnDescriptor family) {
        this.cacheConf = new MobCacheConfig(this.conf, family);
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    protected KeyValueScanner createScanner(Scan scan, NavigableSet<byte[]> targetCols, long readPt, KeyValueScanner scanner) throws IOException {
        if (scanner == null) {
            if (MobUtils.isRefOnlyScan(scan)) {
                MobReferenceOnlyFilter refOnlyFilter = new MobReferenceOnlyFilter();
                Filter filter = scan.getFilter();
                if (filter != null) {
                    scan.setFilter((Filter)new FilterList(new Filter[]{filter, refOnlyFilter}));
                } else {
                    scan.setFilter((Filter)refOnlyFilter);
                }
            }
            scanner = scan.isReversed() ? new ReversedMobStoreScanner(this, this.getScanInfo(), scan, targetCols, readPt) : new MobStoreScanner(this, this.getScanInfo(), scan, targetCols, readPt);
        }
        return scanner;
    }

    @Override
    protected StoreEngine<?, ?, ?, ?> createStoreEngine(Store store, Configuration conf, KeyValue.KVComparator kvComparator) throws IOException {
        MobStoreEngine engine = new MobStoreEngine();
        engine.createComponents(conf, store, kvComparator);
        return engine;
    }

    private Path getTempDir() {
        return new Path(this.homePath, ".tmp");
    }

    public StoreFile.Writer createWriterInTmp(Date date, long maxKeyCount, Compression.Algorithm compression, byte[] startKey) throws IOException {
        if (startKey == null) {
            startKey = HConstants.EMPTY_START_ROW;
        }
        Path path = this.getTempDir();
        return this.createWriterInTmp(MobUtils.formatDate(date), path, maxKeyCount, compression, startKey);
    }

    public StoreFile.Writer createWriterInTmp(String date, Path basePath, long maxKeyCount, Compression.Algorithm compression, byte[] startKey) throws IOException {
        MobFileName mobFileName = MobFileName.create(startKey, date, UUID.randomUUID().toString().replaceAll("-", ""));
        MobCacheConfig writerCacheConf = this.mobCacheConfig;
        HFileContext hFileContext = new HFileContextBuilder().withCompression(compression).withIncludesMvcc(false).withIncludesTags(true).withChecksumType(HFile.DEFAULT_CHECKSUM_TYPE).withBytesPerCheckSum(16384).withBlockSize(this.getFamily().getBlocksize()).withHBaseCheckSum(true).withDataBlockEncoding(this.getFamily().getDataBlockEncoding()).build();
        StoreFile.Writer w = new StoreFile.WriterBuilder(this.conf, writerCacheConf, this.region.getFilesystem()).withFilePath(new Path(basePath, mobFileName.getFileName())).withComparator(KeyValue.COMPARATOR).withBloomType(BloomType.NONE).withMaxKeyCount(maxKeyCount).withFileContext(hFileContext).build();
        return w;
    }

    public void commitFile(Path sourceFile, Path targetPath) throws IOException {
        if (sourceFile == null) {
            return;
        }
        Path dstPath = new Path(targetPath, sourceFile.getName());
        this.validateMobFile(sourceFile);
        String msg = "Renaming flushed file from " + sourceFile + " to " + dstPath;
        LOG.info((Object)msg);
        Path parent = dstPath.getParent();
        if (!this.region.getFilesystem().exists(parent)) {
            this.region.getFilesystem().mkdirs(parent);
        }
        if (!this.region.getFilesystem().rename(sourceFile, dstPath)) {
            throw new IOException("Failed rename of " + sourceFile + " to " + dstPath);
        }
    }

    private void validateMobFile(Path path) throws IOException {
        StoreFile storeFile = null;
        try {
            storeFile = new StoreFile(this.region.getFilesystem(), path, this.conf, (CacheConfig)this.mobCacheConfig, BloomType.NONE);
            storeFile.createReader();
        }
        catch (IOException e) {
            LOG.error((Object)("Fail to open mob file[" + path + "], keep it in temp directory."), (Throwable)e);
            throw e;
        }
        finally {
            if (storeFile != null) {
                storeFile.closeReader(false);
            }
        }
    }

    public Cell resolve(Cell reference, boolean cacheBlocks) throws IOException {
        Cell result = null;
        if (MobUtils.hasValidMobRefCellValue(reference)) {
            String fileName = MobUtils.getMobFileName(reference);
            result = this.readCell(fileName, reference, cacheBlocks);
        }
        if (result == null) {
            LOG.warn((Object)"The KeyValue result is null, assemble a new KeyValue with the same row,family,qualifier,timestamp,type and tags but with an empty value to return.");
            result = new KeyValue(reference.getRowArray(), reference.getRowOffset(), (int)reference.getRowLength(), reference.getFamilyArray(), reference.getFamilyOffset(), (int)reference.getFamilyLength(), reference.getQualifierArray(), reference.getQualifierOffset(), reference.getQualifierLength(), reference.getTimestamp(), KeyValue.Type.codeToType((byte)reference.getTypeByte()), HConstants.EMPTY_BYTE_ARRAY, 0, 0, reference.getTagsArray(), reference.getTagsOffset(), (int)reference.getTagsLength());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cell readCell(String fileName, Cell search, boolean cacheMobBlocks) throws IOException {
        FileSystem fs = this.getFileSystem();
        for (Path location : this.mobDirLocations) {
            MobFile file = null;
            Path path = new Path(location, fileName);
            try {
                file = this.mobCacheConfig.getMobFileCache().openFile(fs, path, this.mobCacheConfig);
                Cell cell = file.readCell(search, cacheMobBlocks);
                return cell;
            }
            catch (IOException e) {
                this.mobCacheConfig.getMobFileCache().evictFile(fileName);
                if (e instanceof FileNotFoundException) {
                    LOG.warn((Object)("Fail to read the cell, the mob file " + path + " doesn't exist"), (Throwable)e);
                    continue;
                }
                throw e;
            }
            finally {
                if (file == null) continue;
                this.mobCacheConfig.getMobFileCache().closeFile(file);
            }
        }
        LOG.error((Object)("The mob file " + fileName + " could not be found in the locations " + this.mobDirLocations));
        return null;
    }

    public Path getPath() {
        return this.mobFamilyPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<StoreFile> compact(CompactionContext compaction) throws IOException {
        if (compaction.getRequest().isMajor()) {
            String compactionName = UUID.randomUUID().toString().replaceAll("-", "");
            MobZookeeper zk = null;
            try {
                zk = MobZookeeper.newInstance(this.region.getBaseConf(), compactionName);
            }
            catch (KeeperException e) {
                LOG.error((Object)"Cannot connect to the zookeeper, ready to perform the minor compaction instead", (Throwable)e);
                compaction.getRequest().setIsMajor(false);
                return super.compact(compaction);
            }
            boolean major = false;
            try {
                List<StoreFile> list;
                block28: {
                    block26: {
                        List<StoreFile> list2;
                        block27: {
                            if (zk.lockColumnFamily(this.getTableName().getNameAsString(), this.getFamily().getNameAsString())) {
                                try {
                                    LOG.info((Object)("Obtain the lock for the store[" + this + "], ready to perform the major compaction"));
                                    boolean hasSweeper = zk.isSweeperZNodeExist(this.getTableName().getNameAsString(), this.getFamily().getNameAsString());
                                    if (!hasSweeper) {
                                        major = zk.addMajorCompactionZNode(this.getTableName().getNameAsString(), this.getFamily().getNameAsString(), compactionName);
                                    }
                                }
                                catch (Exception e) {
                                    LOG.error((Object)"Fail to handle the Zookeeper", (Throwable)e);
                                }
                                finally {
                                    zk.unlockColumnFamily(this.getTableName().getNameAsString(), this.getFamily().getNameAsString());
                                }
                            }
                            try {
                                if (!major) break block26;
                                list2 = super.compact(compaction);
                                if (!major) break block27;
                            }
                            catch (Throwable throwable) {
                                if (major) {
                                    try {
                                        zk.deleteMajorCompactionZNode(this.getTableName().getNameAsString(), this.getFamily().getNameAsString(), compactionName);
                                    }
                                    catch (KeeperException e) {
                                        LOG.error((Object)("Fail to delete the compaction znode" + compactionName), (Throwable)e);
                                    }
                                }
                                throw throwable;
                            }
                            try {
                                zk.deleteMajorCompactionZNode(this.getTableName().getNameAsString(), this.getFamily().getNameAsString(), compactionName);
                            }
                            catch (KeeperException e) {
                                LOG.error((Object)("Fail to delete the compaction znode" + compactionName), (Throwable)e);
                            }
                        }
                        return list2;
                    }
                    LOG.warn((Object)("Cannot obtain the lock or a sweep tool is running on this store[" + this + "], ready to perform the minor compaction instead"));
                    compaction.getRequest().setIsMajor(false);
                    list = super.compact(compaction);
                    if (!major) break block28;
                    try {
                        zk.deleteMajorCompactionZNode(this.getTableName().getNameAsString(), this.getFamily().getNameAsString(), compactionName);
                    }
                    catch (KeeperException e) {
                        LOG.error((Object)("Fail to delete the compaction znode" + compactionName), (Throwable)e);
                    }
                }
                return list;
            }
            finally {
                zk.close();
            }
        }
        return super.compact(compaction);
    }
}

