/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MemStoreSnapshot;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.compactions.Compactor;

@InterfaceAudience.Private
abstract class StoreFlusher {
    protected Configuration conf;
    protected Store store;

    public StoreFlusher(Configuration conf, Store store) {
        this.conf = conf;
        this.store = store;
    }

    public abstract List<Path> flushSnapshot(MemStoreSnapshot var1, long var2, MonitoredTask var4) throws IOException;

    protected void finalizeWriter(StoreFile.Writer writer, long cacheFlushSeqNum, MonitoredTask status) throws IOException {
        status.setStatus("Flushing " + this.store + ": appending metadata");
        writer.appendMetadata(cacheFlushSeqNum, false);
        status.setStatus("Flushing " + this.store + ": closing flushed file");
        writer.close();
    }

    protected InternalScanner createScanner(KeyValueScanner snapshotScanner, long smallestReadPoint) throws IOException {
        InternalScanner scanner = null;
        if (this.store.getCoprocessorHost() != null) {
            scanner = this.store.getCoprocessorHost().preFlushScannerOpen(this.store, snapshotScanner);
        }
        if (scanner == null) {
            Scan scan = new Scan();
            scan.setMaxVersions(this.store.getScanInfo().getMaxVersions());
            scanner = new StoreScanner(this.store, this.store.getScanInfo(), scan, Collections.singletonList(snapshotScanner), ScanType.COMPACT_RETAIN_DELETES, smallestReadPoint, Long.MIN_VALUE);
        }
        assert (scanner != null);
        if (this.store.getCoprocessorHost() != null) {
            try {
                return this.store.getCoprocessorHost().preFlush(this.store, scanner);
            }
            catch (IOException ioe) {
                scanner.close();
                throw ioe;
            }
        }
        return scanner;
    }

    protected void performFlush(InternalScanner scanner, Compactor.CellSink sink, long smallestReadPoint) throws IOException {
        boolean hasMore;
        int compactionKVMax = this.conf.getInt("hbase.hstore.compaction.kv.max", 10);
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        do {
            hasMore = scanner.next(kvs, compactionKVMax);
            if (kvs.isEmpty()) continue;
            for (Cell c : kvs) {
                KeyValue kv = KeyValueUtil.ensureKeyValue((Cell)c);
                if (kv.getMvccVersion() <= smallestReadPoint) {
                    kv = kv.shallowCopy();
                    kv.setMvccVersion(0L);
                }
                sink.append(kv);
            }
            kvs.clear();
        } while (hasMore);
    }
}

