/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tmpl.regionserver;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.BlockCacheUtil;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketAllocator;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCache;
import org.apache.hadoop.hbase.io.hfile.bucket.BucketCacheStats;
import org.apache.hadoop.hbase.io.hfile.slab.SingleSizeCache;
import org.apache.hadoop.hbase.io.hfile.slab.SlabCache;
import org.apache.hadoop.hbase.tmpl.regionserver.BlockCacheTmpl;
import org.apache.hadoop.util.StringUtils;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class BlockCacheTmplImpl
extends AbstractTemplateImpl
implements BlockCacheTmpl.Intf {
    private final CacheConfig cacheConfig;
    private final Configuration config;

    protected static BlockCacheTmpl.ImplData __jamon_setOptionalArguments(BlockCacheTmpl.ImplData p_implData) {
        return p_implData;
    }

    public BlockCacheTmplImpl(TemplateManager p_templateManager, BlockCacheTmpl.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)BlockCacheTmplImpl.__jamon_setOptionalArguments(p_implData));
        this.cacheConfig = p_implData.getCacheConfig();
        this.config = p_implData.getConfig();
    }

    @Override
    public void renderNoFlush(Writer jamonWriter) throws IOException {
        BlockCache bc = this.cacheConfig == null ? null : this.cacheConfig.getBlockCache();
        String bcUrl = null;
        String bcName = null;
        if (bc != null) {
            bcUrl = "http://hbase.apache.org/devapidocs/" + bc.getClass().getName().replaceAll("\\.", "/") + ".html";
            bcName = bc.getClass().getSimpleName();
        }
        BlockCache[] bcs = this.cacheConfig == null ? null : (this.cacheConfig.getBlockCache() == null ? null : this.cacheConfig.getBlockCache().getBlockCaches());
        jamonWriter.write("<div class=\"tabbable\">\n    <ul class=\"nav nav-pills\">\n        <li class=\"active\"><a href=\"#tab_bc_baseInfo\" data-toggle=\"tab\">Base Info</a></li>\n        <li class=\"\"><a href=\"#tab_bc_config\" data-toggle=\"tab\">Config</a></li>\n        <li class=\"\"><a href=\"#tab_bc_stats\" data-toggle=\"tab\">Stats</a></li>\n        <li class=\"\"><a href=\"#tab_bc_l1\" data-toggle=\"tab\">L1</a></li>\n        <li class=\"\"><a href=\"#tab_bc_l2\" data-toggle=\"tab\">L2</a></li>\n    </ul>\n    <div class=\"tab-content\" style=\"padding-bottom: 9px; border-bottom: 1px solid #ddd;\">\n        <div class=\"tab-pane active\" id=\"tab_bc_baseInfo\">\n            ");
        this.__jamon_innerUnit__bc_baseInfo(jamonWriter, this.cacheConfig, bcUrl, bcName);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_config\">\n            ");
        this.__jamon_innerUnit__bc_config(jamonWriter, this.cacheConfig);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_stats\">\n            ");
        this.__jamon_innerUnit__bc_stats(jamonWriter, this.cacheConfig);
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_l1\">\n            ");
        this.__jamon_innerUnit__bc_l(jamonWriter, bcs == null ? bc : bcs[0], "L1");
        jamonWriter.write("\n        </div>\n        <div class=\"tab-pane\" id=\"tab_bc_l2\">\n            ");
        this.__jamon_innerUnit__bc_l(jamonWriter, bcs == null ? null : (bcs.length <= 1 ? null : bcs[1]), "L2");
        jamonWriter.write("\n        </div>\n    </div>\n</div>\n\n");
    }

    private void __jamon_innerUnit__bc_stats(Writer jamonWriter, CacheConfig cacheConfig) throws IOException {
        if (cacheConfig == null) {
            jamonWriter.write("\n<p>CacheConfig is null</p>\n");
        } else {
            jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Size</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)cacheConfig.getBlockCache().size())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Total size of Block Cache (bytes)</td>\n    </tr>\n    <tr>\n        <td>Free</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)cacheConfig.getBlockCache().getFreeSize())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Free space in Block Cache (bytes)</td>\n    </tr>\n    <tr>\n        <td>Count</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cacheConfig.getBlockCache().getBlockCount())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Number of blocks in Block Cache</td>\n    </tr>\n    <tr>\n        <td>Evicted</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cacheConfig.getBlockCache().getStats().getEvictedCount())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Number of blocks evicted</td>\n    </tr>\n    <tr>\n        <td>Evictions</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cacheConfig.getBlockCache().getStats().getEvictionCount())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Number of times an eviction occurred</td>\n    </tr>\n    <tr>\n        <td>Hits</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cacheConfig.getBlockCache().getStats().getHitCount())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Number requests that were cache hits</td>\n    </tr>\n    <tr>\n        <td>Hits Caching</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cacheConfig.getBlockCache().getStats().getHitCachingCount())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Cache hit block requests but only requests set to use Block Cache</td>\n    </tr>\n    <tr>\n        <td>Misses</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cacheConfig.getBlockCache().getStats().getMissCount())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Number of requests that were cache misses</td>\n    </tr>\n    <tr>\n        <td>Misses Caching</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cacheConfig.getBlockCache().getStats().getMissCount())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Block requests that were cache misses but only requests set to use Block Cache</td>\n    </tr>\n    <tr>\n        <td>Hit Ratio</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,.2f", cacheConfig.getBlockCache().getStats().getHitRatio() * 100.0)), jamonWriter);
            Escaping.HTML.write(StandardEmitter.valueOf((String)"%"), jamonWriter);
            jamonWriter.write("</td>\n        <td>Hit Count divided by total requests count</td>\n    </tr>\n</table>\n<p>If Block Cache is made up of more than one cache -- i.e. a L1 and a L2 -- then the above\nare combined counts. Request count is sum of hits and misses.</p>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__bc_config(Writer jamonWriter, CacheConfig cacheConfig) throws IOException {
        if (cacheConfig == null) {
            jamonWriter.write("\n<p>CacheConfig is null</p>\n");
        } else {
            jamonWriter.write("\n<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Cache DATA on Read</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldCacheDataOnRead()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if DATA blocks are cached on read\n        (INDEX & BLOOM blocks are always cached)</td>\n    </tr>\n    <tr>\n        <td>Cache DATA on Write</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldCacheDataOnWrite()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if DATA blocks are cached on write.</td>\n    </tr>\n    <tr>\n        <td>Cache INDEX on Write</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldCacheIndexesOnWrite()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if INDEX blocks are cached on write</td>\n    </tr>\n    <tr>\n        <td>Cache BLOOM on Write</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldCacheBloomsOnWrite()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if BLOOM blocks are cached on write</td>\n    </tr>\n    <tr>\n        <td>Evict blocks on Close</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldEvictOnClose()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if blocks are evicted from cache when an HFile\n        reader is closed</td>\n    </tr>\n    <tr>\n        <td>Compress blocks</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldCacheCompressed()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if blocks are compressed in cache</td>\n    </tr>\n    <tr>\n        <td>Prefetch on Open</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((boolean)cacheConfig.shouldPrefetchOnOpen()), jamonWriter);
            jamonWriter.write("</td>\n        <td>True if blocks are prefetched into cache on open</td>\n    </tr>\n</table>\n");
        }
        jamonWriter.write("\n");
    }

    private void __jamon_innerUnit__bc_baseInfo(Writer jamonWriter, CacheConfig cacheConfig, String bcUrl, String bcName) throws IOException {
        BlockCache bc = cacheConfig == null ? null : cacheConfig.getBlockCache();
        BlockCache[] bcs = bc == null ? null : bc.getBlockCaches();
        String bcl1Url = null;
        String bcl1Name = null;
        String bcl2Url = null;
        String bcl2Name = null;
        if (bcs != null) {
            BlockCache bcl1 = bcs[0];
            if (bcl1 != null) {
                bcl1Url = "http://hbase.apache.org/devapidocs/" + bcl1.getClass().getName().replaceAll("\\.", "/") + ".html";
                bcl1Name = bcl1.getClass().getSimpleName();
            }
            if (bcs.length == 2) {
                BlockCache bcl2 = bcs[1];
                bcl2Url = "http://hbase.apache.org/devapidocs/" + bcl2.getClass().getName().replaceAll("\\.", "/") + ".html";
                bcl2Name = bcl2.getClass().getSimpleName();
            }
        }
        jamonWriter.write("<table class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    </tr>\n    <tr>\n        <td>Implementation</td>\n        <td><a href=\"");
        Escaping.HTML.write(StandardEmitter.valueOf((String)bcUrl), jamonWriter);
        jamonWriter.write("\">");
        Escaping.HTML.write(StandardEmitter.valueOf((String)bcName), jamonWriter);
        jamonWriter.write("</a></td>\n        <td>Block Cache implementing class</td>\n    </tr>\n</table>\n<p>See <a href=\"http://hbase.apache.org/book.html#block.cache\">Block Cache</a> in the HBase Reference Guide for help.</p>\n");
    }

    private void __jamon_innerUnit__block_cache(Writer jamonWriter, BlockCache bc, String name) throws IOException {
        long nanosPerSecond = 1000000000L;
        String bcUrl = "http://hbase.apache.org/devapidocs/" + bc.getClass().getName().replaceAll("\\.", "/") + ".html";
        String bcName = bc.getClass().getSimpleName();
        BlockCacheUtil.CachedBlocksByFile cbsbf = BlockCacheUtil.getLoadedCachedBlocksByFile(this.config, bc);
        BlockCacheUtil.AgeSnapshot snapshot = cbsbf.getAgeSnapshot();
        boolean slabCache = bc.getClass().getSimpleName().equals("SlabCache");
        Map<Integer, SingleSizeCache> sizer = null;
        boolean bucketCache = bc.getClass().getSimpleName().equals("BucketCache");
        BucketCacheStats bucketCacheStats = null;
        BucketAllocator bucketAllocator = null;
        BucketAllocator.Bucket[] buckets = null;
        if (slabCache) {
            sizer = ((SlabCache)bc).getSizer();
        } else if (bucketCache) {
            bucketCacheStats = (BucketCacheStats)bc.getStats();
            bucketAllocator = ((BucketCache)bc).getAllocator();
            buckets = bucketAllocator.getBuckets();
        }
        if (cbsbf.isFull()) {
            jamonWriter.write("\n<p><b>Statistics below is based on sampling first ");
            Escaping.HTML.write(StandardEmitter.valueOf((double)snapshot.getMax()), jamonWriter);
            jamonWriter.write(" blocks only</b> (hbase.ui.blockcache.by.file.max)</p> \n");
        }
        jamonWriter.write("\n<table id=\"blocks_summary\" class=\"table table-striped\">\n    <tr>\n        <th>Attribute</th>\n        <th>Value</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td>Implementation</td>\n        <td><a href=\"");
        Escaping.HTML.write(StandardEmitter.valueOf((String)bcUrl), jamonWriter);
        jamonWriter.write("\">");
        Escaping.HTML.write(StandardEmitter.valueOf((String)bc.getClass().getSimpleName()), jamonWriter);
        jamonWriter.write("</a></td>\n        <td>Class implementing this Block Cache Level</td>\n    </tr>\n");
        if (bucketCache) {
            jamonWriter.write("\n    <tr>\n        <td>Implementation</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)((BucketCache)bc).getIoEngine()), jamonWriter);
            jamonWriter.write("</a></td>\n        <td>IOEngine</td>\n    </tr>\n");
        }
        jamonWriter.write("\n    <tr>\n        <td>Count</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cbsbf.getCount())), jamonWriter);
        jamonWriter.write("</td>\n        <td>Count of Blocks</td>\n    </tr>\n");
        if (!bucketCache) {
            jamonWriter.write("\n    <tr>\n        <td>Count</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", cbsbf.getDataCount())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Count of DATA Blocks</td>\n    </tr>\n");
        }
        jamonWriter.write("\n    <tr>\n        <td>Size</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)cbsbf.getSize())), jamonWriter);
        jamonWriter.write("</td>\n        <td>Size of Blocks</td>\n    </tr>\n");
        if (!bucketCache) {
            jamonWriter.write("\n    <tr>\n        <td>Size</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)cbsbf.getDataSize())), jamonWriter);
            jamonWriter.write("</td>\n        <td>Size of DATA Blocks</td>\n    </tr>\n");
        }
        jamonWriter.write("\n    <tr>\n        <td>Evicted</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", bc.getStats().getEvictedCount())), jamonWriter);
        jamonWriter.write("</td>\n        <td>The total number of blocks evicted</td>\n    </tr>\n    <tr>\n        <td>Evictions</td>\n        <td>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", bc.getStats().getEvictionCount())), jamonWriter);
        jamonWriter.write("</td>\n        <td>The total number of times an eviction has occurred</td>\n    </tr>\n");
        if (!slabCache) {
            jamonWriter.write("\n    <tr>\n        <td>Mean</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", (long)(snapshot.getMean() / 1.0E9))), jamonWriter);
            jamonWriter.write("</td>\n        <td>Mean age of Blocks in cache (seconds)</td>\n    </tr>\n    <tr>\n        <td>StdDev</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", (long)(snapshot.getStdDev() / 1.0E9))), jamonWriter);
            jamonWriter.write("</td>\n        <td>Age standard deviation of Blocks in cache</td>\n    </tr>\n    <tr>\n        <td>Min</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", (long)(snapshot.getMin() / 1.0E9))), jamonWriter);
            jamonWriter.write("</td>\n        <td>Min age of Blocks in cache (seconds)</td>\n    </tr>\n    <tr>\n        <td>Max</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", (long)(snapshot.getMax() / 1.0E9))), jamonWriter);
            jamonWriter.write("</td>\n        <td>Max age of Blocks in cache (seconds)</td>\n    </tr>\n    <tr>\n        <td>95th Percentile</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", (long)(snapshot.get95thPercentile() / 1.0E9))), jamonWriter);
            jamonWriter.write("</td>\n        <td>95th percentile of age of Blocks in cache (seconds)</td>\n    </tr>\n    <tr>\n        <td>99th Percentile</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,d", (long)(snapshot.get99thPercentile() / 1.0E9))), jamonWriter);
            jamonWriter.write("</td>\n        <td>99th percentile of age of Blocks in cache (seconds)</td>\n    </tr>\n");
        }
        jamonWriter.write("\n");
        if (bucketCache) {
            jamonWriter.write("\n    <tr>\n        <td>Hits per Second</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((long)bucketCacheStats.getIOHitsPerSecond()), jamonWriter);
            jamonWriter.write("</td>\n        <td>Block gets against this cache per second</td>\n    </tr>\n    <tr>\n        <td>Time per Hit</td>\n        <td>");
            Escaping.HTML.write(StandardEmitter.valueOf((double)bucketCacheStats.getIOTimePerHit()), jamonWriter);
            jamonWriter.write("</td>\n        <td>Time per cache hit</td>\n    </tr>\n");
        }
        jamonWriter.write("\n</table>\n<p>View Block Cache <a href=\"?format=json&bcn=");
        Escaping.HTML.write(StandardEmitter.valueOf((String)name), jamonWriter);
        jamonWriter.write("\">as JSON</a> | Block Cache <a href=\"?format=json&bcn=");
        Escaping.HTML.write(StandardEmitter.valueOf((String)name), jamonWriter);
        jamonWriter.write("&bcv=file\">as JSON by file</a></p>\n");
        if (bucketCache) {
            jamonWriter.write("\n<p>BucketCache does not discern between DATA and META blocks so we do not show DATA counts (If deploy is using CombinedBlockCache, BucketCache is only DATA blocks</p>\n<h3>BucketCache Buckets</h3>\n<table class=\"table table-striped\">\n    <tr>\n        <th>Bucket Offset</th>\n        <th>Allocation Size</th>\n        <th>Free Count</th>\n        <th>Used Count</th>\n    </tr>\n");
            for (BucketAllocator.Bucket bucket : buckets) {
                jamonWriter.write("\n    <tr>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((long)bucket.getBaseOffset()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)bucket.getItemAllocationSize()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)bucket.getFreeBytes()), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((int)bucket.getUsedBytes()), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n");
            }
            jamonWriter.write("\n</table>\n");
        } else if (slabCache) {
            jamonWriter.write("\n<p>SlabCache does not keep account of block ages so can not show stats on how long blocks have been cached.</p>\n<h3>SlabCache Slabs</h3>\n<table class=\"table table-striped\">\n    <tr>\n        <th>Block Size</th>\n        <th>Size</th>\n        <th>Free Size</th>\n        <th>Count</th>\n        <th>Evicted</th>\n        <th>Evictions</th>\n        <th>Hits</th>\n        <th>Caching</th>\n        <th>Misses</th>\n        <th>Caching</th>\n        <th>Hit Ratio</th>\n    </tr>\n");
            for (Map.Entry<Integer, SingleSizeCache> e : sizer.entrySet()) {
                jamonWriter.write("\n    <tr>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)e.getKey().intValue())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)e.getValue().size())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)e.getValue().getFreeSize())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)e.getValue().getBlockCount())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)e.getValue().getStats().getEvictedCount())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)e.getValue().getStats().getEvictionCount())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)e.getValue().getStats().getHitCount())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)e.getValue().getStats().getHitCachingCount())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)e.getValue().getStats().getMissCount())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)StringUtils.humanReadableInt((long)e.getValue().getStats().getMissCachingCount())), jamonWriter);
                jamonWriter.write("</td>\n        <td>");
                Escaping.HTML.write(StandardEmitter.valueOf((String)String.format("%,.2f", e.getValue().getStats().getHitRatio() * 100.0)), jamonWriter);
                Escaping.HTML.write(StandardEmitter.valueOf((String)"%"), jamonWriter);
                jamonWriter.write("</td>\n    </tr>\n");
            }
            jamonWriter.write("\n</table>\n");
        }
        jamonWriter.write("\n");
        cbsbf = null;
    }

    private void __jamon_innerUnit__bc_l(Writer jamonWriter, BlockCache bc, String name) throws IOException {
        if (bc == null) {
            jamonWriter.write("\n<p>No ");
            Escaping.HTML.write(StandardEmitter.valueOf((String)name), jamonWriter);
            jamonWriter.write(" deployed</p>\n");
        } else {
            jamonWriter.write("\n");
            this.__jamon_innerUnit__block_cache(jamonWriter, bc, name);
            jamonWriter.write("\n");
        }
        jamonWriter.write("\n");
    }
}

