/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.sequence;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.Sequence;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceDescription;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sequence.SequenceRegistry;
import org.pentaho.reporting.libraries.designtime.swing.KeyedComboBoxModel;
import org.pentaho.reporting.libraries.designtime.swing.VerticalLayout;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;
import org.pentaho.reporting.libraries.designtime.swing.table.PropertyTable;
import org.pentaho.reporting.ui.datasources.sequence.Messages;
import org.pentaho.reporting.ui.datasources.sequence.SequencePropertyTableModel;

public class SequenceEditor
extends JComponent {
    private static Log logger = LogFactory.getLog(SequenceEditor.class);
    private Sequence sequence;
    private JComboBox sequenceGroupBox;
    private JComboBox sequenceNameBox;
    private PropertyTable propertyTable;
    private SequenceRegistry registry = new SequenceRegistry();
    private KeyedComboBoxModel<Sequence, String> sequenceModel;
    private SequencePropertyTableModel propertyTableModel;
    private boolean disableSequenceUpdate;

    public SequenceEditor() {
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        DefaultComboBoxModel<String> groupModel = new DefaultComboBoxModel<String>(this.registry.getSequenceGroups(Locale.getDefault()));
        groupModel.addListDataListener(new SelectGroupAction());
        this.sequenceGroupBox = new JComboBox();
        this.sequenceGroupBox.setModel(groupModel);
        this.sequenceModel = new KeyedComboBoxModel();
        this.sequenceModel.addListDataListener((ListDataListener)new SequenceSelectionHandler());
        this.sequenceNameBox = new JComboBox(this.sequenceModel);
        this.propertyTableModel = new SequencePropertyTableModel();
        this.propertyTable = new PropertyTable();
        this.propertyTable.setModel((TableModel)this.propertyTableModel);
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout((LayoutManager)new VerticalLayout(5, 3));
        headerPanel.add(new JLabel(Messages.getString("SequenceEditor.Group")));
        headerPanel.add(this.sequenceGroupBox);
        headerPanel.add(new JLabel(Messages.getString("SequenceEditor.Sequence")));
        headerPanel.add(this.sequenceNameBox);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane((Component)this.propertyTable), "Center");
        this.add((Component)headerPanel, "North");
        this.setSequence(null);
    }

    public void applyLocaleSettings(LocaleSettings localeSettings) {
        this.propertyTable.applyLocaleSettings(localeSettings);
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSequence(Sequence sequence) {
        Sequence oldSequence = this.sequence;
        boolean oldDisableSequenceUpdateValue = this.disableSequenceUpdate;
        logger.debug((Object)("start: setSequence: " + sequence));
        try {
            this.disableSequenceUpdate = true;
            this.sequence = sequence;
            this.propertyTableModel.setSequence(sequence);
            if (sequence == null) {
                this.sequenceGroupBox.setEnabled(false);
                this.sequenceNameBox.setEnabled(false);
                this.propertyTable.setEnabled(false);
                if (this.sequenceGroupBox.getItemCount() > 0) {
                    this.sequenceGroupBox.setSelectedIndex(0);
                    logger.debug((Object)"   : setSequence: Setting sequencegroup to first.");
                    this.sequenceGroupSelected();
                }
                if (this.sequenceNameBox.getItemCount() > 0) {
                    this.sequenceNameBox.setSelectedIndex(0);
                    logger.debug((Object)"   : setSequence: Setting sequence to first in group.");
                }
                return;
            }
            this.sequenceGroupBox.setEnabled(true);
            this.sequenceNameBox.setEnabled(true);
            this.propertyTable.setEnabled(true);
            SequenceDescription de = sequence.getSequenceDescription();
            String group = de.getSequenceGroup(Locale.getDefault());
            this.sequenceGroupBox.setSelectedItem(group);
            logger.debug((Object)("   : setSequence: Setting sequencegroup to: " + group));
            this.sequenceGroupSelected();
            String displayName = de.getDisplayName(Locale.getDefault());
            this.sequenceModel.setSelectedValue((Object)displayName);
            logger.debug((Object)("   : setSequence: Setting sequence to: " + displayName));
        }
        finally {
            this.disableSequenceUpdate = oldDisableSequenceUpdateValue;
        }
        logger.debug((Object)("end: setSequence: " + sequence));
        this.firePropertyChange("sequence", oldSequence, this.sequence);
    }

    protected void sequenceGroupSelected() {
        logger.debug((Object)"sequenceGroupSelected() called. Updating sequences");
        Object selectedItem = this.sequenceGroupBox.getSelectedItem();
        if (selectedItem == null) {
            return;
        }
        String selectedGroup = String.valueOf(selectedItem);
        SequenceDescription[] sequences = this.registry.getSequencesForGroup(selectedGroup, Locale.getDefault());
        this.sequenceModel.clear();
        for (SequenceDescription description : sequences) {
            String displayName = description.getDisplayName(Locale.getDefault());
            this.sequenceModel.add((Object)description.newInstance(), (Object)displayName);
        }
        if (sequences.length > 0) {
            this.sequenceModel.setSelectedKey(this.sequenceModel.getKeyAt(0));
        }
    }

    protected void sequenceSelected() {
        this.setSequence((Sequence)this.sequenceModel.getSelectedKey());
    }

    public void stopEditing() {
        TableCellEditor cellEditor = this.propertyTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    private class SequenceSelectionHandler
    implements ListDataListener {
        private SequenceSelectionHandler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (SequenceEditor.this.disableSequenceUpdate) {
                return;
            }
            logger.debug((Object)("start SequenceContentChange: " + SequenceEditor.this.disableSequenceUpdate));
            SequenceEditor.this.disableSequenceUpdate = true;
            SequenceEditor.this.sequenceSelected();
            SequenceEditor.this.disableSequenceUpdate = false;
            logger.debug((Object)("end SequenceGroupContentChange: " + SequenceEditor.this.disableSequenceUpdate));
        }
    }

    private class SelectGroupAction
    implements ListDataListener {
        private SelectGroupAction() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            if (SequenceEditor.this.disableSequenceUpdate) {
                return;
            }
            logger.debug((Object)("start SequenceGroupContentChange: " + SequenceEditor.this.disableSequenceUpdate));
            SequenceEditor.this.disableSequenceUpdate = true;
            SequenceEditor.this.sequenceGroupSelected();
            SequenceEditor.this.sequenceSelected();
            SequenceEditor.this.disableSequenceUpdate = false;
            logger.debug((Object)("end SequenceGroupContentChange: " + SequenceEditor.this.disableSequenceUpdate));
        }
    }
}

