/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.table;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.Format;
import java.text.SimpleDateFormat;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.designtime.swing.FormattingTableCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.GenericCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.GenericCellRenderer;
import org.pentaho.reporting.libraries.designtime.swing.date.DateCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.date.TimeCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.settings.LocaleSettings;
import org.pentaho.reporting.ui.datasources.table.EditableHeader;
import org.pentaho.reporting.ui.datasources.table.EditableHeaderTableColumn;
import org.pentaho.reporting.ui.datasources.table.TableEditorModel;
import org.pentaho.reporting.ui.datasources.table.TypedHeaderCellEditor;
import org.pentaho.reporting.ui.datasources.table.TypedHeaderInformation;

public class TableEditor
extends JTable {
    private static final Log logger = LogFactory.getLog(TableEditor.class);
    private TableEditorModel tableModel = new TableEditorModel();
    private TableColumn selectedColumn;
    private EditableHeader tableHeader = new EditableHeader(this.getColumnModel(), this.tableModel);

    public TableEditor() {
        this.setTableHeader(this.tableHeader);
        this.setModel(this.tableModel);
        this.setSelectionMode(2);
        SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        this.setDefaultRenderer(java.util.Date.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)isoDateFormat));
        this.setDefaultRenderer(Date.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)new SimpleDateFormat("yyyy-MM-dd")));
        this.setDefaultRenderer(Time.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)new SimpleDateFormat("HH:mm:ss.SSS")));
        this.setDefaultRenderer(Timestamp.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)isoDateFormat));
        this.setDefaultRenderer(String.class, (TableCellRenderer)new GenericCellRenderer());
        this.setDefaultRenderer(Object.class, (TableCellRenderer)new GenericCellRenderer());
        this.setDefaultEditor(Number.class, (TableCellEditor)new GenericCellEditor(BigDecimal.class));
        this.setDefaultEditor(Integer.class, (TableCellEditor)new GenericCellEditor(Integer.class));
        this.setDefaultEditor(Float.class, (TableCellEditor)new GenericCellEditor(Float.class));
        this.setDefaultEditor(Double.class, (TableCellEditor)new GenericCellEditor(Double.class));
        this.setDefaultEditor(Short.class, (TableCellEditor)new GenericCellEditor(Short.class));
        this.setDefaultEditor(Byte.class, (TableCellEditor)new GenericCellEditor(Byte.class));
        this.setDefaultEditor(Long.class, (TableCellEditor)new GenericCellEditor(Long.class));
        this.setDefaultEditor(BigInteger.class, (TableCellEditor)new GenericCellEditor(BigInteger.class));
        this.setDefaultEditor(BigDecimal.class, (TableCellEditor)new GenericCellEditor(BigDecimal.class));
        this.setDefaultEditor(String.class, (TableCellEditor)new GenericCellEditor(String.class, true));
        this.setDefaultEditor(Object.class, (TableCellEditor)new GenericCellEditor(String.class, false));
        this.setDefaultEditor(java.util.Date.class, (TableCellEditor)new DateCellEditor(java.util.Date.class));
        this.setDefaultEditor(Date.class, (TableCellEditor)new DateCellEditor(Date.class));
        this.setDefaultEditor(Time.class, (TableCellEditor)new TimeCellEditor(Time.class));
        this.setDefaultEditor(Timestamp.class, (TableCellEditor)new DateCellEditor(Timestamp.class));
        this.updateUI();
    }

    public void applyLocaleSettings(LocaleSettings localeSettings) {
        DateCellEditor dateCellEditor;
        try {
            SimpleDateFormat isoDateFormat = new SimpleDateFormat(localeSettings.getDatetimeFormatPattern(), localeSettings.getLocale());
            isoDateFormat.setTimeZone(localeSettings.getTimeZone());
            this.setDefaultRenderer(java.util.Date.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)isoDateFormat));
            this.setDefaultRenderer(Timestamp.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)isoDateFormat));
            dateCellEditor = new DateCellEditor(java.util.Date.class);
            dateCellEditor.setDateFormat((DateFormat)isoDateFormat);
            this.setDefaultEditor(java.util.Date.class, (TableCellEditor)dateCellEditor);
            DateCellEditor timestampEditor = new DateCellEditor(Timestamp.class);
            timestampEditor.setDateFormat((DateFormat)isoDateFormat);
            this.setDefaultEditor(Timestamp.class, (TableCellEditor)timestampEditor);
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid format string found in locale settings", (Throwable)e);
        }
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(localeSettings.getDateFormatPattern(), localeSettings.getLocale());
            dateFormat.setTimeZone(localeSettings.getTimeZone());
            this.setDefaultRenderer(Date.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)dateFormat));
            dateCellEditor = new DateCellEditor(Date.class);
            dateCellEditor.setDateFormat((DateFormat)dateFormat);
            this.setDefaultEditor(Date.class, (TableCellEditor)dateCellEditor);
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid format string found in locale settings", (Throwable)e);
        }
        try {
            SimpleDateFormat timeFormat = new SimpleDateFormat(localeSettings.getTimeFormatPattern(), localeSettings.getLocale());
            timeFormat.setTimeZone(localeSettings.getTimeZone());
            this.setDefaultRenderer(Time.class, (TableCellRenderer)new FormattingTableCellRenderer((Format)timeFormat));
            TimeCellEditor timeCellEditor = new TimeCellEditor(Time.class);
            timeCellEditor.setDateFormat((DateFormat)timeFormat);
            this.setDefaultEditor(Time.class, (TableCellEditor)timeCellEditor);
        }
        catch (Exception e) {
            logger.warn((Object)"Invalid format string found in locale settings", (Throwable)e);
        }
    }

    @Override
    public void createDefaultColumnsFromModel() {
        TableModel m = this.getModel();
        if (m != null) {
            TableColumnModel cm = this.getColumnModel();
            while (cm.getColumnCount() > 0) {
                cm.removeColumn(cm.getColumn(0));
            }
            for (int i = 0; i < m.getColumnCount(); ++i) {
                if (i == 0) {
                    TableColumn column = new TableColumn(i);
                    column.setCellRenderer(this.tableHeader.getDefaultRenderer());
                    this.addColumn(column);
                    continue;
                }
                EditableHeaderTableColumn newColumn = new EditableHeaderTableColumn(i);
                newColumn.setHeaderEditor(new TypedHeaderCellEditor());
                this.addColumn(newColumn);
            }
        }
    }

    @Override
    public void addColumn(TableColumn column) {
        this.stopEditing();
        if (column.getHeaderValue() == null) {
            int modelColumn = column.getModelIndex();
            String columnName = this.getModel().getColumnName(modelColumn);
            if (modelColumn == 0) {
                column.setResizable(false);
                column.setHeaderValue(columnName);
                column.setPreferredWidth(30);
                column.setMaxWidth(30);
                column.setMinWidth(30);
            } else {
                Class<?> columnType = this.getModel().getColumnClass(modelColumn);
                column.setHeaderValue(new TypedHeaderInformation(columnType, columnName));
            }
        }
        this.getColumnModel().addColumn(column);
    }

    public void addColumn(String aHeaderName) {
        this.stopEditing();
        this.tableHeader.removeEditor();
        this.tableModel.addColumn(aHeaderName, String.class);
    }

    public void addRow() {
        this.stopEditing();
        int row = this.getSelectedRow();
        if (row == -1) {
            this.tableModel.addRow();
            this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
        } else {
            this.tableModel.addRow(row + 1);
            this.setRowSelectionInterval(row + 1, row + 1);
        }
    }

    public void removeRow() {
        this.stopEditing();
        int[] rows = this.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            int row = rows[i];
            this.tableModel.removeRow(row);
        }
        this.tableModel.fireTableDataChanged();
    }

    public void removeColumn() {
        this.stopEditing();
        this.tableHeader.removeEditor();
        int modelIndex = this.selectedColumn.getModelIndex();
        if (modelIndex == 0) {
            return;
        }
        this.tableModel.removeColumn(modelIndex - 1);
    }

    public void setSelectedColumn(TableColumn aSelectedColumn) {
        this.selectedColumn = aSelectedColumn;
    }

    public void setTableEditorModel(TableModel model) {
        this.tableModel.copyInto(model);
    }

    public TableModel getTableEditorModel() {
        return this.tableModel.createModel();
    }

    public void stopEditing() {
        TableCellEditor cellEditor = this.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }
}

