/*
 * Decompiled with CFR 0.152.
 */
package com.debortoliwines.openerp.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class OpenERPXmlRpcProxy
extends XmlRpcClient {
    private final String RPC_COMMON_URL = "/xmlrpc/common";
    private final String RPC_OBJECT_URL = "/xmlrpc/object";
    private final String RPC_DATABASE_URL = "/xmlrpc/db";

    public OpenERPXmlRpcProxy(RPCProtocol protocol, String host, int port, RPCServices service) {
        String URL2 = "";
        switch (service) {
            case RPC_COMMON: {
                URL2 = this.RPC_COMMON_URL;
                break;
            }
            case RPC_OBJECT: {
                URL2 = this.RPC_OBJECT_URL;
                break;
            }
            case RPC_DATABASE: {
                URL2 = this.RPC_DATABASE_URL;
            }
        }
        String protocol_str = "";
        switch (protocol) {
            case RPC_HTTP: {
                protocol_str = "http";
                break;
            }
            default: {
                protocol_str = "https";
            }
        }
        XmlRpcClientConfigImpl xmlrpcConfigLogin = new XmlRpcClientConfigImpl();
        xmlrpcConfigLogin.setEnabledForExtensions(false);
        try {
            xmlrpcConfigLogin.setServerURL(new URL(protocol_str, host, port, URL2));
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this.setConfig((XmlRpcClientConfig)xmlrpcConfigLogin);
    }

    public OpenERPXmlRpcProxy(String host, int port, RPCServices service) {
        this(RPCProtocol.RPC_HTTP, host, port, service);
    }

    public static ArrayList<String> getDatabaseList(RPCProtocol protocol, String host, int port) throws XmlRpcException {
        OpenERPXmlRpcProxy client = new OpenERPXmlRpcProxy(protocol, host, port, RPCServices.RPC_DATABASE);
        Object[] result = (Object[])client.execute("list", new Object[0]);
        ArrayList<String> finalResults = new ArrayList<String>();
        for (Object res : result) {
            finalResults.add((String)res);
        }
        return finalResults;
    }

    public static ArrayList<String> getDatabaseList(String host, int port) throws XmlRpcException {
        return OpenERPXmlRpcProxy.getDatabaseList(RPCProtocol.RPC_HTTP, host, port);
    }

    public static enum RPCProtocol {
        RPC_HTTP,
        RPC_HTTPS;

    }

    public static enum RPCServices {
        RPC_COMMON,
        RPC_OBJECT,
        RPC_DATABASE;

    }
}

