/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.CacheStrategy;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.FilesCache;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.cache.OnCallRefreshFileObject;
import org.apache.commons.vfs.events.AbstractFileChangeEvent;
import org.apache.commons.vfs.events.ChangedEvent;
import org.apache.commons.vfs.events.CreateEvent;
import org.apache.commons.vfs.events.DeleteEvent;
import org.apache.commons.vfs.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.AbstractVfsComponent;
import org.apache.commons.vfs.provider.FileSystemKey;
import org.apache.commons.vfs.util.Messages;

public abstract class AbstractFileSystem
extends AbstractVfsComponent
implements FileSystem {
    private static final Log LOG = LogFactory.getLog(AbstractFileSystem.class);
    private final FileName rootName;
    private final String rootURI;
    private FileObject parentLayer;
    private final Collection caps = new HashSet();
    private final Map listenerMap = new HashMap();
    private final FileSystemOptions fileSystemOptions;
    private long useCount;
    private FileSystemKey cacheKey;
    private int openStreams;

    protected AbstractFileSystem(FileName fileName, FileObject fileObject, FileSystemOptions fileSystemOptions) {
        this.parentLayer = fileObject;
        this.rootName = fileName;
        this.fileSystemOptions = fileSystemOptions;
        DefaultFileSystemConfigBuilder defaultFileSystemConfigBuilder = DefaultFileSystemConfigBuilder.getInstance();
        String string = defaultFileSystemConfigBuilder.getRootURI(fileSystemOptions);
        if (string == null) {
            string = fileName.getURI();
        }
        this.rootURI = string;
    }

    public void init() throws FileSystemException {
        this.addCapabilities(this.caps);
    }

    public void close() {
        this.closeCommunicationLink();
        this.parentLayer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCommunicationLink() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            this.doCloseCommunicationLink();
        }
    }

    protected void doCloseCommunicationLink() {
    }

    protected abstract FileObject createFile(FileName var1) throws Exception;

    protected abstract void addCapabilities(Collection var1);

    public FileName getRootName() {
        return this.rootName;
    }

    public String getRootURI() {
        return this.rootURI;
    }

    protected void putFileToCache(FileObject fileObject) {
        this.getCache().putFile(fileObject);
    }

    private FilesCache getCache() {
        FilesCache filesCache = this.getContext().getFileSystemManager().getFilesCache();
        if (filesCache == null) {
            throw new RuntimeException(Messages.getString("vfs.provider/files-cache-missing.error"));
        }
        return filesCache;
    }

    protected FileObject getFileFromCache(FileName fileName) {
        return this.getCache().getFile(this, fileName);
    }

    protected void removeFileFromCache(FileName fileName) {
        this.getCache().removeFile(this, fileName);
    }

    public boolean hasCapability(Capability capability) {
        return this.caps.contains(capability);
    }

    public Object getAttribute(String string) throws FileSystemException {
        throw new FileSystemException("vfs.provider/get-attribute-not-supported.error");
    }

    public void setAttribute(String string, Object object) throws FileSystemException {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    public FileObject getParentLayer() throws FileSystemException {
        return this.parentLayer;
    }

    public FileObject getRoot() throws FileSystemException {
        return this.resolveFile(this.rootName);
    }

    public FileObject resolveFile(String string) throws FileSystemException {
        FileName fileName = this.getFileSystemManager().resolveName(this.rootName, string);
        return this.resolveFile(fileName);
    }

    public synchronized FileObject resolveFile(FileName fileName) throws FileSystemException {
        return this.resolveFile(fileName, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized FileObject resolveFile(FileName fileName, boolean bl) throws FileSystemException {
        if (!this.rootName.getRootURI().equals(fileName.getRootURI())) {
            throw new FileSystemException("vfs.provider/mismatched-fs-for-name.error", new Object[]{fileName, this.rootName, fileName.getRootURI()});
        }
        FileObject fileObject = bl ? this.getFileFromCache(fileName) : null;
        if (fileObject == null) {
            try {
                AbstractFileSystem abstractFileSystem = this;
                synchronized (abstractFileSystem) {
                    fileObject = this.createFile(fileName);
                }
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/resolve-file.error", fileName, (Throwable)exception);
            }
            fileObject = this.decorateFileObject(fileObject);
            if (bl) {
                this.putFileToCache(fileObject);
            }
        }
        if (this.getFileSystemManager().getCacheStrategy().equals(CacheStrategy.ON_RESOLVE)) {
            fileObject.refresh();
        }
        return fileObject;
    }

    protected FileObject decorateFileObject(FileObject fileObject) throws FileSystemException {
        if (this.getFileSystemManager().getCacheStrategy().equals(CacheStrategy.ON_CALL)) {
            fileObject = new OnCallRefreshFileObject(fileObject);
        }
        if (this.getFileSystemManager().getFileObjectDecoratorConst() != null) {
            try {
                fileObject = (FileObject)this.getFileSystemManager().getFileObjectDecoratorConst().newInstance(fileObject);
            }
            catch (InstantiationException instantiationException) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new FileSystemException("vfs.impl/invalid-decorator.error", this.getFileSystemManager().getFileObjectDecorator().getName(), (Throwable)invocationTargetException);
            }
        }
        return fileObject;
    }

    public File replicateFile(FileObject fileObject, FileSelector fileSelector) throws FileSystemException {
        if (!fileObject.exists()) {
            throw new FileSystemException("vfs.provider/replicate-missing-file.error", fileObject.getName());
        }
        try {
            return this.doReplicateFile(fileObject, fileSelector);
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/replicate-file.error", fileObject.getName(), (Throwable)exception);
        }
    }

    public FileSystemOptions getFileSystemOptions() {
        return this.fileSystemOptions;
    }

    public FileSystemManager getFileSystemManager() {
        return this.getContext().getFileSystemManager();
    }

    public double getLastModTimeAccuracy() {
        return 0.0;
    }

    protected File doReplicateFile(FileObject fileObject, FileSelector fileSelector) throws Exception {
        return this.getContext().getReplicator().replicateFile(fileObject, fileSelector);
    }

    public void addJunction(String string, FileObject fileObject) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    public void removeJunction(String string) throws FileSystemException {
        throw new FileSystemException("vfs.provider/junctions-not-supported.error", this.rootName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FileObject fileObject, FileListener fileListener) {
        Map map = this.listenerMap;
        synchronized (map) {
            ArrayList<FileListener> arrayList = (ArrayList<FileListener>)this.listenerMap.get(fileObject.getName());
            if (arrayList == null) {
                arrayList = new ArrayList<FileListener>();
                this.listenerMap.put(fileObject.getName(), arrayList);
            }
            arrayList.add(fileListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FileObject fileObject, FileListener fileListener) {
        Map map = this.listenerMap;
        synchronized (map) {
            ArrayList arrayList = (ArrayList)this.listenerMap.get(fileObject.getName());
            if (arrayList != null) {
                arrayList.remove(fileListener);
                if (arrayList.isEmpty()) {
                    this.listenerMap.remove(fileObject.getName());
                }
            }
        }
    }

    public void fireFileCreated(FileObject fileObject) {
        this.fireEvent(new CreateEvent(fileObject));
    }

    public void fireFileDeleted(FileObject fileObject) {
        this.fireEvent(new DeleteEvent(fileObject));
    }

    public void fireFileChanged(FileObject fileObject) {
        this.fireEvent(new ChangedEvent(fileObject));
    }

    public boolean isReleaseable() {
        return this.useCount < 1L;
    }

    void freeResources() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(AbstractFileChangeEvent abstractFileChangeEvent) {
        Object object;
        FileListener[] fileListenerArray = null;
        FileObject fileObject = abstractFileChangeEvent.getFile();
        Map map = this.listenerMap;
        synchronized (map) {
            object = (ArrayList)this.listenerMap.get(fileObject.getName());
            if (object != null) {
                fileListenerArray = ((ArrayList)object).toArray(new FileListener[((ArrayList)object).size()]);
            }
        }
        if (fileListenerArray != null) {
            for (int i = 0; i < fileListenerArray.length; ++i) {
                object = fileListenerArray[i];
                try {
                    abstractFileChangeEvent.notify((FileListener)object);
                    continue;
                }
                catch (Exception exception) {
                    String string = Messages.getString("vfs.provider/notify-listener.warn", fileObject);
                    VfsLog.warn(this.getLogger(), LOG, string, exception);
                }
            }
        }
    }

    void fileObjectHanded(FileObject fileObject) {
        ++this.useCount;
    }

    void fileObjectDestroyed(FileObject fileObject) {
        --this.useCount;
    }

    void setCacheKey(FileSystemKey fileSystemKey) {
        this.cacheKey = fileSystemKey;
    }

    FileSystemKey getCacheKey() {
        return this.cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamOpened() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            ++this.openStreams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void streamClosed() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            if (this.openStreams > 0) {
                --this.openStreams;
                if (this.openStreams < 1) {
                    this.notifyAllStreamsClosed();
                }
            }
        }
    }

    protected void notifyAllStreamsClosed() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        AbstractFileSystem abstractFileSystem = this;
        synchronized (abstractFileSystem) {
            return this.openStreams > 0;
        }
    }
}

