/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileNameParser;
import org.apache.commons.vfs.provider.GenericFileName;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;
import org.apache.commons.vfs.util.Cryptor;
import org.apache.commons.vfs.util.CryptorFactory;

public class HostFileNameParser
extends AbstractFileNameParser {
    private final int defaultPort;

    public HostFileNameParser(int n) {
        this.defaultPort = n;
    }

    public int getDefaultPort() {
        return this.defaultPort;
    }

    public boolean encodeCharacter(char c) {
        return super.encodeCharacter(c);
    }

    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String string) throws FileSystemException {
        StringBuffer stringBuffer = new StringBuffer();
        Authority authority = this.extractToPath(string, stringBuffer);
        UriParser.canonicalizePath(stringBuffer, 0, stringBuffer.length(), this);
        UriParser.fixSeparators(stringBuffer);
        FileType fileType = UriParser.normalisePath(stringBuffer);
        String string2 = stringBuffer.toString();
        return new GenericFileName(authority.scheme, authority.hostName, authority.port, this.defaultPort, authority.userName, authority.password, string2, fileType);
    }

    protected Authority extractToPath(String string, StringBuffer stringBuffer) throws FileSystemException {
        String string2;
        String string3;
        String string4;
        Authority authority = new Authority();
        authority.scheme = UriParser.extractScheme(string, stringBuffer);
        if (stringBuffer.length() < 2 || stringBuffer.charAt(0) != '/' || stringBuffer.charAt(1) != '/') {
            throw new FileSystemException("vfs.provider/missing-double-slashes.error", string);
        }
        stringBuffer.delete(0, 2);
        String string5 = this.extractUserInfo(stringBuffer);
        if (string5 != null) {
            int n = string5.indexOf(58);
            if (n == -1) {
                string4 = string5;
                string3 = null;
            } else {
                string4 = string5.substring(0, n);
                string3 = string5.substring(n + 1);
            }
        } else {
            string4 = null;
            string3 = null;
        }
        authority.userName = UriParser.decode(string4);
        authority.password = UriParser.decode(string3);
        if (authority.password != null && authority.password.startsWith("{") && authority.password.endsWith("}")) {
            try {
                Cryptor cryptor = CryptorFactory.getCryptor();
                authority.password = cryptor.decrypt(authority.password.substring(1, authority.password.length() - 1));
            }
            catch (Exception exception) {
                throw new FileSystemException("Unable to decrypt password", exception);
            }
        }
        if ((string2 = this.extractHostName(stringBuffer)) == null) {
            throw new FileSystemException("vfs.provider/missing-hostname.error", string);
        }
        authority.hostName = string2.toLowerCase();
        authority.port = this.extractPort(stringBuffer, string);
        if (stringBuffer.length() > 0 && stringBuffer.charAt(0) != '/') {
            throw new FileSystemException("vfs.provider/missing-hostname-path-sep.error", string);
        }
        return authority;
    }

    protected String extractUserInfo(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '@') {
                String string = stringBuffer.substring(0, i);
                stringBuffer.delete(0, i + 1);
                return string;
            }
            if (c == '/' || c == '?') break;
        }
        return null;
    }

    protected String extractHostName(StringBuffer stringBuffer) {
        char c;
        int n;
        int n2 = stringBuffer.length();
        for (n = 0; n < n2 && (c = stringBuffer.charAt(n)) != '/' && c != ';' && c != '?' && c != ':' && c != '@' && c != '&' && c != '=' && c != '+' && c != '$' && c != ','; ++n) {
        }
        if (n == 0) {
            return null;
        }
        String string = stringBuffer.substring(0, n);
        stringBuffer.delete(0, n);
        return string;
    }

    protected int extractPort(StringBuffer stringBuffer, String string) throws FileSystemException {
        char c;
        int n;
        if (stringBuffer.length() < 1 || stringBuffer.charAt(0) != ':') {
            return -1;
        }
        int n2 = stringBuffer.length();
        for (n = 1; n < n2 && (c = stringBuffer.charAt(n)) >= '0' && c <= '9'; ++n) {
        }
        String string2 = stringBuffer.substring(1, n);
        stringBuffer.delete(0, n);
        if (string2.length() == 0) {
            throw new FileSystemException("vfs.provider/missing-port.error", string);
        }
        return Integer.parseInt(string2);
    }

    protected static class Authority {
        private String scheme;
        private String hostName;
        private String userName;
        private String password;
        private int port;

        protected Authority() {
        }

        public String getScheme() {
            return this.scheme;
        }

        public void setScheme(String string) {
            this.scheme = string;
        }

        public String getHostName() {
            return this.hostName;
        }

        public void setHostName(String string) {
            this.hostName = string;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String string) {
            this.userName = string;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int n) {
            this.port = n;
        }
    }
}

