/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.GenericFileName;

public class URLFileName
extends GenericFileName {
    private static final int BUFFSZ = 250;
    private final String queryString;

    public URLFileName(String string, String string2, int n, int n2, String string3, String string4, String string5, FileType fileType, String string6) {
        super(string, string2, n, n2, string3, string4, string5, fileType);
        this.queryString = string6;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getPathQuery() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append(this.getPath());
        stringBuffer.append("?");
        stringBuffer.append(this.getQueryString());
        return stringBuffer.toString();
    }

    public String getPathQueryEncoded(String string) throws URIException, FileSystemException {
        if (this.getQueryString() == null) {
            if (string != null) {
                return URIUtil.encodePath((String)this.getPathDecoded(), (String)string);
            }
            return URIUtil.encodePath((String)this.getPathDecoded());
        }
        StringBuffer stringBuffer = new StringBuffer(250);
        if (string != null) {
            stringBuffer.append(URIUtil.encodePath((String)this.getPathDecoded(), (String)string));
        } else {
            stringBuffer.append(URIUtil.encodePath((String)this.getPathDecoded()));
        }
        stringBuffer.append("?");
        stringBuffer.append(this.getQueryString());
        return stringBuffer.toString();
    }

    public FileName createName(String string, FileType fileType) {
        return new URLFileName(this.getScheme(), this.getHostName(), this.getPort(), this.getDefaultPort(), this.getUserName(), this.getPassword(), string, fileType, this.getQueryString());
    }

    protected String createURI() {
        if (this.getQueryString() != null) {
            StringBuffer stringBuffer = new StringBuffer(250);
            stringBuffer.append(super.createURI());
            stringBuffer.append("?");
            stringBuffer.append(this.getQueryString());
            return stringBuffer.toString();
        }
        return super.createURI();
    }

    public String getURIEncoded(String string) throws FileSystemException, URIException {
        StringBuffer stringBuffer = new StringBuffer(250);
        this.appendRootUri(stringBuffer, true);
        stringBuffer.append(this.getPathQueryEncoded(string));
        return stringBuffer.toString();
    }
}

