/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.compressed;

import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.compressed.CompressedFileFileSystem;

public abstract class CompressedFileFileObject
extends AbstractFileObject
implements FileObject {
    private final FileObject container;
    private String[] children;

    protected CompressedFileFileObject(FileName fileName, FileObject fileObject, CompressedFileFileSystem compressedFileFileSystem) {
        super(fileName, compressedFileFileSystem);
        this.container = fileObject;
        String string = fileObject.getName().getBaseName();
        int n = string.lastIndexOf(46);
        string = string.substring(0, n);
        this.children = new String[]{string};
    }

    public boolean isWriteable() throws FileSystemException {
        return this.getFileSystem().hasCapability(Capability.WRITE_CONTENT);
    }

    protected FileType doGetType() throws FileSystemException {
        if (this.getName().getPath().endsWith("/")) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() {
        return this.children;
    }

    protected long doGetContentSize() {
        return -1L;
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.container.getContent().getLastModifiedTime();
    }

    protected FileObject getContainer() {
        return this.container;
    }

    public void createFile() throws FileSystemException {
        this.container.createFile();
        this.injectType(FileType.FILE);
    }
}

