/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.smb;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.GenericFileName;

public class SmbFileName
extends GenericFileName {
    private static final int DEFAULT_PORT = 139;
    private final String share;
    private final String domain;
    private String uriWithoutAuth;

    protected SmbFileName(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, FileType fileType) {
        super(string, string2, n, 139, string3, string4, string7, fileType);
        this.share = string6;
        this.domain = string5;
    }

    public String getShare() {
        return this.share;
    }

    protected void appendRootUri(StringBuffer stringBuffer, boolean bl) {
        super.appendRootUri(stringBuffer, bl);
        stringBuffer.append('/');
        stringBuffer.append(this.share);
    }

    protected void appendCredentials(StringBuffer stringBuffer, boolean bl) {
        if (this.getDomain() != null && this.getDomain().length() != 0 && this.getUserName() != null && this.getUserName().length() != 0) {
            stringBuffer.append(this.getDomain());
            stringBuffer.append("\\");
        }
        super.appendCredentials(stringBuffer, bl);
    }

    public FileName createName(String string, FileType fileType) {
        return new SmbFileName(this.getScheme(), this.getHostName(), this.getPort(), this.getUserName(), this.getPassword(), this.domain, this.share, string, fileType);
    }

    public String getUriWithoutAuth() throws FileSystemException {
        if (this.uriWithoutAuth != null) {
            return this.uriWithoutAuth;
        }
        StringBuffer stringBuffer = new StringBuffer(120);
        stringBuffer.append(this.getScheme());
        stringBuffer.append("://");
        stringBuffer.append(this.getHostName());
        if (this.getPort() != 139) {
            stringBuffer.append(":");
            stringBuffer.append(this.getPort());
        }
        stringBuffer.append("/");
        stringBuffer.append(this.getShare());
        stringBuffer.append(this.getPathDecoded());
        this.uriWithoutAuth = stringBuffer.toString();
        return this.uriWithoutAuth;
    }

    public String getDomain() {
        return this.domain;
    }
}

