/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.smb;

import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.FileNameParser;
import org.apache.commons.vfs.provider.HostFileNameParser;
import org.apache.commons.vfs.provider.URLFileNameParser;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.VfsComponentContext;
import org.apache.commons.vfs.provider.smb.SmbFileName;

public class SmbFileNameParser
extends URLFileNameParser {
    private static final SmbFileNameParser INSTANCE = new SmbFileNameParser();

    public SmbFileNameParser() {
        super(139);
    }

    public static FileNameParser getInstance() {
        return INSTANCE;
    }

    public FileName parseUri(VfsComponentContext vfsComponentContext, FileName fileName, String string) throws FileSystemException {
        StringBuffer stringBuffer = new StringBuffer();
        HostFileNameParser.Authority authority = this.extractToPath(string, stringBuffer);
        String string2 = authority.getUserName();
        String string3 = this.extractDomain(string2);
        if (string3 != null) {
            string2 = string2.substring(string3.length() + 1);
        }
        UriParser.canonicalizePath(stringBuffer, 0, stringBuffer.length(), this);
        UriParser.fixSeparators(stringBuffer);
        String string4 = UriParser.extractFirstElement(stringBuffer);
        if (string4 == null || string4.length() == 0) {
            throw new FileSystemException("vfs.provider.smb/missing-share-name.error", string);
        }
        FileType fileType = UriParser.normalisePath(stringBuffer);
        String string5 = stringBuffer.toString();
        return new SmbFileName(authority.getScheme(), authority.getHostName(), authority.getPort(), string2, authority.getPassword(), string3, string4, string5, fileType);
    }

    private String extractDomain(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\\') continue;
            return string.substring(0, i);
        }
        return null;
    }
}

