/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.tasks;

import org.apache.commons.logging.Log;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.impl.StandardFileSystemManager;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.SubBuildListener;
import org.apache.tools.ant.Task;

public class VfsTask
extends Task {
    private static StandardFileSystemManager manager;

    protected FileObject resolveFile(String string) throws FileSystemException {
        if (manager == null) {
            manager = new StandardFileSystemManager();
            manager.setLogger(new AntLogger());
            manager.init();
            this.getProject().addBuildListener((BuildListener)new CloseListener());
        }
        return manager.resolveFile(this.getProject().getBaseDir(), string);
    }

    protected void closeManager() {
        if (manager != null) {
            manager.close();
            manager = null;
        }
    }

    private class AntLogger
    implements Log {
        private AntLogger() {
        }

        public void debug(Object object) {
            VfsTask.this.log(String.valueOf(object), 4);
        }

        public void debug(Object object, Throwable throwable) {
            this.debug(object);
        }

        public void error(Object object) {
            VfsTask.this.log(String.valueOf(object), 0);
        }

        public void error(Object object, Throwable throwable) {
            this.error(object);
        }

        public void fatal(Object object) {
            VfsTask.this.log(String.valueOf(object), 0);
        }

        public void fatal(Object object, Throwable throwable) {
            this.fatal(object);
        }

        public void info(Object object) {
            VfsTask.this.log(String.valueOf(object), 2);
        }

        public void info(Object object, Throwable throwable) {
            this.info(object);
        }

        public void trace(Object object) {
        }

        public void trace(Object object, Throwable throwable) {
        }

        public void warn(Object object) {
            VfsTask.this.log(String.valueOf(object), 1);
        }

        public void warn(Object object, Throwable throwable) {
            this.warn(object);
        }

        public boolean isDebugEnabled() {
            return true;
        }

        public boolean isErrorEnabled() {
            return true;
        }

        public boolean isFatalEnabled() {
            return true;
        }

        public boolean isInfoEnabled() {
            return true;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return true;
        }
    }

    private class CloseListener
    implements SubBuildListener {
        private CloseListener() {
        }

        public void subBuildStarted(BuildEvent buildEvent) {
        }

        public void subBuildFinished(BuildEvent buildEvent) {
            VfsTask.this.closeManager();
        }

        public void buildFinished(BuildEvent buildEvent) {
            VfsTask.this.closeManager();
        }

        public void buildStarted(BuildEvent buildEvent) {
        }

        public void messageLogged(BuildEvent buildEvent) {
        }

        public void targetFinished(BuildEvent buildEvent) {
        }

        public void targetStarted(BuildEvent buildEvent) {
        }

        public void taskFinished(BuildEvent buildEvent) {
        }

        public void taskStarted(BuildEvent buildEvent) {
        }
    }
}

