/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

public class CombinedResources
extends ResourceBundle {
    private final String resourceName;
    private boolean inited;
    private final Properties properties = new Properties();

    public CombinedResources(String string) {
        this.resourceName = string;
    }

    protected void init() {
        if (this.inited) {
            return;
        }
        this.loadResources(this.getResourceName());
        this.loadResources(Locale.getDefault());
        this.loadResources(this.getLocale());
        this.inited = true;
    }

    protected void loadResources(Locale locale) {
        if (locale == null) {
            return;
        }
        String[] stringArray = new String[]{locale.getLanguage(), locale.getCountry(), locale.getVariant()};
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            stringBuffer.append(this.getResourceName());
            for (int j = 0; j < i; ++j) {
                stringBuffer.append('_').append(stringArray[j]);
            }
            if (stringArray[i].length() != 0) {
                stringBuffer.append('_').append(stringArray[i]);
                this.loadResources(stringBuffer.toString());
            }
            stringBuffer.setLength(0);
        }
    }

    protected void loadResources(String string) {
        ClassLoader classLoader = this.getClass().getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        string = string.replace('.', '/') + ".properties";
        try {
            Enumeration<URL> enumeration = classLoader.getResources(string);
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                try {
                    this.properties.load(uRL.openConnection().getInputStream());
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Enumeration getKeys() {
        if (!this.inited) {
            this.init();
        }
        return this.properties.keys();
    }

    protected Object handleGetObject(String string) {
        if (!this.inited) {
            this.init();
        }
        return this.properties.get(string);
    }
}

