/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.impl.DecoratedFileObject;
import org.apache.commons.vfs.provider.AbstractFileObject;

public final class FileObjectUtils {
    private FileObjectUtils() {
    }

    public static AbstractFileObject getAbstractFileObject(FileObject fileObject) throws FileSystemException {
        FileObject fileObject2 = fileObject;
        while (fileObject2 instanceof DecoratedFileObject) {
            fileObject2 = ((DecoratedFileObject)fileObject2).getDecoratedFileObject();
        }
        if (fileObject2 instanceof AbstractFileObject) {
            return (AbstractFileObject)fileObject2;
        }
        if (fileObject2 == null) {
            return null;
        }
        throw new FileSystemException("vfs.util/find-abstract-file-object.error", fileObject == null ? "null" : fileObject.getClass().getName());
    }

    public static boolean isInstanceOf(FileObject fileObject, Class clazz) throws FileSystemException {
        FileObject fileObject2 = fileObject;
        while (fileObject2 instanceof DecoratedFileObject) {
            if (clazz.isInstance(fileObject2)) {
                return true;
            }
            fileObject2 = ((DecoratedFileObject)fileObject2).getDecoratedFileObject();
        }
        return clazz.isInstance(fileObject2);
    }
}

