/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.vfs.FileSystemException;

public class MonitorOutputStream
extends BufferedOutputStream {
    private boolean finished;

    public MonitorOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void close() throws IOException {
        if (this.finished) {
            return;
        }
        IOException iOException = null;
        try {
            super.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        try {
            this.onClose();
        }
        catch (IOException iOException3) {
            iOException = iOException3;
        }
        this.finished = true;
        if (iOException != null) {
            throw iOException;
        }
    }

    public synchronized void write(int n) throws IOException {
        this.assertOpen();
        super.write(n);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.assertOpen();
        super.write(byArray, n, n2);
    }

    public synchronized void flush() throws IOException {
        this.assertOpen();
        super.flush();
    }

    public void write(byte[] byArray) throws IOException {
        this.assertOpen();
        super.write(byArray);
    }

    protected void assertOpen() throws FileSystemException {
        if (this.finished) {
            throw new FileSystemException("vfs.provider/closed.error");
        }
    }

    protected void onClose() throws IOException {
    }
}

