/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.AuxObject;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.PageTimeStamp;
import org.apache.derby.iapi.store.raw.RecordHandle;

public interface Page {
    public static final int FIRST_SLOT_NUMBER = 0;
    public static final int INVALID_SLOT_NUMBER = -1;
    public static final byte INSERT_INITIAL = 0;
    public static final byte INSERT_DEFAULT = 1;
    public static final byte INSERT_UNDO_WITH_PURGE = 2;
    public static final byte INSERT_CONDITIONAL = 4;
    public static final byte INSERT_OVERFLOW = 8;
    public static final byte INSERT_FOR_SPLIT = 16;
    public static final String DIAG_PAGE_SIZE = "pageSize";
    public static final String DIAG_RESERVED_SPACE = "reserveSpace";
    public static final String DIAG_MINIMUM_REC_SIZE = "minRecSize";
    public static final String DIAG_BYTES_FREE = "bytesFree";
    public static final String DIAG_BYTES_RESERVED = "bytesReserved";
    public static final String DIAG_NUMOVERFLOWED = "numOverFlowed";
    public static final String DIAG_ROWSIZE = "rowSize";
    public static final String DIAG_MINROWSIZE = "minRowSize";
    public static final String DIAG_MAXROWSIZE = "maxRowSize";
    public static final String DIAG_PAGEOVERHEAD = "pageOverhead";
    public static final String DIAG_SLOTTABLE_SIZE = "slotTableSize";

    public long getPageNumber();

    public RecordHandle getInvalidRecordHandle();

    public RecordHandle makeRecordHandle(int var1) throws StandardException;

    public RecordHandle getRecordHandle(int var1);

    public boolean recordExists(RecordHandle var1, boolean var2) throws StandardException;

    public RecordHandle fetch(RecordHandle var1, Object[] var2, FormatableBitSet var3, boolean var4) throws StandardException;

    public boolean spaceForInsert() throws StandardException;

    public boolean spaceForInsert(Object[] var1, FormatableBitSet var2, int var3) throws StandardException;

    public RecordHandle insert(Object[] var1, FormatableBitSet var2, byte var3, int var4) throws StandardException;

    public boolean update(RecordHandle var1, Object[] var2, FormatableBitSet var3) throws StandardException;

    public boolean delete(RecordHandle var1, LogicalUndo var2) throws StandardException;

    public int moveRecordForCompressAtSlot(int var1, Object[] var2, RecordHandle[] var3, RecordHandle[] var4) throws StandardException;

    public int fetchNumFields(RecordHandle var1) throws StandardException;

    public int getSlotNumber(RecordHandle var1) throws StandardException;

    public RecordHandle getRecordHandleAtSlot(int var1) throws StandardException;

    public int getNextSlotNumber(RecordHandle var1) throws StandardException;

    public RecordHandle insertAtSlot(int var1, Object[] var2, FormatableBitSet var3, LogicalUndo var4, byte var5, int var6) throws StandardException;

    public RecordHandle fetchFromSlot(RecordHandle var1, int var2, Object[] var3, FetchDescriptor var4, boolean var5) throws StandardException;

    public RecordHandle fetchFieldFromSlot(int var1, int var2, Object var3) throws StandardException;

    public boolean isDeletedAtSlot(int var1) throws StandardException;

    public RecordHandle updateFieldAtSlot(int var1, int var2, Object var3, LogicalUndo var4) throws StandardException;

    public int fetchNumFieldsAtSlot(int var1) throws StandardException;

    public RecordHandle deleteAtSlot(int var1, boolean var2, LogicalUndo var3) throws StandardException;

    public void purgeAtSlot(int var1, int var2, boolean var3) throws StandardException;

    public void copyAndPurge(Page var1, int var2, int var3, int var4) throws StandardException;

    public RecordHandle updateAtSlot(int var1, Object[] var2, FormatableBitSet var3) throws StandardException;

    public void unlatch();

    public int recordCount() throws StandardException;

    public int nonDeletedRecordCount() throws StandardException;

    public boolean shouldReclaimSpace(int var1, int var2) throws StandardException;

    public void setAuxObject(AuxObject var1);

    public AuxObject getAuxObject();

    public void setTimeStamp(PageTimeStamp var1) throws StandardException;

    public PageTimeStamp currentTimeStamp();

    public boolean equalTimeStamp(PageTimeStamp var1) throws StandardException;

    public boolean isLatched();
}

