/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ApplicationSubmissionContext {
    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, Priority priority, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, Resource resource, String applicationType, boolean keepContainers) {
        ApplicationSubmissionContext context = Records.newRecord(ApplicationSubmissionContext.class);
        context.setApplicationId(applicationId);
        context.setApplicationName(applicationName);
        context.setQueue(queue);
        context.setPriority(priority);
        context.setAMContainerSpec(amContainer);
        context.setUnmanagedAM(isUnmanagedAM);
        context.setCancelTokensWhenComplete(cancelTokensWhenComplete);
        context.setMaxAppAttempts(maxAppAttempts);
        context.setResource(resource);
        context.setApplicationType(applicationType);
        context.setKeepContainersAcrossApplicationAttempts(keepContainers);
        return context;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, Priority priority, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, Resource resource, String applicationType) {
        return ApplicationSubmissionContext.newInstance(applicationId, applicationName, queue, priority, amContainer, isUnmanagedAM, cancelTokensWhenComplete, maxAppAttempts, resource, applicationType, false);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, Priority priority, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, Resource resource) {
        return ApplicationSubmissionContext.newInstance(applicationId, applicationName, queue, priority, amContainer, isUnmanagedAM, cancelTokensWhenComplete, maxAppAttempts, resource, null);
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public static ApplicationSubmissionContext newInstance(ApplicationId applicationId, String applicationName, String queue, Priority priority, ContainerLaunchContext amContainer, boolean isUnmanagedAM, boolean cancelTokensWhenComplete, int maxAppAttempts, Resource resource, String applicationType, boolean keepContainers, long attemptFailuresValidityInterval) {
        ApplicationSubmissionContext context = ApplicationSubmissionContext.newInstance(applicationId, applicationName, queue, priority, amContainer, isUnmanagedAM, cancelTokensWhenComplete, maxAppAttempts, resource, applicationType, keepContainers);
        context.setAttemptFailuresValidityInterval(attemptFailuresValidityInterval);
        return context;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationId getApplicationId();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setApplicationId(ApplicationId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getApplicationName();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setApplicationName(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getQueue();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setQueue(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Priority getPriority();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setPriority(Priority var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ContainerLaunchContext getAMContainerSpec();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setAMContainerSpec(ContainerLaunchContext var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract boolean getUnmanagedAM();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setUnmanagedAM(boolean var1);

    @InterfaceAudience.LimitedPrivate(value={"mapreduce"})
    @InterfaceStability.Unstable
    public abstract boolean getCancelTokensWhenComplete();

    @InterfaceAudience.LimitedPrivate(value={"mapreduce"})
    @InterfaceStability.Unstable
    public abstract void setCancelTokensWhenComplete(boolean var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getMaxAppAttempts();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setMaxAppAttempts(int var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Resource getResource();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setResource(Resource var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract String getApplicationType();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setApplicationType(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract boolean getKeepContainersAcrossApplicationAttempts();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setKeepContainersAcrossApplicationAttempts(boolean var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract Set<String> getApplicationTags();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setApplicationTags(Set<String> var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getAttemptFailuresValidityInterval();

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract void setAttemptFailuresValidityInterval(long var1);
}

