/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import com.google.common.base.Splitter;
import java.text.NumberFormat;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class ContainerId
implements Comparable<ContainerId> {
    private static final Splitter _SPLITTER = Splitter.on((char)'_').trimResults();
    private static final String CONTAINER_PREFIX = "container";
    private static final ThreadLocal<NumberFormat> appAttemptIdAndEpochFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(2);
            return fmt;
        }
    };
    private static final ThreadLocal<NumberFormat> containerIdFormat = new ThreadLocal<NumberFormat>(){

        @Override
        public NumberFormat initialValue() {
            NumberFormat fmt = NumberFormat.getInstance();
            fmt.setGroupingUsed(false);
            fmt.setMinimumIntegerDigits(6);
            return fmt;
        }
    };

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public static ContainerId newInstance(ApplicationAttemptId appAttemptId, long containerId) {
        ContainerId id = Records.newRecord(ContainerId.class);
        id.setContainerId(containerId);
        id.setApplicationAttemptId(appAttemptId);
        id.build();
        return id;
    }

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract ApplicationAttemptId getApplicationAttemptId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setApplicationAttemptId(ApplicationAttemptId var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract int getId();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getContainerId();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    protected abstract void setContainerId(long var1);

    public int hashCode() {
        int result = (int)(this.getContainerId() ^ this.getContainerId() >>> 32);
        result = 31 * result + this.getApplicationAttemptId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContainerId other = (ContainerId)obj;
        if (!this.getApplicationAttemptId().equals(other.getApplicationAttemptId())) {
            return false;
        }
        return this.getContainerId() == other.getContainerId();
    }

    @Override
    public int compareTo(ContainerId other) {
        if (this.getApplicationAttemptId().compareTo(other.getApplicationAttemptId()) == 0) {
            return Long.valueOf(this.getContainerId()).compareTo(other.getContainerId());
        }
        return this.getApplicationAttemptId().compareTo(other.getApplicationAttemptId());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("container_");
        ApplicationId appId = this.getApplicationAttemptId().getApplicationId();
        sb.append(appId.getClusterTimestamp()).append("_");
        sb.append(ApplicationId.appIdFormat.get().format(appId.getId())).append("_");
        sb.append(appAttemptIdAndEpochFormat.get().format(this.getApplicationAttemptId().getAttemptId())).append("_");
        sb.append(containerIdFormat.get().format(0xFFFFFFFFFFL & this.getContainerId()));
        long epoch = this.getContainerId() >> 40;
        if (epoch > 0L) {
            sb.append("_").append(appAttemptIdAndEpochFormat.get().format(epoch));
        }
        return sb.toString();
    }

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public static ContainerId fromString(String containerIdStr) {
        Iterator<String> it = _SPLITTER.split((CharSequence)containerIdStr).iterator();
        if (!((String)it.next()).equals(CONTAINER_PREFIX)) {
            throw new IllegalArgumentException("Invalid ContainerId prefix: " + containerIdStr);
        }
        try {
            ApplicationAttemptId appAttemptID = ContainerId.toApplicationAttemptId(it);
            long id = Long.parseLong(it.next());
            long epoch = 0L;
            if (it.hasNext()) {
                epoch = Integer.parseInt(it.next());
            }
            long cid = epoch << 40 | id;
            ContainerId containerId = ContainerId.newInstance(appAttemptID, cid);
            return containerId;
        }
        catch (NumberFormatException n) {
            throw new IllegalArgumentException("Invalid ContainerId: " + containerIdStr, n);
        }
    }

    private static ApplicationAttemptId toApplicationAttemptId(Iterator<String> it) throws NumberFormatException {
        ApplicationId appId = ApplicationId.newInstance(Long.parseLong(it.next()), Integer.parseInt(it.next()));
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance(appId, Integer.parseInt(it.next()));
        return appAttemptId;
    }

    protected abstract void build();
}

