/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.pmd;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.messages.LocaleHelper;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalTable;
import org.pentaho.metadata.model.SqlDataSource;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.query.impl.sql.MappedQuery;
import org.pentaho.metadata.query.impl.sql.SqlGenerator;
import org.pentaho.metadata.query.model.Parameter;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.util.DatabaseMetaUtil;
import org.pentaho.metadata.util.ThinModelConverter;
import org.pentaho.reporting.engine.classic.core.AbstractDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MetaTableModel;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryException;
import org.pentaho.reporting.engine.classic.core.ReportDataFactoryQueryTimeoutException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.modules.misc.datafactory.sql.SimpleSQLReportDataFactory;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.core.util.TypedMetaTableModel;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.IPmdConnectionProvider;
import org.pentaho.reporting.engine.classic.extensions.datasources.pmd.PmdMetaTableModel;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class SimplePmdDataFactory
extends AbstractDataFactory {
    private static final Log logger = LogFactory.getLog(SimplePmdDataFactory.class);
    private static final String[] EMPTY_QUERYNAMES = new String[0];
    private String domainId;
    private String xmiFile;
    private IPmdConnectionProvider connectionProvider;
    private String userField;
    private String passwordField;
    private transient IMetadataDomainRepository domainRepository;
    private transient Connection connection;
    private transient PmdSQLDataFactory sqlReportDataFactory;

    public IPmdConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    public void setConnectionProvider(IPmdConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    public String getDomainId() {
        return this.domainId;
    }

    public void setDomainId(String domainId) {
        this.domainId = domainId;
    }

    public String getXmiFile() {
        return this.xmiFile;
    }

    public void setXmiFile(String xmiFile) {
        this.xmiFile = xmiFile;
    }

    public String getUserField() {
        return this.userField;
    }

    public void setUserField(String userField) {
        this.userField = userField;
    }

    public String getPasswordField() {
        return this.passwordField;
    }

    public void setPasswordField(String passwordField) {
        this.passwordField = passwordField;
    }

    public boolean isQueryExecutable(String query, DataRow parameters) {
        return true;
    }

    public String[] getQueryNames() {
        return EMPTY_QUERYNAMES;
    }

    protected IMetadataDomainRepository getDomainRepository() throws ReportDataFactoryException {
        if (this.domainRepository == null) {
            this.domainRepository = this.connectionProvider.getMetadataDomainRepository(this.domainId, this.getResourceManager(), this.getContextKey(), this.xmiFile);
            if (this.domainRepository == null) {
                throw new ReportDataFactoryException("No repository found.");
            }
        }
        return this.domainRepository;
    }

    protected Query parseQuery(String query) throws ReportDataFactoryException {
        String xmlHelperClass = this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.extensions.datasources.pmd.XmlHelperClass");
        QueryXmlHelper helper = (QueryXmlHelper)ObjectUtilities.loadAndInstantiate((String)xmlHelperClass, SimplePmdDataFactory.class, QueryXmlHelper.class);
        if (helper == null) {
            throw new ReportDataFactoryException("Failed to create XmlHelper: " + xmlHelperClass);
        }
        try {
            return helper.fromXML(this.getDomainRepository(), query);
        }
        catch (ReportDataFactoryException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            throw new ReportDataFactoryException("Failed to parse query", (Throwable)e);
        }
    }

    private DatabaseMeta getDatabaseMeta(Query queryObject) throws ReportDataFactoryException {
        List tables = queryObject.getLogicalModel().getLogicalTables();
        if (tables.isEmpty()) {
            throw new ReportDataFactoryException("No Tables in this query");
        }
        SqlPhysicalModel sqlModel = (SqlPhysicalModel)((LogicalTable)tables.get(0)).getPhysicalTable().getPhysicalModel();
        return ThinModelConverter.convertToLegacy((String)sqlModel.getId(), (SqlDataSource)sqlModel.getDatasource());
    }

    private MappedQuery generateSQL(Query queryObject, DatabaseMeta databaseMeta, DataRow parameters) throws ReportDataFactoryException {
        try {
            String sqlGeneratorClass = this.getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.extensions.datasources.pmd.SqlGeneratorClass");
            SqlGenerator sqlGenerator = (SqlGenerator)ObjectUtilities.loadAndInstantiate((String)sqlGeneratorClass, SimplePmdDataFactory.class, SqlGenerator.class);
            if (sqlGenerator == null) {
                logger.error((Object)("Default SqlGenerator class " + sqlGeneratorClass + " not found."));
                throw new ReportDataFactoryException("Failed to generate SQL. No valid SqlGenerator class found.");
            }
            Map<String, Object> parameterMap = this.convertDataRowToMap(parameters);
            IMetadataDomainRepository domainRepository = this.getDomainRepository();
            Locale locale = this.computeLocale();
            return sqlGenerator.generateSql(queryObject, locale.toString(), domainRepository, databaseMeta, parameterMap, true);
        }
        catch (ReportDataFactoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ReportDataFactoryException(e.getMessage(), (Throwable)e);
        }
    }

    private Locale computeLocale() {
        ResourceBundleFactory resourceBundleFactory = this.getResourceBundleFactory();
        Locale locale = resourceBundleFactory != null ? resourceBundleFactory.getLocale() : LocaleHelper.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    private Map<String, Object> convertDataRowToMap(DataRow parameters) {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        String[] columnNames = parameters.getColumnNames();
        for (int i = 0; i < columnNames.length; ++i) {
            String key = columnNames[i];
            Object value = parameters.get(key);
            parameterMap.put(key, value);
        }
        return parameterMap;
    }

    private TableModel buildTableModel(DatabaseMeta databaseMeta, Query queryObject, MappedQuery mappedQuery, DataRow parameters) throws ReportDataFactoryException {
        this.initializeDataFactory(databaseMeta, parameters);
        ReportParameterValues computedParameterSet = new ReportParameterValues();
        computedParameterSet.put("::org.pentaho.reporting::query-limit", parameters.get("::org.pentaho.reporting::query-limit"));
        computedParameterSet.put("::org.pentaho.reporting::query-timeout", parameters.get("::org.pentaho.reporting::query-timeout"));
        String[] parameterNames = this.computeQueryParameter(queryObject, mappedQuery, parameters, computedParameterSet);
        this.computeQueryTimeout(queryObject, computedParameterSet);
        this.computeQueryLimit(queryObject, computedParameterSet);
        try {
            String sqlQuery = mappedQuery.getQuery();
            TableModel tableModel = this.sqlReportDataFactory.parametrizeAndQuery((DataRow)computedParameterSet, sqlQuery, parameterNames);
            List selections = queryObject.getSelections();
            if (selections.size() != tableModel.getColumnCount()) {
                throw new ReportDataFactoryException("Whatever the query returned, it does not look familiar");
            }
            return new PmdMetaTableModel((MetaTableModel)tableModel, queryObject.getSelections());
        }
        catch (SQLTimeoutException e) {
            throw new ReportDataFactoryQueryTimeoutException();
        }
        catch (SQLException e) {
            throw new ReportDataFactoryException("SQL-query did not execute successfully. " + e.getMessage(), (Throwable)e);
        }
    }

    private void initializeDataFactory(DatabaseMeta databaseMeta, DataRow parameters) throws ReportDataFactoryException {
        boolean isConnectionValid = this.checkConnectionValid();
        if (this.sqlReportDataFactory == null || !isConnectionValid) {
            if (this.sqlReportDataFactory != null) {
                this.sqlReportDataFactory.close();
            } else if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
            }
            String user = this.computeUsername(parameters);
            String password = this.computePassword(parameters);
            this.connection = this.getConnectionProvider().createConnection(databaseMeta, user, password);
            this.sqlReportDataFactory = new PmdSQLDataFactory(this.connection);
            this.sqlReportDataFactory.initialize(this.getDataFactoryContext());
        }
    }

    private boolean checkConnectionValid() {
        boolean isConnectionValid;
        try {
            isConnectionValid = this.connection != null && !this.connection.isClosed();
        }
        catch (SQLException ex) {
            isConnectionValid = false;
        }
        return isConnectionValid;
    }

    private String[] computeQueryParameter(Query queryObject, MappedQuery mappedQuery, DataRow parameters, ReportParameterValues computedParameterSet) {
        String[] parameterNames;
        HashMap<String, Parameter> queryParamMap = this.convertParametersToMap(queryObject);
        List paramColNames = mappedQuery.getParamList();
        if (paramColNames != null) {
            for (String colName : paramColNames) {
                Object parameterValue = parameters.get(colName);
                if (parameterValue != null) {
                    computedParameterSet.put(colName, parameterValue);
                    continue;
                }
                Parameter parameter = queryParamMap.get(colName);
                computedParameterSet.put(colName, parameter.getDefaultValue());
            }
            parameterNames = paramColNames.toArray(new String[paramColNames.size()]);
        } else {
            parameterNames = new String[]{};
        }
        return parameterNames;
    }

    private void computeQueryLimit(Query queryObject, ReportParameterValues computedParameterSet) {
        try {
            Object maxRowsProperty;
            Object existingQueryLimitObj = computedParameterSet.get("::org.pentaho.reporting::query-limit");
            if ((existingQueryLimitObj == null || existingQueryLimitObj instanceof Number && ((Number)existingQueryLimitObj).intValue() == -1) && (maxRowsProperty = queryObject.getLogicalModel().getProperty("max_rows")) != null && maxRowsProperty instanceof Number) {
                int maxRowsVal = ((Number)maxRowsProperty).intValue();
                computedParameterSet.put("::org.pentaho.reporting::query-limit", (Object)maxRowsVal);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ERROR_0002 - Could not read max_rows from model.", (Throwable)ex);
        }
    }

    private void computeQueryTimeout(Query queryObject, ReportParameterValues computedParameterSet) {
        try {
            Object timeoutProperty;
            Object existingQueryTimeoutObj = computedParameterSet.get("::org.pentaho.reporting::query-timeout");
            if ((existingQueryTimeoutObj == null || existingQueryTimeoutObj instanceof Number && ((Number)existingQueryTimeoutObj).intValue() == 0) && (timeoutProperty = queryObject.getLogicalModel().getProperty("timeout")) != null && timeoutProperty instanceof Number) {
                int timeoutVal = ((Number)timeoutProperty).intValue();
                computedParameterSet.put("::org.pentaho.reporting::query-timeout", (Object)timeoutVal);
            }
        }
        catch (Exception ex) {
            logger.error((Object)"ERROR_0001 - Could not read query timeout from model.", (Throwable)ex);
        }
    }

    private HashMap<String, Parameter> convertParametersToMap(Query queryObject) {
        List queryParamValues = queryObject.getParameters();
        HashMap<String, Parameter> queryParamMap = new HashMap<String, Parameter>();
        for (int i = 0; i < queryParamValues.size(); ++i) {
            Parameter parameter = (Parameter)queryParamValues.get(i);
            queryParamMap.put(parameter.getName(), parameter);
        }
        return queryParamMap;
    }

    public void close() {
        if (this.sqlReportDataFactory != null) {
            this.sqlReportDataFactory.close();
            this.sqlReportDataFactory = null;
        } else if (this.connection != null) {
            try {
                if (!this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException e) {
                logger.warn((Object)"Unable to close connection", (Throwable)e);
            }
            this.connection = null;
        }
        this.domainRepository = null;
    }

    public TableModel queryData(String queryName, DataRow parameters) throws ReportDataFactoryException {
        Query queryObject = this.parseQuery(queryName);
        if (queryObject.getLogicalModel().getPhysicalModel() instanceof SqlPhysicalModel) {
            try {
                DatabaseMeta databaseMeta = this.getDatabaseMeta(queryObject);
                DatabaseMeta activeDatabaseMeta = this.getActiveDatabaseMeta(databaseMeta, parameters);
                MappedQuery mappedQuery = this.generateSQL(queryObject, activeDatabaseMeta, parameters);
                return this.buildTableModel(databaseMeta, queryObject, mappedQuery, parameters);
            }
            catch (ReportDataFactoryException e) {
                throw e;
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
                throw new ReportDataFactoryException("Failed to perform query", (Throwable)e);
            }
        }
        return this.connectionProvider.executeQuery(queryObject, parameters);
    }

    public TableModel queryDesignTimeStructure(String queryName, DataRow parameter) throws ReportDataFactoryException {
        Query queryObject = this.parseQuery(queryName);
        List selections = queryObject.getSelections();
        TypedMetaTableModel tableModel = new TypedMetaTableModel();
        for (Selection selection : selections) {
            LogicalColumn logicalColumn = selection.getLogicalColumn();
            String id = logicalColumn.getId();
            DataType dataType = logicalColumn.getDataType();
            tableModel.addColumn(id, this.mapDataType(dataType));
        }
        return new PmdMetaTableModel((MetaTableModel)tableModel, selections);
    }

    private Class<?> mapDataType(DataType dataType) {
        switch (dataType) {
            case UNKNOWN: {
                return Object.class;
            }
            case STRING: {
                return String.class;
            }
            case DATE: {
                return Date.class;
            }
            case BOOLEAN: {
                return Boolean.class;
            }
            case NUMERIC: {
                return Number.class;
            }
            case BINARY: {
                return byte[].class;
            }
            case IMAGE: {
                return byte[].class;
            }
            case URL: {
                return Object.class;
            }
        }
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseMeta getActiveDatabaseMeta(DatabaseMeta databaseMeta, DataRow dataRow) {
        Connection connection;
        String user = this.computeUsername(dataRow);
        String password = this.computePassword(dataRow);
        try {
            connection = this.getConnectionProvider().createConnection(databaseMeta, user, password);
        }
        catch (ReportDataFactoryException rdfe) {
            return databaseMeta;
        }
        try {
            DatabaseInterface di = this.getDatabaseInterface(connection);
            if (di != null && !databaseMeta.getPluginId().equals(di.getPluginId())) {
                DatabaseMeta meta = (DatabaseMeta)databaseMeta.clone();
                DatabaseInterface di2 = (DatabaseInterface)di.clone();
                di2.setAccessType(databaseMeta.getAccessType());
                di2.setDatabaseName(databaseMeta.getDatabaseName());
                meta.setDatabaseInterface(di2);
                DatabaseMeta databaseMeta2 = meta;
                return databaseMeta2;
            }
            DatabaseMeta databaseMeta3 = databaseMeta;
            return databaseMeta3;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ignored) {
                    logger.debug((Object)"debug", (Throwable)ignored);
                }
            }
        }
    }

    private String computeUsername(DataRow dataRow) {
        Object userRaw;
        String user = this.userField == null ? null : ((userRaw = dataRow.get(this.userField)) instanceof String ? String.valueOf(userRaw) : null);
        return user;
    }

    private String computePassword(DataRow dataRow) {
        Object passwordField;
        String password = this.passwordField == null ? null : ((passwordField = dataRow.get(this.passwordField)) instanceof String ? String.valueOf(passwordField) : null);
        return password;
    }

    private DatabaseInterface getDatabaseInterface(Connection conn) {
        try {
            String prod = conn.getMetaData().getDatabaseProductName();
            DatabaseInterface di = DatabaseMetaUtil.getDatabaseInterface((String)prod);
            if (prod != null && di == null) {
                logger.warn((Object)"dialect not detected");
            }
            return di;
        }
        catch (SQLException e) {
            logger.warn((Object)"dialect exception", (Throwable)e);
            return null;
        }
    }

    public DataFactory derive() {
        SimplePmdDataFactory dataFactory = (SimplePmdDataFactory)this.clone();
        dataFactory.connection = null;
        dataFactory.sqlReportDataFactory = null;
        return dataFactory;
    }

    public void cancelRunningQuery() {
        if (this.sqlReportDataFactory != null) {
            this.sqlReportDataFactory.cancelRunningQuery();
        }
    }

    protected String translateQuery(String query) {
        return query;
    }

    protected String computedQuery(String queryName, DataRow parameters) throws ReportDataFactoryException {
        return queryName;
    }

    public String[] getReferencedFields(String query, DataRow parameter) throws ReportDataFactoryException {
        String queryRaw = this.computedQuery(query, parameter);
        if (query == null) {
            return null;
        }
        Query queryObject = this.parseQuery(queryRaw);
        List queryParamValues = queryObject.getParameters();
        LinkedHashSet<String> retval = new LinkedHashSet<String>();
        if (this.userField != null) {
            retval.add(this.userField);
        }
        if (this.passwordField != null) {
            retval.add(this.passwordField);
        }
        if (queryParamValues != null) {
            for (Parameter p : queryParamValues) {
                retval.add(p.getName());
            }
        }
        retval.add("::org.pentaho.reporting::query-limit");
        retval.add("::org.pentaho.reporting::query-timeout");
        return retval.toArray(new String[retval.size()]);
    }

    public ArrayList<Object> getQueryHash(String queryName, DataRow parameters) {
        ArrayList<Object> retval = new ArrayList<Object>();
        retval.add(((Object)((Object)this)).getClass().getName());
        retval.add(this.translateQuery(queryName));
        retval.add(this.domainId);
        retval.add(this.xmiFile);
        retval.add(this.getContextKey());
        retval.add(this.connectionProvider.getClass());
        return retval;
    }

    private class PmdSQLDataFactory
    extends SimpleSQLReportDataFactory {
        private PmdSQLDataFactory(Connection connection) {
            super(connection);
        }

        public TableModel parametrizeAndQuery(DataRow parameters, String translatedQuery, String[] params) throws SQLException {
            return super.parametrizeAndQuery(parameters, translatedQuery, params);
        }

        protected boolean isExpandArrays() {
            return true;
        }
    }
}

