/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.io.StringReader;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.action.hadoop.ScriptLanguageActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.HadoopAccessorException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class HiveActionExecutor
extends ScriptLanguageActionExecutor {
    private static final String HIVE_MAIN_CLASS_NAME = "org.apache.oozie.action.hadoop.HiveMain";
    static final String HIVE_SCRIPT = "oozie.hive.script";
    static final String HIVE_PARAMS = "oozie.hive.params";
    static final String HIVE_ARGS = "oozie.hive.args";

    public HiveActionExecutor() {
        super("hive");
    }

    @Override
    protected List<Class> getLauncherClasses() {
        List<Class> classes = super.getLauncherClasses();
        try {
            classes.add(Class.forName(HIVE_MAIN_CLASS_NAME));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", HIVE_MAIN_CLASS_NAME);
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        Configuration conf = super.setupActionConf(actionConf, context, actionXml, appPath);
        Namespace ns = actionXml.getNamespace();
        String script = actionXml.getChild("script", ns).getTextTrim();
        String scriptName = new Path(script).getName();
        String hiveScriptContent = context.getProtoActionConf().get(HIVE_SCRIPT);
        if (hiveScriptContent == null) {
            this.addToCache(conf, appPath, script + "#" + scriptName, false);
        }
        List params = actionXml.getChildren("param", ns);
        String[] strParams = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            strParams[i] = ((Element)params.get(i)).getTextTrim();
        }
        String[] strArgs = null;
        List eArgs = actionXml.getChildren("argument", ns);
        if (eArgs != null && eArgs.size() > 0) {
            strArgs = new String[eArgs.size()];
            for (int i = 0; i < eArgs.size(); ++i) {
                strArgs[i] = ((Element)eArgs.get(i)).getTextTrim();
            }
        }
        HiveActionExecutor.setHiveScript(conf, scriptName, strParams, strArgs);
        return conf;
    }

    public static void setHiveScript(Configuration conf, String script, String[] params, String[] args) {
        conf.set(HIVE_SCRIPT, script);
        MapReduceMain.setStrings((Configuration)conf, (String)HIVE_PARAMS, (String[])params);
        MapReduceMain.setStrings((Configuration)conf, (String)HIVE_ARGS, (String[])args);
    }

    @Override
    protected boolean getCaptureOutput(WorkflowAction action) throws JDOMException {
        return true;
    }

    @Override
    protected void getActionData(FileSystem actionFs, RunningJob runningJob, WorkflowAction action, ActionExecutor.Context context) throws HadoopAccessorException, JDOMException, IOException, URISyntaxException {
        super.getActionData(actionFs, runningJob, action, context);
        if (action.getData() != null) {
            Properties props = new Properties();
            props.load(new StringReader(action.getData()));
            context.setExternalChildIDs((String)props.get("hadoopJobs"));
        }
    }

    @Override
    protected String getDefaultShareLibName(Element actionXml) {
        return "hive";
    }

    @Override
    protected String getScriptName() {
        return HIVE_SCRIPT;
    }
}

