/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.XException;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StoreService;
import org.apache.oozie.store.Store;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XCallable;
import org.apache.oozie.util.XLog;

public abstract class Command<T, S extends Store>
implements XCallable<T> {
    private static final String INSTRUMENTATION_GROUP = "commands";
    private final long createdTime;
    private static final String INSTRUMENTATION_JOB_GROUP = "jobs";
    private static final long LOCK_TIMEOUT = 1000L;
    protected static final long LOCK_FAILURE_REQUEUE_INTERVAL = 30000L;
    protected Instrumentation instrumentation;
    private List<XCallable<Void>> callables;
    private List<XCallable<Void>> delayedCallables;
    private long delay = 0L;
    private List<XCallable<Void>> exceptionCallables;
    private String name;
    private String type;
    private String key;
    private int priority;
    private int logMask;
    private boolean withStore;
    protected boolean dryrun = false;
    private ArrayList<LockToken> locks = null;
    XLog.Info logInfo;

    public Command(String name, String type, int priority, int logMask) {
        this(name, type, priority, logMask, true);
    }

    public Command(String name, String type, int priority, int logMask, boolean withStore) {
        this.name = ParamChecker.notEmpty(name, "name");
        this.type = ParamChecker.notEmpty(type, "type");
        this.key = name + "_" + UUID.randomUUID();
        this.priority = priority;
        this.withStore = withStore;
        this.logMask = logMask;
        this.instrumentation = Services.get().get(InstrumentationService.class).get();
        this.logInfo = new XLog.Info(XLog.Info.get());
        this.createdTime = System.currentTimeMillis();
        this.locks = new ArrayList();
    }

    public Command(String name, String type, int priority, int logMask, boolean withStore, boolean dryrun) {
        this(name, type, priority, logMask, withStore);
        this.dryrun = dryrun;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getCreatedTime() {
        return this.createdTime;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final T call() throws CommandException {
        T t;
        XLog.Info.get().setParameters(this.logInfo);
        XLog log = XLog.getLog(this.getClass());
        log.trace(this.logMask, "Start", new Object[0]);
        Instrumentation.Cron cron = new Instrumentation.Cron();
        cron.start();
        this.callables = new ArrayList<XCallable<Void>>();
        this.delayedCallables = new ArrayList<XCallable<Void>>();
        this.exceptionCallables = new ArrayList<XCallable<Void>>();
        this.delay = 0L;
        Store store = null;
        boolean exception = false;
        try {
            boolean ret;
            if (this.withStore) {
                store = Services.get().get(StoreService.class).getStore(this.getStoreClass());
                store.beginTrx();
            }
            T result = this.execute(store);
            if (this.withStore) {
                if (store == null) {
                    throw new IllegalStateException("WorkflowStore should not be null");
                }
                if (FaultInjection.isActive("org.apache.oozie.command.SkipCommitFaultInjection")) {
                    throw new RuntimeException("Skipping Commit for Failover Testing");
                }
                store.commitTrx();
            }
            if (!(ret = Services.get().get(CallableQueueService.class).queueSerial(this.callables, 10L))) {
                this.logQueueCallableFalse(this.callables);
            }
            if (!(ret = Services.get().get(CallableQueueService.class).queueSerial(this.delayedCallables, this.delay))) {
                this.logQueueCallableFalse(this.delayedCallables);
            }
            t = result;
        }
        catch (XException ex) {
            try {
                boolean ret;
                log.error(this.logMask | 4, "XException, {0}", ex.getMessage(), ex);
                if (store != null) {
                    log.info(1, "XException - connection logs from store {0}, {1}", store.getConnection(), store.isClosed());
                }
                exception = true;
                if (store != null && store.isActive()) {
                    try {
                        store.rollbackTrx();
                    }
                    catch (RuntimeException rex) {
                        log.warn(this.logMask | 4, "openjpa error, {0}, {1}", this.name, rex.getMessage(), rex);
                    }
                }
                if (!(ret = Services.get().get(CallableQueueService.class).queueSerial(this.exceptionCallables, 10L))) {
                    this.logQueueCallableFalse(this.exceptionCallables);
                }
                if (!(ex instanceof CommandException)) throw new CommandException(ex);
                throw (CommandException)ex;
                catch (Exception ex2) {
                    log.error(this.logMask | 4, "Exception, {0}", ex2.getMessage(), ex2);
                    exception = true;
                    if (store == null || !store.isActive()) throw new CommandException(ErrorCode.E0607, this.name, ex2.getMessage(), ex2);
                    try {
                        store.rollbackTrx();
                        throw new CommandException(ErrorCode.E0607, this.name, ex2.getMessage(), ex2);
                    }
                    catch (RuntimeException rex) {
                        log.warn(this.logMask | 4, "openjpa error, {0}, {1}", this.name, rex.getMessage(), rex);
                    }
                    throw new CommandException(ErrorCode.E0607, this.name, ex2.getMessage(), ex2);
                }
                catch (Error er) {
                    log.error(this.logMask | 4, "Error, {0}", er.getMessage(), er);
                    exception = true;
                    if (store == null) throw er;
                    if (!store.isActive()) throw er;
                    try {
                        store.rollbackTrx();
                        throw er;
                    }
                    catch (RuntimeException rex) {
                        log.warn(this.logMask | 4, "openjpa error, {0}, {1}", this.name, rex.getMessage(), rex);
                    }
                    throw er;
                }
            }
            catch (Throwable throwable) {
                FaultInjection.deactivate("org.apache.oozie.command.SkipCommitFaultInjection");
                cron.stop();
                this.instrumentation.addCron(INSTRUMENTATION_GROUP, this.name, cron);
                this.incrCommandCounter(1);
                log.trace(this.logMask, "End", new Object[0]);
                if (this.locks != null) {
                    for (LockToken lock : this.locks) {
                        lock.release();
                    }
                    this.locks.clear();
                }
                if (store == null) throw throwable;
                if (store.isActive()) {
                    log.warn(this.logMask | 4, "transaction is not committed or rolled back before closing entitymanager.", new Object[0]);
                    throw throwable;
                }
                try {
                    store.closeTrx();
                    throw throwable;
                }
                catch (RuntimeException rex) {
                    if (!exception) throw rex;
                    log.warn(this.logMask | 4, "openjpa error, {0}, {1}", this.name, rex.getMessage(), rex);
                    throw throwable;
                }
            }
        }
        FaultInjection.deactivate("org.apache.oozie.command.SkipCommitFaultInjection");
        cron.stop();
        this.instrumentation.addCron(INSTRUMENTATION_GROUP, this.name, cron);
        this.incrCommandCounter(1);
        log.trace(this.logMask, "End", new Object[0]);
        if (this.locks != null) {
            for (LockToken lock : this.locks) {
                lock.release();
            }
            this.locks.clear();
        }
        if (store == null) return t;
        if (store.isActive()) {
            log.warn(this.logMask | 4, "transaction is not committed or rolled back before closing entitymanager.", new Object[0]);
            return t;
        }
        try {
            store.closeTrx();
            return t;
        }
        catch (RuntimeException rex) {
            if (!exception) throw rex;
            log.warn(this.logMask | 4, "openjpa error, {0}, {1}", this.name, rex.getMessage(), rex);
            return t;
        }
    }

    protected void queueCallable(XCallable<Void> callable) {
        this.callables.add(callable);
    }

    protected void queueCallable(List<? extends XCallable<Void>> callables) {
        this.callables.addAll(callables);
    }

    protected void queueCallable(XCallable<Void> callable, long delay) {
        this.delayedCallables.add(callable);
        this.delay = Math.max(this.delay, delay);
    }

    protected void queueCallableForException(XCallable<Void> callable) {
        this.exceptionCallables.add(callable);
    }

    protected void logQueueCallableFalse(List<? extends XCallable<Void>> callables) {
        StringBuilder sb = new StringBuilder("Unable to queue the callables, delayedQueue is full or system is in SAFEMODE - failed to queue:[");
        int size = callables.size();
        for (int i = 0; i < size; ++i) {
            XCallable<Void> callable = callables.get(i);
            sb.append(callable.getName());
            if (i < size - 1) {
                sb.append(", ");
                continue;
            }
            sb.append("]");
        }
        XLog.getLog(this.getClass()).warn(sb.toString());
    }

    protected abstract T call(S var1) throws StoreException, CommandException;

    protected abstract Class<? extends Store> getStoreClass();

    protected void setLogInfo(CoordinatorJobBean cBean) {
        if (this.logInfo.getParameter("GROUP") == null) {
            this.logInfo.setParameter("GROUP", cBean.getGroup());
        }
        if (this.logInfo.getParameter("USER") == null) {
            this.logInfo.setParameter("USER", cBean.getUser());
        }
        this.logInfo.setParameter("JOB", cBean.getId());
        this.logInfo.setParameter("TOKEN", "");
        this.logInfo.setParameter("APP", cBean.getAppName());
        XLog.Info.get().setParameters(this.logInfo);
    }

    protected void setLogInfo(CoordinatorActionBean action) {
        this.logInfo.setParameter("JOB", action.getJobId());
        this.logInfo.setParameter("ACTION", action.getId());
        XLog.Info.get().setParameters(this.logInfo);
    }

    protected void setLogInfo(WorkflowJobBean workflow) {
        if (this.logInfo.getParameter("GROUP") == null) {
            this.logInfo.setParameter("GROUP", workflow.getGroup());
        }
        if (this.logInfo.getParameter("USER") == null) {
            this.logInfo.setParameter("USER", workflow.getUser());
        }
        this.logInfo.setParameter("JOB", workflow.getId());
        this.logInfo.setParameter("TOKEN", workflow.getLogToken());
        this.logInfo.setParameter("APP", workflow.getAppName());
        XLog.Info.get().setParameters(this.logInfo);
    }

    protected void setLogInfo(WorkflowActionBean action) {
        this.logInfo.setParameter("JOB", action.getJobId());
        this.logInfo.setParameter("TOKEN", action.getLogToken());
        this.logInfo.setParameter("ACTION", action.getId());
        XLog.Info.get().setParameters(this.logInfo);
    }

    protected void resetLogInfoAction() {
        this.logInfo.clearParameter("ACTION");
        XLog.Info.get().clearParameter("ACTION");
    }

    protected void resetLogInfoWorkflow() {
        this.logInfo.clearParameter("JOB");
        this.logInfo.clearParameter("APP");
        this.logInfo.clearParameter("TOKEN");
        XLog.Info.get().clearParameter("JOB");
        XLog.Info.get().clearParameter("APP");
        XLog.Info.get().clearParameter("TOKEN");
    }

    private void incrCounter(String group, String name, int count) {
        if (this.instrumentation != null) {
            this.instrumentation.incr(group, name, count);
        }
    }

    protected void incrCommandCounter(int count) {
        this.incrCounter(INSTRUMENTATION_GROUP, this.name, count);
    }

    protected void incrJobCounter(int count) {
        this.incrJobCounter(this.name, count);
    }

    protected void incrJobCounter(String name, int count) {
        this.incrCounter(INSTRUMENTATION_JOB_GROUP, name, count);
    }

    protected Instrumentation getInstrumentation() {
        return this.instrumentation;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType());
        sb.append(",").append(this.getPriority());
        return sb.toString();
    }

    protected boolean lock(String id) throws InterruptedException {
        if (id == null || id.length() == 0) {
            XLog.getLog(this.getClass()).warn("lock(): Id is null or empty :" + id + ":");
            return false;
        }
        LockToken token = Services.get().get(MemoryLocksService.class).getWriteLock(id, 1000L);
        if (token != null) {
            this.locks.add(token);
            return true;
        }
        return false;
    }

    protected T execute(S store) throws CommandException, StoreException {
        T result = this.call(store);
        return result;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getEntityKey() {
        return this.key;
    }

    @Override
    public void setInterruptMode(boolean mode) {
    }

    @Override
    public boolean inInterruptMode() {
        return false;
    }
}

