/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.SubmitTransitionXCommand;
import org.apache.oozie.command.bundle.BundleJobException;
import org.apache.oozie.command.bundle.BundleStartXCommand;
import org.apache.oozie.executor.jpa.BundleJobInsertJPAExecutor;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.ELUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.InstrumentUtils;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.ParameterVerifier;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.xml.sax.SAXException;

public class BundleSubmitXCommand
extends SubmitTransitionXCommand {
    private Configuration conf;
    public static final String CONFIG_DEFAULT = "bundle-config-default.xml";
    public static final String BUNDLE_XML_FILE = "bundle.xml";
    private final BundleJobBean bundleBean = new BundleJobBean();
    private String jobId;
    private JPAService jpaService = null;
    private static final Set<String> DISALLOWED_USER_PROPERTIES = new HashSet<String>();
    private static final Set<String> DISALLOWED_DEFAULT_PROPERTIES = new HashSet<String>();

    public BundleSubmitXCommand(Configuration conf) {
        super("bundle_submit", "bundle_submit", 1);
        this.conf = ParamChecker.notNull(conf, "conf");
    }

    public BundleSubmitXCommand(boolean dryrun, Configuration conf) {
        this(conf);
        this.dryrun = dryrun;
    }

    @Override
    protected String submit() throws CommandException {
        this.LOG.info("STARTED Bundle Submit");
        try {
            InstrumentUtils.incrJobCounter(this.getName(), 1, this.getInstrumentation());
            ParameterVerifier.verifyParameters(this.conf, XmlUtils.parseXml(this.bundleBean.getOrigJobXml()));
            String jobXmlWithNoComment = XmlUtils.removeComments(this.bundleBean.getOrigJobXml().toString());
            XConfiguration resolvedVarsConf = new XConfiguration();
            for (Map.Entry entry : this.conf) {
                resolvedVarsConf.set((String)entry.getKey(), this.conf.get((String)entry.getKey()));
            }
            this.conf = resolvedVarsConf;
            String resolvedJobXml = this.resolvedVars(jobXmlWithNoComment, this.conf);
            this.verifyCoordNameUnique(resolvedJobXml);
            this.jobId = this.storeToDB(this.bundleBean, resolvedJobXml);
            LogUtils.setLogInfo(this.bundleBean, this.logInfo);
            if (this.dryrun) {
                Date jobEndTime;
                Date startTime = this.bundleBean.getStartTime();
                long startTimeMilli = startTime.getTime();
                long endTimeMilli = startTimeMilli + 3600000L;
                Date endTime = new Date(endTimeMilli);
                if (endTime.compareTo(jobEndTime = this.bundleBean.getEndTime()) > 0) {
                    endTime = jobEndTime;
                }
                this.jobId = this.bundleBean.getId();
                this.LOG.info("[" + this.jobId + "]: Update status to PREP");
                this.bundleBean.setStatus(Job.Status.PREP);
                try {
                    new XConfiguration(new StringReader(this.bundleBean.getConf()));
                }
                catch (IOException e1) {
                    this.LOG.warn((Object)("Configuration parse error. read from DB :" + this.bundleBean.getConf()), e1);
                }
                String output = this.bundleBean.getJobXml() + System.getProperty("line.separator");
                return output;
            }
            if (this.bundleBean.getKickoffTime() == null) {
                this.LOG.debug("Since kickoff time is not defined for job id " + this.jobId + ". Queuing and BundleStartXCommand immediately after submission");
                this.queue(new BundleStartXCommand(this.jobId));
            }
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E1310, ex.getMessage(), ex);
        }
        this.LOG.info("ENDED Bundle Submit");
        return this.jobId;
    }

    @Override
    public void notifyParent() throws CommandException {
    }

    @Override
    public String getEntityKey() {
        return null;
    }

    @Override
    protected boolean isLockRequired() {
        return false;
    }

    @Override
    protected void loadState() throws CommandException {
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }

    @Override
    protected void eagerLoadState() throws CommandException {
        super.eagerLoadState();
        this.jpaService = Services.get().get(JPAService.class);
        if (this.jpaService == null) {
            throw new CommandException(ErrorCode.E0610, new Object[0]);
        }
    }

    @Override
    protected void eagerVerifyPrecondition() throws CommandException, PreconditionException {
        try {
            super.eagerVerifyPrecondition();
            this.mergeDefaultConfig();
            String appXml = this.readAndValidateXml();
            this.bundleBean.setOrigJobXml(appXml);
            this.LOG.debug("jobXml after initial validation " + XmlUtils.prettyPrint(appXml).toString());
        }
        catch (BundleJobException ex) {
            this.LOG.warn((Object)"BundleJobException:  ", ex);
            throw new CommandException(ex);
        }
        catch (IllegalArgumentException iex) {
            this.LOG.warn((Object)"IllegalArgumentException:  ", iex);
            throw new CommandException(ErrorCode.E1310, iex.getMessage(), iex);
        }
        catch (Exception ex) {
            this.LOG.warn((Object)"Exception:  ", ex);
            throw new CommandException(ErrorCode.E1310, ex.getMessage(), ex);
        }
    }

    protected void mergeDefaultConfig() throws CommandException {
        Path configDefault = null;
        try {
            String bundleAppPathStr = this.conf.get("oozie.bundle.application.path");
            Path bundleAppPath = new Path(bundleAppPathStr);
            String user = ParamChecker.notEmpty(this.conf.get("user.name"), "user.name");
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            JobConf fsConf = has.createJobConf(bundleAppPath.toUri().getAuthority());
            FileSystem fs = has.createFileSystem(user, bundleAppPath.toUri(), (Configuration)fsConf);
            configDefault = !fs.isFile(bundleAppPath) ? new Path(bundleAppPath, CONFIG_DEFAULT) : new Path(bundleAppPath.getParent(), CONFIG_DEFAULT);
            if (fs.exists(configDefault)) {
                XConfiguration defaultConf = new XConfiguration((InputStream)fs.open(configDefault));
                PropertiesUtils.checkDisallowedProperties(defaultConf, DISALLOWED_DEFAULT_PROPERTIES);
                XConfiguration.injectDefaults(defaultConf, this.conf);
            } else {
                this.LOG.info("configDefault Doesn't exist " + configDefault);
            }
            PropertiesUtils.checkDisallowedProperties(this.conf, DISALLOWED_USER_PROPERTIES);
        }
        catch (IOException e) {
            throw new CommandException(ErrorCode.E0702, e.getMessage() + " : Problem reading default config " + configDefault, e);
        }
        catch (HadoopAccessorException e) {
            throw new CommandException(e);
        }
        this.LOG.debug("Merged CONF :" + XmlUtils.prettyPrint(this.conf).toString());
    }

    private String readAndValidateXml() throws BundleJobException {
        String appPath = ParamChecker.notEmpty(this.conf.get("oozie.bundle.application.path"), "oozie.bundle.application.path");
        String bundleXml = this.readDefinition(appPath);
        this.validateXml(bundleXml);
        return bundleXml;
    }

    protected String readDefinition(String appPath) throws BundleJobException {
        String user = ParamChecker.notEmpty(this.conf.get("user.name"), "user.name");
        try {
            URI uri = new URI(appPath);
            this.LOG.debug("user =" + user);
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            JobConf fsConf = has.createJobConf(uri.getAuthority());
            FileSystem fs = has.createFileSystem(user, uri, (Configuration)fsConf);
            Path appDefPath = null;
            Path path = new Path(uri.getPath());
            appDefPath = !fs.isFile(path) ? new Path(path, BUNDLE_XML_FILE) : path;
            InputStreamReader reader = new InputStreamReader((InputStream)fs.open(appDefPath));
            StringWriter writer = new StringWriter();
            IOUtils.copyCharStream(reader, writer);
            return writer.toString();
        }
        catch (IOException ex) {
            this.LOG.warn((Object)("IOException :" + XmlUtils.prettyPrint(this.conf)), ex);
            throw new BundleJobException(ErrorCode.E1301, ex.getMessage(), ex);
        }
        catch (URISyntaxException ex) {
            this.LOG.warn("URISyException :" + ex.getMessage());
            throw new BundleJobException(ErrorCode.E1302, appPath, ex.getMessage(), ex);
        }
        catch (HadoopAccessorException ex) {
            throw new BundleJobException(ex);
        }
        catch (Exception ex) {
            this.LOG.warn((Object)"Exception :", ex);
            throw new BundleJobException(ErrorCode.E1301, ex.getMessage(), ex);
        }
    }

    private void validateXml(String xmlContent) throws BundleJobException {
        Schema schema = Services.get().get(SchemaService.class).getSchema(SchemaService.SchemaName.BUNDLE);
        Validator validator = schema.newValidator();
        try {
            validator.validate(new StreamSource(new StringReader(xmlContent)));
        }
        catch (SAXException ex) {
            this.LOG.warn((Object)"SAXException :", ex);
            throw new BundleJobException(ErrorCode.E0701, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            this.LOG.warn((Object)"IOException :", ex);
            throw new BundleJobException(ErrorCode.E0702, ex.getMessage(), ex);
        }
    }

    private String storeToDB(BundleJobBean bundleJob, String resolvedJobXml) throws CommandException {
        try {
            Element kickoffTimeElement;
            this.jobId = Services.get().get(UUIDService.class).generateId(UUIDService.ApplicationType.BUNDLE);
            bundleJob.setId(this.jobId);
            String name = XmlUtils.parseXml(this.bundleBean.getOrigJobXml()).getAttributeValue("name");
            name = ELUtils.resolveAppName(name, this.conf);
            bundleJob.setAppName(name);
            bundleJob.setAppPath(this.conf.get("oozie.bundle.application.path"));
            bundleJob.setCreatedTime(new Date());
            bundleJob.setUser(this.conf.get("user.name"));
            String group = ConfigUtils.getWithDeprecatedCheck(this.conf, "oozie.job.acl", "group.name", null);
            bundleJob.setGroup(group);
            bundleJob.setConf(XmlUtils.prettyPrint(this.conf).toString());
            bundleJob.setJobXml(resolvedJobXml);
            Element jobElement = XmlUtils.parseXml(resolvedJobXml);
            Element controlsElement = jobElement.getChild("controls", jobElement.getNamespace());
            if (controlsElement != null && (kickoffTimeElement = controlsElement.getChild("kick-off-time", jobElement.getNamespace())) != null && !kickoffTimeElement.getValue().isEmpty()) {
                Date kickoffTime = DateUtils.parseDateOozieTZ(kickoffTimeElement.getValue());
                bundleJob.setKickoffTime(kickoffTime);
            }
            bundleJob.setLastModifiedTime(new Date());
            if (!this.dryrun) {
                this.jpaService.execute(new BundleJobInsertJPAExecutor(bundleJob));
            }
        }
        catch (Exception ex) {
            throw new CommandException(ErrorCode.E1301, ex.getMessage(), ex);
        }
        return this.jobId;
    }

    @Override
    public Job getJob() {
        return this.bundleBean;
    }

    private String resolvedVars(String bundleXml, Configuration conf) throws BundleJobException {
        try {
            ELEvaluator eval = this.createEvaluator(conf);
            return eval.evaluate(bundleXml, String.class);
        }
        catch (Exception e) {
            throw new BundleJobException(ErrorCode.E1004, e.getMessage(), e);
        }
    }

    public ELEvaluator createEvaluator(Configuration conf) throws BundleJobException {
        ELEvaluator eval;
        try {
            ELEvaluator.Context context = new ELEvaluator.Context();
            eval = new ELEvaluator(context);
            for (Map.Entry entry : conf) {
                eval.setVariable((String)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            throw new BundleJobException(ErrorCode.E1004, e.getMessage(), e);
        }
        return eval;
    }

    private Void verifyCoordNameUnique(String resolvedJobXml) throws CommandException {
        HashSet<String> set = new HashSet<String>();
        try {
            Element bAppXml = XmlUtils.parseXml(resolvedJobXml);
            List coordElems = bAppXml.getChildren("coordinator", bAppXml.getNamespace());
            for (Element elem : coordElems) {
                Attribute name = elem.getAttribute("name");
                if (name != null) {
                    if (set.contains(name.getValue())) {
                        throw new CommandException(ErrorCode.E1304, name);
                    }
                    set.add(name.getValue());
                    continue;
                }
                throw new CommandException(ErrorCode.E1305, new Object[0]);
            }
        }
        catch (JDOMException jex) {
            throw new CommandException(ErrorCode.E1301, new Object[]{jex.getMessage(), jex});
        }
        return null;
    }

    @Override
    public void updateJob() throws CommandException {
    }

    @Override
    public void performWrites() throws CommandException {
    }

    static {
        String[] badUserProps = new String[]{"YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "DAYS", "HOURS", "MINUTES", "KB", "MB", "GB", "TB", "PB", "RECORDS", "MAP_IN", "MAP_OUT", "REDUCE_IN", "REDUCE_OUT", "GROUPS"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_USER_PROPERTIES);
        String[] badDefaultProps = new String[]{"user.name"};
        PropertiesUtils.createPropertySet(badUserProps, DISALLOWED_DEFAULT_PROPERTIES);
        PropertiesUtils.createPropertySet(badDefaultProps, DISALLOWED_DEFAULT_PROPERTIES);
    }
}

