/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency.hcat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.dependency.hcat.HCatDependencyCache;
import org.apache.oozie.dependency.hcat.WaitingAction;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.XLog;

public class SimpleHCatDependencyCache
implements HCatDependencyCache {
    private static XLog LOG = XLog.getLog(SimpleHCatDependencyCache.class);
    private static String DELIMITER = ";";
    private ConcurrentMap<String, ConcurrentMap<String, Map<String, Collection<WaitingAction>>>> missingDeps;
    private ConcurrentMap<String, Collection<String>> availableDeps;

    @Override
    public void init(Configuration conf) {
        this.missingDeps = new ConcurrentHashMap<String, ConcurrentMap<String, Map<String, Collection<WaitingAction>>>>();
        this.availableDeps = new ConcurrentHashMap<String, Collection<String>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMissingDependency(HCatURI hcatURI, String actionID) {
        ConcurrentMap existingMap;
        String tableKey = hcatURI.getServer() + DELIMITER + hcatURI.getDb() + DELIMITER + hcatURI.getTable();
        SortedPKV sortedPKV = new SortedPKV(hcatURI.getPartitionMap());
        String partKey = sortedPKV.getPartKeys();
        String partVal = sortedPKV.getPartVals();
        ConcurrentMap partKeyPatterns = (ConcurrentHashMap)this.missingDeps.get(tableKey);
        if (partKeyPatterns == null && (existingMap = (ConcurrentMap)this.missingDeps.putIfAbsent(tableKey, partKeyPatterns = new ConcurrentHashMap())) != null) {
            partKeyPatterns = existingMap;
        }
        ConcurrentHashMap concurrentHashMap = partKeyPatterns;
        synchronized (concurrentHashMap) {
            HashSet<WaitingAction> waitingActions;
            this.missingDeps.put(tableKey, partKeyPatterns);
            HashMap<String, HashSet<WaitingAction>> partValues = (HashMap<String, HashSet<WaitingAction>>)partKeyPatterns.get(partKey);
            if (partValues == null) {
                partValues = new HashMap<String, HashSet<WaitingAction>>();
                partKeyPatterns.put(partKey, partValues);
            }
            if ((waitingActions = (HashSet<WaitingAction>)partValues.get(partVal)) == null) {
                waitingActions = new HashSet<WaitingAction>();
                partValues.put(partVal, waitingActions);
            }
            waitingActions.add(new WaitingAction(actionID, hcatURI.toURIString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeMissingDependency(HCatURI hcatURI, String actionID) {
        String tableKey = hcatURI.getServer() + DELIMITER + hcatURI.getDb() + DELIMITER + hcatURI.getTable();
        SortedPKV sortedPKV = new SortedPKV(hcatURI.getPartitionMap());
        String partKey = sortedPKV.getPartKeys();
        String partVal = sortedPKV.getPartVals();
        Map partKeyPatterns = (Map)this.missingDeps.get(tableKey);
        if (partKeyPatterns == null) {
            LOG.warn("Remove missing dependency - Missing table entry - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
            return false;
        }
        Map map = partKeyPatterns;
        synchronized (map) {
            Map partValues = (Map)partKeyPatterns.get(partKey);
            if (partValues == null) {
                LOG.warn("Remove missing dependency - Missing partition pattern - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
                return false;
            }
            Collection waitingActions = (Collection)partValues.get(partVal);
            if (waitingActions == null) {
                LOG.warn("Remove missing dependency - Missing partition value - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
                return false;
            }
            boolean removed = waitingActions.remove(new WaitingAction(actionID, hcatURI.toURIString()));
            if (!removed) {
                LOG.warn("Remove missing dependency - Missing action ID - uri={0}, actionID={1}", hcatURI.toURIString(), actionID);
            }
            if (waitingActions.isEmpty()) {
                partValues.remove(partVal);
                if (partValues.isEmpty()) {
                    partKeyPatterns.remove(partKey);
                }
                if (partKeyPatterns.isEmpty()) {
                    this.missingDeps.remove(tableKey);
                    HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
                    hcatService.unregisterFromNotification(hcatURI);
                }
            }
            return removed;
        }
    }

    @Override
    public Collection<String> getWaitingActions(HCatURI hcatURI) {
        String tableKey = hcatURI.getServer() + DELIMITER + hcatURI.getDb() + DELIMITER + hcatURI.getTable();
        SortedPKV sortedPKV = new SortedPKV(hcatURI.getPartitionMap());
        String partKey = sortedPKV.getPartKeys();
        String partVal = sortedPKV.getPartVals();
        Map partKeyPatterns = (Map)this.missingDeps.get(tableKey);
        if (partKeyPatterns == null) {
            return null;
        }
        Map partValues = (Map)partKeyPatterns.get(partKey);
        if (partValues == null) {
            return null;
        }
        Collection waitingActions = (Collection)partValues.get(partVal);
        if (waitingActions == null) {
            return null;
        }
        ArrayList<String> actionIDs = new ArrayList<String>();
        String uriString = hcatURI.toURIString();
        for (WaitingAction action : waitingActions) {
            if (!action.getDependencyURI().equals(uriString)) continue;
            actionIDs.add(action.getActionID());
        }
        return actionIDs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> markDependencyAvailable(String server, String db, String table, Map<String, String> partitions) {
        String tableKey = server + DELIMITER + db + DELIMITER + table;
        Map partKeyPatterns = (Map)this.missingDeps.get(tableKey);
        if (partKeyPatterns == null) {
            LOG.warn("Got partition available notification for " + tableKey + ". Unexpected and should not be listening to topic. Unregistering topic");
            HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
            hcatService.unregisterFromNotification(server, db, table);
            return null;
        }
        HashSet<String> actionsWithAvailDep = new HashSet<String>();
        ArrayList partKeysToRemove = new ArrayList();
        StringBuilder partValSB = new StringBuilder();
        Map map = partKeyPatterns;
        synchronized (map) {
            for (Map.Entry entry : partKeyPatterns.entrySet()) {
                String[] partKeys = ((String)entry.getKey()).split(DELIMITER);
                partValSB.setLength(0);
                for (String key : partKeys) {
                    partValSB.append(partitions.get(key)).append(DELIMITER);
                }
                partValSB.setLength(partValSB.length() - 1);
                Map partValues = (Map)entry.getValue();
                String partVal = partValSB.toString();
                Collection wActions = (Collection)((Map)entry.getValue()).get(partVal);
                if (wActions == null) continue;
                for (WaitingAction wAction : wActions) {
                    Collection existing;
                    String actionID = wAction.getActionID();
                    actionsWithAvailDep.add(actionID);
                    Collection<String> depURIs = (ArrayList<String>)this.availableDeps.get(actionID);
                    if (depURIs == null && (existing = (Collection)this.availableDeps.putIfAbsent(actionID, depURIs = new ArrayList<String>())) != null) {
                        depURIs = existing;
                    }
                    ArrayList<String> arrayList = depURIs;
                    synchronized (arrayList) {
                        depURIs.add(wAction.getDependencyURI());
                        this.availableDeps.put(actionID, depURIs);
                    }
                }
                partValues.remove(partVal);
                if (!partValues.isEmpty()) continue;
                partKeysToRemove.add(entry.getKey());
            }
            for (String partKey : partKeysToRemove) {
                partKeyPatterns.remove(partKey);
            }
            if (partKeyPatterns.isEmpty()) {
                this.missingDeps.remove(tableKey);
                HCatAccessorService hcatService = Services.get().get(HCatAccessorService.class);
                hcatService.unregisterFromNotification(server, db, table);
            }
        }
        return actionsWithAvailDep;
    }

    @Override
    public Collection<String> getAvailableDependencyURIs(String actionID) {
        ArrayList available = (ArrayList)this.availableDeps.get(actionID);
        if (available != null) {
            available = new ArrayList(available);
        }
        return available;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAvailableDependencyURIs(String actionID, Collection<String> dependencyURIs) {
        if (!this.availableDeps.containsKey(actionID)) {
            return false;
        }
        Collection availList = (Collection)this.availableDeps.get(actionID);
        if (!availList.removeAll(dependencyURIs)) {
            return false;
        }
        Collection collection = availList;
        synchronized (collection) {
            if (availList.isEmpty()) {
                this.availableDeps.remove(actionID);
            }
        }
        return true;
    }

    @Override
    public void destroy() {
        this.missingDeps.clear();
        this.availableDeps.clear();
    }

    private static class SortedPKV {
        private StringBuilder partKeys = new StringBuilder();
        private StringBuilder partVals = new StringBuilder();

        public SortedPKV(Map<String, String> partitions) {
            ArrayList<String> keys = new ArrayList<String>(partitions.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                this.partKeys.append(key).append(DELIMITER);
                this.partVals.append(partitions.get(key)).append(DELIMITER);
            }
            this.partKeys.setLength(this.partKeys.length() - 1);
            this.partVals.setLength(this.partVals.length() - 1);
        }

        public String getPartKeys() {
            return this.partKeys.toString();
        }

        public String getPartVals() {
            return this.partVals.toString();
        }
    }
}

