/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Collection;
import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class BulkUpdateInsertForCoordActionStatusJPAExecutor
implements JPAExecutor<Void> {
    private Collection<JsonBean> updateList;
    private Collection<JsonBean> insertList;

    public BulkUpdateInsertForCoordActionStatusJPAExecutor(Collection<JsonBean> updateList, Collection<JsonBean> insertList) {
        this.updateList = updateList;
        this.insertList = insertList;
    }

    public BulkUpdateInsertForCoordActionStatusJPAExecutor() {
    }

    public void setUpdateList(Collection<JsonBean> updateList) {
        this.updateList = updateList;
    }

    public void setInsertList(Collection<JsonBean> insertList) {
        this.insertList = insertList;
    }

    @Override
    public String getName() {
        return "BulkUpdateInsertForCoordActionStatusJPAExecutor";
    }

    @Override
    public Void execute(EntityManager em) throws JPAExecutorException {
        try {
            if (this.insertList != null) {
                for (JsonBean entity : this.insertList) {
                    ParamChecker.notNull(entity, "JsonBean");
                    em.persist((Object)entity);
                }
            }
            FaultInjection.activate("org.apache.oozie.command.SkipCommitFaultInjection");
            if (this.updateList != null) {
                for (JsonBean entity : this.updateList) {
                    ParamChecker.notNull(entity, "JsonBean");
                    if (entity instanceof CoordinatorActionBean) {
                        CoordinatorActionBean action = (CoordinatorActionBean)entity;
                        Query q = em.createNamedQuery("UPDATE_COORD_ACTION_STATUS_PENDING_TIME");
                        q.setParameter("id", (Object)action.getId());
                        q.setParameter("status", (Object)action.getStatus().toString());
                        q.setParameter("pending", (Object)action.getPending());
                        q.setParameter("lastModifiedTime", (Object)new Date());
                        q.executeUpdate();
                        continue;
                    }
                    em.merge((Object)entity);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

