/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.ParamChecker;

public class CoordJobGetActionByActionNumberJPAExecutor
implements JPAExecutor<String> {
    private String coordJobId = null;
    private final int actionNumber;

    public CoordJobGetActionByActionNumberJPAExecutor(String coordJobId, int actionNumber) {
        ParamChecker.notNull(coordJobId, "coordJobId");
        this.coordJobId = coordJobId;
        this.actionNumber = actionNumber;
    }

    @Override
    public String getName() {
        return "CoordJobGetActionByActionNumberJPAExecutor";
    }

    @Override
    public String execute(EntityManager em) throws JPAExecutorException {
        try {
            Query q = em.createNamedQuery("GET_COORD_ACTION_FOR_COORD_JOB_BY_ACTION_NUMBER");
            q.setParameter("jobId", (Object)this.coordJobId);
            q.setParameter("actionNumber", (Object)this.actionNumber);
            String actionId = (String)q.getSingleResult();
            return actionId;
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
    }
}

