/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;

public class CoordJobsGetFromParentIdJPAExecutor
implements JPAExecutor<List<String>> {
    private String parentId;
    private int limit;
    private int offset;

    public CoordJobsGetFromParentIdJPAExecutor(String parentId, int limit) {
        this(parentId, 0, limit);
    }

    public CoordJobsGetFromParentIdJPAExecutor(String parentId, int offset, int limit) {
        this.parentId = parentId;
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    public String getName() {
        return "CoordinatorJobsGetFromParentIdJPAExecutor";
    }

    @Override
    public List<String> execute(EntityManager em) throws JPAExecutorException {
        List coords = null;
        try {
            Query jobQ = em.createNamedQuery("GET_COORD_JOBS_WITH_PARENT_ID");
            jobQ.setParameter("parentId", (Object)this.parentId);
            jobQ.setMaxResults(this.limit);
            jobQ.setFirstResult(this.offset);
            coords = jobQ.getResultList();
        }
        catch (Exception e) {
            throw new JPAExecutorException(ErrorCode.E0603, e.getMessage(), e);
        }
        return coords;
    }
}

