/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.OozieSysBean;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.executor.jpa.CoordActionsActiveCountJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsToBeMaterializedJPAExecutor;
import org.apache.oozie.executor.jpa.HeartbeatGetJPAExecutor;
import org.apache.oozie.executor.jpa.HeartbeatInsertJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.RecoveryService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XCallable;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class CoordMaterializeTriggerService
implements Service {
    public static final String CONF_PREFIX = "oozie.service.CoordMaterializeTriggerService.";
    public static final String CONF_LOOKUP_INTERVAL = "oozie.service.CoordMaterializeTriggerService.lookup.interval";
    public static final String CONF_MATERIALIZATION_WINDOW = "oozie.service.CoordMaterializeTriggerService.materialization.window";
    public static final String CONF_CALLABLE_BATCH_SIZE = "oozie.service.CoordMaterializeTriggerService.callable.batch.size";
    public static final String CONF_MATERIALIZATION_SYSTEM_LIMIT = "oozie.service.CoordMaterializeTriggerService.materialization.system.limit";
    private static final String INSTRUMENTATION_GROUP = "coord_job_mat";
    private static final String INSTR_MAT_JOBS_COUNTER = "jobs";
    private static final int CONF_LOOKUP_INTERVAL_DEFAULT = 300;
    private static final int CONF_MATERIALIZATION_WINDOW_DEFAULT = 3600;
    private static final int CONF_MATERIALIZATION_SYSTEM_LIMIT_DEFAULT = 50;
    public static HashSet<String> jobsToRecover = new HashSet();

    @Override
    public void init(Services services) throws ServiceException {
        Configuration conf = services.getConf();
        int materializationWindow = conf.getInt(CONF_MATERIALIZATION_WINDOW, 3600);
        int lookupInterval = Services.get().getConf().getInt(CONF_LOOKUP_INTERVAL, 300);
        CoordMaterializeTriggerRunnable lookupTriggerJobsRunnable = new CoordMaterializeTriggerRunnable(materializationWindow, lookupInterval);
        services.get(SchedulerService.class).schedule(lookupTriggerJobsRunnable, 10L, (long)lookupInterval, SchedulerService.Unit.SEC);
    }

    @Override
    public void destroy() {
    }

    @Override
    public Class<? extends Service> getInterface() {
        return CoordMaterializeTriggerService.class;
    }

    static class CoordMaterializeTriggerRunnable
    implements Runnable {
        private int materializationWindow;
        private int lookupInterval;
        private long delay = 0L;
        private long downTime = 0L;
        private long upTime = 0L;
        private List<XCallable<Void>> callables;
        private List<XCallable<Void>> delayedCallables;

        public CoordMaterializeTriggerRunnable(int materializationWindow, int lookupInterval) {
            this.materializationWindow = materializationWindow;
            this.lookupInterval = lookupInterval;
        }

        @Override
        public void run() {
            boolean ret;
            this.runCoordJobMatLookup();
            if (null != this.callables) {
                ret = Services.get().get(CallableQueueService.class).queueSerial(this.callables);
                if (!ret) {
                    XLog.getLog(this.getClass()).warn("Unable to queue the callables commands for CoordMaterializeTriggerRunnable. Most possibly command queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
                }
                this.callables = null;
            }
            if (null != this.delayedCallables) {
                ret = Services.get().get(CallableQueueService.class).queueSerial(this.delayedCallables, this.delay);
                if (!ret) {
                    XLog.getLog(this.getClass()).warn("Unable to queue the delayedCallables commands for CoordMaterializeTriggerRunnable. Most possibly Callable queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
                }
                this.delayedCallables = null;
                this.delay = 0L;
            }
        }

        private void runCoordJobMatLookup() {
            XLog.Info.get().clear();
            XLog LOG = XLog.getLog(this.getClass());
            try {
                Date currDate = new Date(new Date().getTime() + (long)(this.lookupInterval * 1000));
                int materializationLimit = Services.get().getConf().getInt(CoordMaterializeTriggerService.CONF_MATERIALIZATION_SYSTEM_LIMIT, 50);
                if (this.materializeCoordJobs(currDate, materializationLimit, LOG)) {
                    this.materializeCoordJobs(currDate, materializationLimit, LOG);
                }
            }
            catch (Exception ex) {
                LOG.error("Exception while attempting to materialize coordinator jobs, {0}", ex.getMessage(), ex);
            }
        }

        private void setNewMaterializationTimeForRecovery(List<CoordinatorJobBean> coordJobs) throws Exception {
            for (CoordinatorJobBean coordJob : coordJobs) {
                if (coordJob.getRecovery().equalsIgnoreCase("ALL")) continue;
                Date nextMatdTime = coordJob.getNextMaterializedTime();
                if (nextMatdTime == null) {
                    nextMatdTime = coordJob.getStartTime();
                }
                if (nextMatdTime.getTime() >= this.upTime || nextMatdTime.getTime() <= this.downTime) continue;
                jobsToRecover.add(coordJob.getId());
                RecoveryService.jobsToSkipMaterialization.put(coordJob.getId(), nextMatdTime.getTime());
                String jobXml = coordJob.getJobXml();
                Element eJob = XmlUtils.parseXml(jobXml);
                TimeZone appTz = DateUtils.getTimeZone(coordJob.getTimeZone());
                String frequency = coordJob.getFrequency();
                TimeUnit freqTU = TimeUnit.valueOf(eJob.getAttributeValue("freq_timeunit"));
                TimeUnit endOfFlag = TimeUnit.valueOf(eJob.getAttributeValue("end_of_duration"));
                Calendar start = Calendar.getInstance(appTz);
                start.setTime(nextMatdTime);
                DateUtils.moveToEnd(start, endOfFlag);
                Calendar end = Calendar.getInstance(appTz);
                Date jobEndTime = coordJob.getEndTime();
                end.setTime(jobEndTime);
                Calendar upTimeCal = Calendar.getInstance(appTz);
                upTimeCal.setTime(new Date(this.upTime));
                int lastActionNumber = coordJob.getLastActionNumber();
                Calendar origStart = Calendar.getInstance(appTz);
                origStart.setTime(coordJob.getStartTimestamp());
                DateUtils.moveToEnd(origStart, endOfFlag);
                boolean isCronFrequency = false;
                try {
                    Integer.parseInt(coordJob.getFrequency());
                }
                catch (NumberFormatException e) {
                    isCronFrequency = true;
                }
                if (!isCronFrequency) {
                    while (start.compareTo(end) < 0 && start.compareTo(upTimeCal) < 0) {
                        start = (Calendar)origStart.clone();
                        start.add(freqTU.getCalendarUnit(), ++lastActionNumber * Integer.parseInt(frequency));
                    }
                    if (coordJob.getRecovery().equalsIgnoreCase("LAST_ONLY")) {
                        start = (Calendar)origStart.clone();
                        start.add(freqTU.getCalendarUnit(), --lastActionNumber * Integer.parseInt(frequency));
                    }
                } else {
                    Calendar secondToLastTime = (Calendar)start.clone();
                    while (start.compareTo(end) < 0 && start.compareTo(upTimeCal) < 0) {
                        Date nextTime = CoordCommandUtils.getNextValidActionTimeForCronFrequency(start.getTime(), coordJob);
                        secondToLastTime = (Calendar)start.clone();
                        start.setTime(nextTime);
                        if (start.compareTo(end) >= 0 || start.compareTo(upTimeCal) >= 0) continue;
                        ++lastActionNumber;
                    }
                    if (coordJob.getRecovery().equalsIgnoreCase("LAST_ONLY")) {
                        --lastActionNumber;
                        start = (Calendar)secondToLastTime.clone();
                    }
                }
                coordJob.setNextMaterializedTime(start.getTime());
                coordJob.setLastActionNumber(lastActionNumber);
                coordJob.setLastModifiedTime(new Date());
                Services.get().get(JPAService.class).execute(new CoordJobUpdateJPAExecutor(coordJob));
            }
            if (jobsToRecover.isEmpty()) {
                RecoveryService.doneRecoveryMaterialization = true;
            }
        }

        private boolean materializeCoordJobs(Date currDate, int limit, XLog LOG) {
            try {
                JPAService jpaService = Services.get().get(JPAService.class);
                CoordJobsToBeMaterializedJPAExecutor cmatcmd = new CoordJobsToBeMaterializedJPAExecutor(currDate, limit);
                List<CoordinatorJobBean> materializeJobs = jpaService.execute(cmatcmd);
                long downtimeThreshold = Services.get().getConf().getLong("oozie.service.RecoveryService.coord.downtime.longer.than", 10L);
                downtimeThreshold *= 60000L;
                OozieSysBean bean = null;
                boolean isRecovery = false;
                try {
                    bean = jpaService.execute(new HeartbeatGetJPAExecutor());
                }
                catch (JPAExecutorException ex) {
                    LOG.warn((Object)"Error reading heartbeat from database", ex);
                }
                if (bean == null) {
                    bean = new OozieSysBean("oozie.heartbeat", Long.toString(System.currentTimeMillis()));
                    try {
                        jpaService.execute(new HeartbeatInsertJPAExecutor(bean));
                    }
                    catch (JPAExecutorException ex) {}
                } else {
                    Long lastHeartbeat = (long)Long.valueOf(bean.getData());
                    LOG.info("last updated heart beat is " + bean.getData());
                    this.downTime = System.currentTimeMillis() - lastHeartbeat;
                    this.upTime = System.currentTimeMillis();
                    if (this.downTime > downtimeThreshold) {
                        this.downTime = lastHeartbeat;
                        isRecovery = true;
                    }
                }
                if (isRecovery) {
                    try {
                        this.setNewMaterializationTimeForRecovery(materializeJobs);
                    }
                    catch (Exception ex) {
                        LOG.warn("Failed to set new materialization time " + ex);
                    }
                }
                int rejected = 0;
                LOG.info("CoordMaterializeTriggerService - Curr Date= " + currDate + ", Num jobs to materialize = " + materializeJobs.size());
                for (CoordinatorJobBean coordJob : materializeJobs) {
                    if (!Services.get().get(JobsConcurrencyService.class).isJobIdForThisServer(coordJob.getId())) continue;
                    Services.get().get(InstrumentationService.class).get().incr(CoordMaterializeTriggerService.INSTRUMENTATION_GROUP, CoordMaterializeTriggerService.INSTR_MAT_JOBS_COUNTER, 1L);
                    int numWaitingActions = jpaService.execute(new CoordActionsActiveCountJPAExecutor(coordJob.getId()));
                    LOG.info("Job :" + coordJob.getId() + "  numWaitingActions : " + numWaitingActions + " MatThrottle : " + coordJob.getMatThrottling());
                    coordJob.setLastModifiedTime(new Date());
                    jpaService.execute(new CoordJobUpdateJPAExecutor(coordJob));
                    if (numWaitingActions >= coordJob.getMatThrottling()) {
                        LOG.info("info for JobID [" + coordJob.getId() + "] " + numWaitingActions + " actions already waiting. MatThrottle is : " + coordJob.getMatThrottling());
                        ++rejected;
                        continue;
                    }
                    this.queueCallable(new CoordMaterializeTransitionXCommand(coordJob.getId(), this.materializationWindow));
                }
                if (materializeJobs.size() == limit && rejected > 0) {
                    return true;
                }
            }
            catch (JPAExecutorException jex) {
                LOG.warn((Object)"JPAExecutorException while attempting to materialize coordinator jobs", jex);
            }
            return false;
        }

        private void queueCallable(XCallable<Void> callable) {
            if (this.callables == null) {
                this.callables = new ArrayList<XCallable<Void>>();
            }
            this.callables.add(callable);
            if (this.callables.size() == Services.get().getConf().getInt(CoordMaterializeTriggerService.CONF_CALLABLE_BATCH_SIZE, 10)) {
                boolean ret = Services.get().get(CallableQueueService.class).queueSerial(this.callables);
                if (!ret) {
                    XLog.getLog(this.getClass()).warn("Unable to queue the callables commands for CoordMaterializeTriggerRunnable. Most possibly command queue is full. Queue size is :" + Services.get().get(CallableQueueService.class).queueSize());
                }
                this.callables = new ArrayList<XCallable<Void>>();
            }
        }
    }
}

