/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.CoordActionGetForSLAJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetForSLAJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetForSLAJPAExecutor;
import org.apache.oozie.executor.jpa.sla.SLACalculationInsertUpdateJPAExecutor;
import org.apache.oozie.executor.jpa.sla.SLARegistrationGetOnRestartJPAExecutor;
import org.apache.oozie.executor.jpa.sla.SLASummaryGetJPAExecutor;
import org.apache.oozie.executor.jpa.sla.SLASummaryGetRecordsOnRestartJPAExecutor;
import org.apache.oozie.executor.jpa.sla.SLASummaryUpdateForSLAStatusActualTimesJPAExecutor;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLACalculator;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.XLog;

public class SLACalculatorMemory
implements SLACalculator {
    private static final XLog LOG = XLog.getLog(SLACalculatorMemory.class);
    private static Map<String, SLACalcStatus> slaMap;
    private static Set<String> historySet;
    private static int capacity;
    private static JPAService jpaService;
    private EventHandlerService eventHandler;
    private static int modifiedAfter;
    private static long jobEventLatency;

    @Override
    public void init(Configuration conf) throws ServiceException {
        capacity = conf.getInt("oozie.sla.service.SLAService.capacity", 5000);
        jobEventLatency = conf.getInt("oozie.sla.service.SLAService.job.event.latency", 90000);
        slaMap = new ConcurrentHashMap<String, SLACalcStatus>();
        historySet = Collections.synchronizedSet(new HashSet());
        jpaService = Services.get().get(JPAService.class);
        this.eventHandler = Services.get().get(EventHandlerService.class);
        modifiedAfter = conf.getInt("oozie.sla.service.SLAService.events.modified.after", 7);
        this.loadOnRestart();
    }

    private void loadOnRestart() {
        boolean isJobModified = false;
        try {
            long slaPendingCount = 0L;
            long statusPendingCount = 0L;
            List<SLASummaryBean> summaryBeans = jpaService.execute(new SLASummaryGetRecordsOnRestartJPAExecutor(modifiedAfter));
            for (SLASummaryBean summaryBean : summaryBeans) {
                String jobId = summaryBean.getId();
                try {
                    switch (summaryBean.getAppType()) {
                        case COORDINATOR_ACTION: {
                            isJobModified = this.processSummaryBeanForCoordAction(summaryBean, jobId);
                            break;
                        }
                        case WORKFLOW_ACTION: {
                            isJobModified = this.processSummaryBeanForWorkflowAction(summaryBean, jobId);
                            break;
                        }
                        case WORKFLOW_JOB: {
                            isJobModified = this.processSummaryBeanForWorkflowJob(summaryBean, jobId);
                            break;
                        }
                    }
                    if (isJobModified) {
                        jpaService.execute(new SLASummaryUpdateForSLAStatusActualTimesJPAExecutor(summaryBean));
                    }
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to load records for " + jobId), e);
                }
                try {
                    if (summaryBean.getEventProcessed() == 7) {
                        historySet.add(jobId);
                        ++statusPendingCount;
                        continue;
                    }
                    if (summaryBean.getEventProcessed() > 7) continue;
                    SLARegistrationBean slaRegBean = jpaService.execute(new SLARegistrationGetOnRestartJPAExecutor(jobId));
                    SLACalcStatus slaCalcStatus = new SLACalcStatus(summaryBean, slaRegBean);
                    slaMap.put(jobId, slaCalcStatus);
                    ++slaPendingCount;
                }
                catch (Exception e) {
                    LOG.warn((Object)("Failed to fetch/update records for " + jobId), e);
                }
            }
            LOG.info("Loaded SLASummary pendingSLA=" + slaPendingCount + ", pendingStatusUpdate=" + statusPendingCount);
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to retrieve SLASummary records on restart", e);
        }
    }

    private boolean processSummaryBeanForCoordAction(SLASummaryBean summaryBean, String jobId) throws JPAExecutorException {
        boolean isJobModified = false;
        CoordinatorActionBean coordAction = null;
        coordAction = jpaService.execute(new CoordActionGetForSLAJPAExecutor(jobId));
        if (!coordAction.getStatusStr().equals(summaryBean.getJobStatus())) {
            LOG.trace("Coordinator action status is " + coordAction.getStatusStr() + " and summary bean status is " + summaryBean.getJobStatus());
            isJobModified = true;
            summaryBean.setJobStatus(coordAction.getStatusStr());
            if (coordAction.isTerminalStatus()) {
                WorkflowJobBean wfJob = jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(coordAction.getExternalId()));
                this.setEndForSLASummaryBean(summaryBean, wfJob.getStartTime(), coordAction.getLastModifiedTime(), coordAction.getStatusStr());
            } else if (coordAction.getStatus() != CoordinatorAction.Status.WAITING) {
                WorkflowJobBean wfJob = jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(coordAction.getExternalId()));
                this.setStartForSLASummaryBean(summaryBean, summaryBean.getEventProcessed(), wfJob.getStartTime());
            }
        }
        return isJobModified;
    }

    private boolean processSummaryBeanForWorkflowAction(SLASummaryBean summaryBean, String jobId) throws JPAExecutorException {
        boolean isJobModified = false;
        WorkflowActionBean wfAction = null;
        wfAction = jpaService.execute(new WorkflowActionGetForSLAJPAExecutor(jobId));
        if (!wfAction.getStatusStr().equals(summaryBean.getJobStatus())) {
            LOG.trace("Workflow action status is " + wfAction.getStatusStr() + "and summary bean status is " + summaryBean.getJobStatus());
            isJobModified = true;
            summaryBean.setJobStatus(wfAction.getStatusStr());
            if (wfAction.inTerminalState()) {
                this.setEndForSLASummaryBean(summaryBean, wfAction.getStartTime(), wfAction.getEndTime(), wfAction.getStatusStr());
            } else if (wfAction.getStatus() != WorkflowAction.Status.PREP) {
                this.setStartForSLASummaryBean(summaryBean, summaryBean.getEventProcessed(), wfAction.getStartTime());
            }
        }
        return isJobModified;
    }

    private boolean processSummaryBeanForWorkflowJob(SLASummaryBean summaryBean, String jobId) throws JPAExecutorException {
        boolean isJobModified = false;
        WorkflowJobBean wfJob = null;
        wfJob = jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(jobId));
        if (!wfJob.getStatusStr().equals(summaryBean.getJobStatus())) {
            LOG.trace("Workflow job status is " + wfJob.getStatusStr() + "and summary bean status is " + summaryBean.getJobStatus());
            isJobModified = true;
            summaryBean.setJobStatus(wfJob.getStatusStr());
            if (wfJob.inTerminalState()) {
                this.setEndForSLASummaryBean(summaryBean, wfJob.getStartTime(), wfJob.getEndTime(), wfJob.getStatusStr());
            } else if (wfJob.getStatus() != WorkflowJob.Status.PREP) {
                this.setStartForSLASummaryBean(summaryBean, summaryBean.getEventProcessed(), wfJob.getStartTime());
            }
        }
        return isJobModified;
    }

    private void setEndForSLASummaryBean(SLASummaryBean summaryBean, Date startTime, Date endTime, String status) {
        byte eventProc = summaryBean.getEventProcessed();
        summaryBean.setEventProcessed(8);
        summaryBean.setActualStart(startTime);
        summaryBean.setActualEnd(endTime);
        long actualDuration = endTime.getTime() - startTime.getTime();
        summaryBean.setActualDuration(actualDuration);
        if (eventProc < 4) {
            if (status.equals(WorkflowJob.Status.SUCCEEDED.name()) || status.equals(WorkflowAction.Status.OK.name()) || status.equals(CoordinatorAction.Status.SUCCEEDED.name())) {
                if (endTime.getTime() <= summaryBean.getExpectedEnd().getTime()) {
                    summaryBean.setSLAStatus(SLAEvent.SLAStatus.MET);
                } else {
                    summaryBean.setSLAStatus(SLAEvent.SLAStatus.MISS);
                }
            } else {
                summaryBean.setSLAStatus(SLAEvent.SLAStatus.MISS);
            }
        }
    }

    private void setStartForSLASummaryBean(SLASummaryBean summaryBean, byte eventProc, Date startTime) {
        if ((eventProc & 1) == 0) {
            eventProc = (byte)(eventProc + 1);
            summaryBean.setEventProcessed(eventProc);
        }
        if (summaryBean.getSLAStatus().equals((Object)SLAEvent.SLAStatus.NOT_STARTED)) {
            summaryBean.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        }
        summaryBean.setActualStart(startTime);
    }

    @Override
    public int size() {
        return slaMap.size();
    }

    @Override
    public SLACalcStatus get(String jobId) throws JPAExecutorException {
        SLACalcStatus memObj = slaMap.get(jobId);
        if (memObj == null && historySet.contains(jobId)) {
            memObj = new SLACalcStatus(jpaService.execute(new SLASummaryGetJPAExecutor(jobId)), jpaService.execute(new SLARegistrationGetOnRestartJPAExecutor(jobId)));
        }
        return memObj;
    }

    @Override
    public Iterator<String> iterator() {
        return slaMap.keySet().iterator();
    }

    @Override
    public boolean isEmpty() {
        return slaMap.isEmpty();
    }

    @Override
    public void clear() {
        slaMap.clear();
        historySet.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateJobSla(String jobId) throws JPAExecutorException, ServiceException {
        SLACalcStatus slaCalc;
        SLACalcStatus sLACalcStatus = slaCalc = slaMap.get(jobId);
        synchronized (sLACalcStatus) {
            boolean change = false;
            int eventProc = slaCalc.getEventProcessed();
            SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
            if ((eventProc & 1) == 0) {
                if (reg.getExpectedStart() != null) {
                    if (reg.getExpectedStart().getTime() + jobEventLatency < System.currentTimeMillis()) {
                        this.confirmWithDB(slaCalc);
                        eventProc = slaCalc.getEventProcessed();
                        if (eventProc != 8 && (eventProc & 1) == 0) {
                            slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                            eventProc = (byte)(eventProc + 1);
                        }
                        change = true;
                    }
                } else {
                    eventProc = (byte)(eventProc + 1);
                    change = true;
                }
            }
            if ((eventProc >> 1 & 1) == 0 && eventProc != 8) {
                if (reg.getExpectedDuration() == -1L) {
                    eventProc = (byte)(eventProc + 2);
                    change = true;
                } else if (slaCalc.getActualStart() != null && reg.getExpectedDuration() + jobEventLatency < System.currentTimeMillis() - slaCalc.getActualStart().getTime()) {
                    slaCalc.setEventProcessed(eventProc);
                    this.confirmWithDB(slaCalc);
                    eventProc = slaCalc.getEventProcessed();
                    if (eventProc != 8 && (eventProc >> 1 & 1) == 0) {
                        slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
                        this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                        eventProc = (byte)(eventProc + 2);
                    }
                    change = true;
                }
            }
            if (eventProc < 4 && reg.getExpectedEnd().getTime() + jobEventLatency < System.currentTimeMillis()) {
                slaCalc.setEventProcessed(eventProc);
                this.confirmWithDB(slaCalc);
                eventProc = slaCalc.getEventProcessed();
                change = true;
            }
            if (change) {
                if (slaCalc.getEventProcessed() >= 8) {
                    eventProc = 8;
                    slaCalc.setEventProcessed(8);
                    slaMap.remove(jobId);
                } else {
                    slaCalc.setEventProcessed(eventProc);
                }
                SLASummaryBean slaSummaryBean = new SLASummaryBean();
                slaSummaryBean.setId(slaCalc.getId());
                slaSummaryBean.setEventProcessed(eventProc);
                slaSummaryBean.setSLAStatus(slaCalc.getSLAStatus());
                slaSummaryBean.setEventStatus(slaCalc.getEventStatus());
                slaSummaryBean.setActualEnd(slaCalc.getActualEnd());
                slaSummaryBean.setActualStart(slaCalc.getActualStart());
                slaSummaryBean.setActualDuration(slaCalc.getActualDuration());
                slaSummaryBean.setJobStatus(slaCalc.getJobStatus());
                jpaService.execute(new SLASummaryUpdateForSLAStatusActualTimesJPAExecutor(slaSummaryBean));
                if (eventProc == 7) {
                    historySet.add(jobId);
                    slaMap.remove(jobId);
                    LOG.trace("Removed Job [{0}] from map after End-processed", jobId);
                }
            }
        }
    }

    @Override
    public void updateAllSlaStatus() {
        LOG.info("Running periodic SLA check");
        for (String jobId : slaMap.keySet()) {
            try {
                LOG.trace("Processing SLA for jobid={0}", jobId);
                this.updateJobSla(jobId);
            }
            catch (Exception e) {
                LOG.error("Exception in SLA processing for job [{0}]", jobId, e);
            }
        }
    }

    @Override
    public boolean addRegistration(String jobId, SLARegistrationBean reg) throws JPAExecutorException {
        if (slaMap.size() < capacity) {
            SLACalcStatus slaCalc = new SLACalcStatus(reg);
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
            slaCalc.setJobStatus(this.getJobStatus(reg.getAppType()));
            slaMap.put(jobId, slaCalc);
            ArrayList<JsonBean> insertList = new ArrayList<JsonBean>();
            insertList.add(reg);
            insertList.add(new SLASummaryBean(slaCalc));
            jpaService.execute(new SLACalculationInsertUpdateJPAExecutor(insertList, null));
            LOG.trace("SLA Registration Event - Job:" + jobId);
            return true;
        }
        LOG.error("SLACalculator memory capacity reached. Cannot add or update new SLA Registration entry for job [{0}]", reg.getId());
        return false;
    }

    private String getJobStatus(AppType appType) {
        String status = null;
        switch (appType) {
            case COORDINATOR_ACTION: {
                status = CoordinatorAction.Status.WAITING.name();
                break;
            }
            case WORKFLOW_ACTION: {
                status = WorkflowAction.Status.PREP.name();
                break;
            }
            case WORKFLOW_JOB: {
                status = WorkflowJob.Status.PREP.name();
                break;
            }
        }
        return status;
    }

    @Override
    public boolean updateRegistration(String jobId, SLARegistrationBean reg) throws JPAExecutorException {
        if (slaMap.size() < capacity) {
            SLACalcStatus slaCalc = new SLACalcStatus(reg);
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
            slaCalc.setJobStatus(this.getJobStatus(reg.getAppType()));
            slaMap.put(jobId, slaCalc);
            ArrayList<JsonBean> updateList = new ArrayList<JsonBean>();
            updateList.add(reg);
            updateList.add(new SLASummaryBean(slaCalc));
            jpaService.execute(new SLACalculationInsertUpdateJPAExecutor(null, updateList));
            LOG.trace("SLA Registration Event - Job:" + jobId);
            return true;
        }
        LOG.error("SLACalculator memory capacity reached. Cannot add or update new SLA Registration entry for job [{0}]", reg.getId());
        return false;
    }

    @Override
    public void removeRegistration(String jobId) {
        if (slaMap.remove(jobId) == null) {
            historySet.remove(jobId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addJobStatus(String jobId, String jobStatus, JobEvent.EventStatus jobEventStatus, Date startTime, Date endTime) throws JPAExecutorException, ServiceException {
        SLACalcStatus slaCalc = slaMap.get(jobId);
        SLASummaryBean slaInfo = null;
        boolean hasSla = false;
        if (slaCalc != null) {
            SLACalcStatus sLACalcStatus = slaCalc;
            synchronized (sLACalcStatus) {
                slaCalc.setJobStatus(jobStatus);
                switch (jobEventStatus) {
                    case STARTED: {
                        slaInfo = this.processJobStartSLA(slaCalc, startTime);
                        break;
                    }
                    case SUCCESS: {
                        slaInfo = this.processJobEndSuccessSLA(slaCalc, startTime, endTime);
                        break;
                    }
                    case FAILURE: {
                        slaInfo = this.processJobEndFailureSLA(slaCalc, startTime, endTime);
                        break;
                    }
                    default: {
                        LOG.debug("Unknown Job Status for SLA purpose[{0}]", jobEventStatus);
                        slaInfo = this.getSLASummaryBean(slaCalc);
                    }
                }
                if (slaCalc.getEventProcessed() == 7) {
                    slaInfo.setEventProcessed(8);
                    slaMap.remove(jobId);
                }
                hasSla = true;
            }
            LOG.trace("SLA Status Event - Job:" + jobId + " Status:" + slaCalc.getSLAStatus());
        } else if (historySet.contains(jobId)) {
            slaInfo = jpaService.execute(new SLASummaryGetJPAExecutor(jobId));
            if (slaInfo == null) {
                throw new JPAExecutorException(ErrorCode.E0604, jobId);
            }
            slaInfo.setJobStatus(jobStatus);
            slaInfo.setActualStart(startTime);
            slaInfo.setActualEnd(endTime);
            if (endTime != null) {
                slaInfo.setActualDuration(endTime.getTime() - startTime.getTime());
            }
            slaInfo.setEventProcessed(8);
            historySet.remove(jobId);
            hasSla = true;
        }
        if (hasSla) {
            jpaService.execute(new SLASummaryUpdateForSLAStatusActualTimesJPAExecutor(slaInfo));
        }
        return hasSla;
    }

    private SLASummaryBean processJobStartSLA(SLACalcStatus slaCalc, Date actualStart) {
        slaCalc.setActualStart(actualStart);
        if (slaCalc.getSLAStatus().equals((Object)SLAEvent.SLAStatus.NOT_STARTED)) {
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        }
        SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
        Date expecStart = reg.getExpectedStart();
        byte eventProc = slaCalc.getEventProcessed();
        if ((eventProc & 1) == 0) {
            if (expecStart != null) {
                if (actualStart.getTime() > expecStart.getTime()) {
                    slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                } else {
                    slaCalc.setEventStatus(SLAEvent.EventStatus.START_MET);
                }
                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
            }
            eventProc = (byte)(eventProc + 1);
            slaCalc.setEventProcessed(eventProc);
        }
        return this.getSLASummaryBean(slaCalc);
    }

    private SLASummaryBean processJobEndSuccessSLA(SLACalcStatus slaCalc, Date actualStart, Date actualEnd) throws JPAExecutorException {
        SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
        slaCalc.setActualStart(actualStart);
        slaCalc.setActualEnd(actualEnd);
        long expectedDuration = reg.getExpectedDuration();
        long actualDuration = actualEnd.getTime() - actualStart.getTime();
        slaCalc.setActualDuration(actualDuration);
        byte eventProc = slaCalc.getEventProcessed();
        if ((eventProc >> 1 & 1) == 0) {
            this.processDurationSLA(expectedDuration, actualDuration, slaCalc);
            eventProc = (byte)(eventProc + 2);
            slaCalc.setEventProcessed(eventProc);
        }
        if (eventProc < 4) {
            Date expectedEnd = reg.getExpectedEnd();
            if (actualEnd.getTime() > expectedEnd.getTime()) {
                slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
                slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
            } else {
                slaCalc.setEventStatus(SLAEvent.EventStatus.END_MET);
                slaCalc.setSLAStatus(SLAEvent.SLAStatus.MET);
            }
            eventProc = (byte)(eventProc + 4);
            slaCalc.setEventProcessed(eventProc);
            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
        }
        return this.getSLASummaryBean(slaCalc);
    }

    private SLASummaryBean processJobEndFailureSLA(SLACalcStatus slaCalc, Date actualStart, Date actualEnd) throws JPAExecutorException {
        slaCalc.setActualStart(actualStart);
        slaCalc.setActualEnd(actualEnd);
        if (actualStart == null && slaCalc.getEventProcessed() < 4) {
            slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
            slaCalc.setEventProcessed(7);
            return this.getSLASummaryBean(slaCalc);
        }
        SLARegistrationBean reg = slaCalc.getSLARegistrationBean();
        long expectedDuration = reg.getExpectedDuration();
        long actualDuration = actualEnd.getTime() - actualStart.getTime();
        slaCalc.setActualDuration(actualDuration);
        byte eventProc = slaCalc.getEventProcessed();
        if ((eventProc >> 1 & 1) == 0) {
            if (expectedDuration != -1L) {
                slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
            }
            eventProc = (byte)(eventProc + 2);
            slaCalc.setEventProcessed(eventProc);
        }
        if (eventProc < 4) {
            slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
            slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
            eventProc = (byte)(eventProc + 4);
            slaCalc.setEventProcessed(eventProc);
            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
        }
        return this.getSLASummaryBean(slaCalc);
    }

    private SLASummaryBean getSLASummaryBean(SLACalcStatus slaCalc) {
        SLASummaryBean slaSummaryBean = new SLASummaryBean();
        slaSummaryBean.setActualStart(slaCalc.getActualStart());
        slaSummaryBean.setActualEnd(slaCalc.getActualEnd());
        slaSummaryBean.setActualDuration(slaCalc.getActualDuration());
        slaSummaryBean.setSLAStatus(slaCalc.getSLAStatus());
        slaSummaryBean.setEventStatus(slaCalc.getEventStatus());
        slaSummaryBean.setEventProcessed(slaCalc.getEventProcessed());
        slaSummaryBean.setId(slaCalc.getId());
        slaSummaryBean.setJobStatus(slaCalc.getJobStatus());
        return slaSummaryBean;
    }

    private void processDurationSLA(long expected, long actual, SLACalcStatus slaCalc) {
        if (expected != -1L && actual > expected) {
            slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
        } else if (expected != -1L && actual <= expected) {
            slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MET);
            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
        }
    }

    private void confirmWithDB(SLACalcStatus slaCalc) {
        block36: {
            boolean ended = false;
            boolean isEndMiss = false;
            try {
                switch (slaCalc.getAppType()) {
                    case WORKFLOW_JOB: {
                        WorkflowJobBean wf = jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(slaCalc.getId()));
                        if (wf.getEndTime() != null) {
                            ended = true;
                            if (wf.getStatus() == WorkflowJob.Status.KILLED || wf.getStatus() == WorkflowJob.Status.FAILED || wf.getEndTime().getTime() > slaCalc.getExpectedEnd().getTime()) {
                                isEndMiss = true;
                            }
                        }
                        slaCalc.setActualStart(wf.getStartTime());
                        slaCalc.setActualEnd(wf.getEndTime());
                        slaCalc.setJobStatus(wf.getStatusStr());
                        break;
                    }
                    case WORKFLOW_ACTION: {
                        WorkflowActionBean wa = jpaService.execute(new WorkflowActionGetForSLAJPAExecutor(slaCalc.getId()));
                        if (wa.getEndTime() != null) {
                            ended = true;
                            if (wa.isTerminalWithFailure() || wa.getEndTime().getTime() > slaCalc.getExpectedEnd().getTime()) {
                                isEndMiss = true;
                            }
                        }
                        slaCalc.setActualStart(wa.getStartTime());
                        slaCalc.setActualEnd(wa.getEndTime());
                        slaCalc.setJobStatus(wa.getStatusStr());
                        break;
                    }
                    case COORDINATOR_ACTION: {
                        WorkflowJobBean wf;
                        CoordinatorActionBean ca = jpaService.execute(new CoordActionGetForSLAJPAExecutor(slaCalc.getId()));
                        if (ca.isTerminalWithFailure()) {
                            ended = true;
                            isEndMiss = true;
                            slaCalc.setActualStart(null);
                            slaCalc.setActualEnd(ca.getLastModifiedTime());
                        }
                        if (ca.getExternalId() != null) {
                            wf = jpaService.execute(new WorkflowJobGetForSLAJPAExecutor(ca.getExternalId()));
                            if (wf.getEndTime() != null) {
                                ended = true;
                                if (wf.getEndTime().getTime() > slaCalc.getExpectedEnd().getTime()) {
                                    isEndMiss = true;
                                }
                            }
                            slaCalc.setActualEnd(wf.getEndTime());
                            slaCalc.setActualStart(wf.getStartTime());
                        }
                        slaCalc.setJobStatus(ca.getStatusStr());
                        break;
                    }
                    default: {
                        LOG.debug("Unsupported App-type for SLA - " + slaCalc.getAppType());
                    }
                }
                byte eventProc = slaCalc.getEventProcessed();
                if (ended) {
                    if (isEndMiss) {
                        slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
                    } else {
                        slaCalc.setSLAStatus(SLAEvent.SLAStatus.MET);
                    }
                    if (slaCalc.getActualStart() != null) {
                        if ((eventProc & 1) == 0) {
                            if (slaCalc.getExpectedStart().getTime() < slaCalc.getActualStart().getTime()) {
                                slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                            } else {
                                slaCalc.setEventStatus(SLAEvent.EventStatus.START_MET);
                            }
                            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                        }
                        slaCalc.setActualDuration(slaCalc.getActualEnd().getTime() - slaCalc.getActualStart().getTime());
                        if ((eventProc >> 1 & 1) == 0) {
                            this.processDurationSLA(slaCalc.getExpectedDuration(), slaCalc.getActualDuration(), slaCalc);
                        }
                    }
                    if (eventProc < 4) {
                        if (isEndMiss) {
                            slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
                        } else {
                            slaCalc.setEventStatus(SLAEvent.EventStatus.END_MET);
                        }
                        this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                    }
                    slaCalc.setEventProcessed(8);
                } else {
                    if (slaCalc.getActualStart() != null) {
                        slaCalc.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
                    }
                    if ((eventProc & 1) == 0) {
                        if (slaCalc.getActualStart() != null) {
                            if (slaCalc.getExpectedStart().getTime() < slaCalc.getActualStart().getTime()) {
                                slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                            } else {
                                slaCalc.setEventStatus(SLAEvent.EventStatus.START_MET);
                            }
                            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                            eventProc = (byte)(eventProc + 1);
                        } else if (slaCalc.getExpectedStart().getTime() < System.currentTimeMillis()) {
                            slaCalc.setEventStatus(SLAEvent.EventStatus.START_MISS);
                            this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                            eventProc = (byte)(eventProc + 1);
                        }
                    }
                    if ((eventProc >> 1 & 1) == 0 && slaCalc.getActualStart() != null && slaCalc.getExpectedDuration() != -1L && System.currentTimeMillis() - slaCalc.getActualStart().getTime() > slaCalc.getExpectedDuration()) {
                        slaCalc.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
                        this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                        eventProc = (byte)(eventProc + 2);
                    }
                    if (eventProc < 4 && slaCalc.getExpectedEnd().getTime() < System.currentTimeMillis()) {
                        slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
                        slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
                        this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                        eventProc = (byte)(eventProc + 4);
                    }
                    slaCalc.setEventProcessed(eventProc);
                }
            }
            catch (Exception e) {
                LOG.warn("Error while confirming SLA against DB for jobid= " + slaCalc.getId() + ". Exception is " + e.getClass().getName() + ": " + e.getMessage());
                if (slaCalc.getEventProcessed() >= 4 || slaCalc.getExpectedEnd().getTime() >= System.currentTimeMillis()) break block36;
                slaCalc.setEventStatus(SLAEvent.EventStatus.END_MISS);
                slaCalc.setSLAStatus(SLAEvent.SLAStatus.MISS);
                this.eventHandler.queueEvent((Event)new SLACalcStatus(slaCalc));
                slaCalc.setEventProcessed(slaCalc.getEventProcessed() + 4);
            }
        }
    }
}

