/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.avro;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.avro.AvroDeserializer;
import org.apache.hadoop.hive.serde2.avro.AvroGenericRecordWritable;
import org.apache.hadoop.hive.serde2.avro.AvroObjectInspectorGenerator;
import org.apache.hadoop.hive.serde2.avro.AvroSerdeUtils;
import org.apache.hadoop.hive.serde2.avro.AvroSerializer;
import org.apache.hadoop.hive.serde2.avro.BadSchemaException;
import org.apache.hadoop.hive.serde2.avro.SchemaResolutionProblem;
import org.apache.hadoop.hive.serde2.avro.TypeInfoToSchema;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;

public class AvroSerDe
extends AbstractSerDe {
    private static final Log LOG = LogFactory.getLog(AvroSerDe.class);
    public static final String DECIMAL_TYPE_NAME = "decimal";
    public static final String CHAR_TYPE_NAME = "char";
    public static final String VARCHAR_TYPE_NAME = "varchar";
    public static final String AVRO_PROP_LOGICAL_TYPE = "logicalType";
    public static final String AVRO_PROP_PRECISION = "precision";
    public static final String AVRO_PROP_SCALE = "scale";
    public static final String AVRO_PROP_MAX_LENGTH = "maxLength";
    public static final String AVRO_STRING_TYPE_NAME = "string";
    private ObjectInspector oi;
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private Schema schema;
    private AvroDeserializer avroDeserializer = null;
    private AvroSerializer avroSerializer = null;
    private boolean badSchema = false;
    private static String TABLE_NAME = "name";
    private static String TABLE_COMMENT = "comment";

    @Override
    public void initialize(Configuration configuration, Properties properties) throws SerDeException {
        if (this.schema != null) {
            LOG.info((Object)"Resetting already initialized AvroSerDe");
        }
        this.schema = null;
        this.oi = null;
        this.columnNames = null;
        this.columnTypes = null;
        String columnNameProperty = properties.getProperty("columns");
        String columnTypeProperty = properties.getProperty("columns.types");
        String columnCommentProperty = properties.getProperty("columns.comments");
        if (properties.getProperty("avro.schema.literal") != null || properties.getProperty("avro.schema.url") != null || columnNameProperty == null || columnNameProperty.isEmpty() || columnTypeProperty == null || columnTypeProperty.isEmpty()) {
            this.schema = AvroSerdeUtils.determineSchemaOrReturnErrorSchema(properties);
        } else {
            ArrayList<String> columnComments;
            this.columnNames = Arrays.asList(columnNameProperty.split(","));
            this.columnTypes = TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty);
            if (columnCommentProperty.isEmpty()) {
                columnComments = new ArrayList();
            } else {
                columnComments = Arrays.asList(columnCommentProperty.split(","));
                LOG.info((Object)("columnComments is " + columnCommentProperty));
            }
            if (this.columnNames.size() != this.columnTypes.size()) {
                throw new IllegalArgumentException("AvroSerde initialization failed. Number of column name and column type differs. columnNames = " + this.columnNames + ", columnTypes = " + this.columnTypes);
            }
            String tableName = properties.getProperty(TABLE_NAME);
            String tableComment = properties.getProperty(TABLE_COMMENT);
            TypeInfoToSchema typeInfoToSchema = new TypeInfoToSchema();
            this.schema = typeInfoToSchema.convert(this.columnNames, this.columnTypes, columnComments, properties.getProperty("avro.schema.namespace"), properties.getProperty("avro.schema.name", tableName), properties.getProperty("avro.schema.doc", tableComment));
            properties.setProperty("avro.schema.literal", this.schema.toString());
        }
        LOG.info((Object)("Avro schema is " + this.schema));
        if (configuration == null) {
            LOG.info((Object)"Configuration null, not inserting schema");
        } else {
            configuration.set("avro.serde.schema", this.schema.toString(false));
        }
        this.badSchema = this.schema.equals((Object)SchemaResolutionProblem.SIGNAL_BAD_SCHEMA);
        AvroObjectInspectorGenerator aoig = new AvroObjectInspectorGenerator(this.schema);
        this.columnNames = aoig.getColumnNames();
        this.columnTypes = aoig.getColumnTypes();
        this.oi = aoig.getObjectInspector();
    }

    @Override
    public Class<? extends Writable> getSerializedClass() {
        return AvroGenericRecordWritable.class;
    }

    @Override
    public Writable serialize(Object o, ObjectInspector objectInspector) throws SerDeException {
        if (this.badSchema) {
            throw new BadSchemaException();
        }
        return this.getSerializer().serialize(o, objectInspector, this.columnNames, this.columnTypes, this.schema);
    }

    @Override
    public Object deserialize(Writable writable) throws SerDeException {
        if (this.badSchema) {
            throw new BadSchemaException();
        }
        return this.getDeserializer().deserialize(this.columnNames, this.columnTypes, writable, this.schema);
    }

    @Override
    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.oi;
    }

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }

    private AvroDeserializer getDeserializer() {
        if (this.avroDeserializer == null) {
            this.avroDeserializer = new AvroDeserializer();
        }
        return this.avroDeserializer;
    }

    private AvroSerializer getSerializer() {
        if (this.avroSerializer == null) {
            this.avroSerializer = new AvroSerializer();
        }
        return this.avroSerializer;
    }
}

