/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.hfile.Compression;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;

public class HColumnDescriptor
implements WritableComparable<HColumnDescriptor> {
    private static final byte COLUMN_DESCRIPTOR_VERSION = 8;
    public static final String COMPRESSION = "COMPRESSION";
    public static final String COMPRESSION_COMPACT = "COMPRESSION_COMPACT";
    public static final String BLOCKCACHE = "BLOCKCACHE";
    public static final String BLOCKSIZE = "BLOCKSIZE";
    public static final String LENGTH = "LENGTH";
    public static final String TTL = "TTL";
    public static final String BLOOMFILTER = "BLOOMFILTER";
    public static final String FOREVER = "FOREVER";
    public static final String REPLICATION_SCOPE = "REPLICATION_SCOPE";
    public static final String DEFAULT_COMPRESSION = Compression.Algorithm.NONE.getName();
    public static final int DEFAULT_VERSIONS = 3;
    private volatile Integer blocksize = null;
    public static final boolean DEFAULT_IN_MEMORY = false;
    public static final boolean DEFAULT_BLOCKCACHE = true;
    public static final int DEFAULT_BLOCKSIZE = 65536;
    public static final String DEFAULT_BLOOMFILTER = StoreFile.BloomType.NONE.toString();
    public static final int DEFAULT_TTL = Integer.MAX_VALUE;
    public static final int DEFAULT_REPLICATION_SCOPE = 0;
    private byte[] name;
    protected Map<ImmutableBytesWritable, ImmutableBytesWritable> values = new HashMap<ImmutableBytesWritable, ImmutableBytesWritable>();
    private int cachedMaxVersions = -1;

    public HColumnDescriptor() {
        this.name = null;
    }

    public HColumnDescriptor(String familyName) {
        this(Bytes.toBytes(familyName));
    }

    public HColumnDescriptor(byte[] familyName) {
        this(familyName == null || familyName.length <= 0 ? HConstants.EMPTY_BYTE_ARRAY : familyName, 3, DEFAULT_COMPRESSION, false, true, Integer.MAX_VALUE, DEFAULT_BLOOMFILTER);
    }

    public HColumnDescriptor(HColumnDescriptor desc) {
        this.name = (byte[])desc.name.clone();
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : desc.values.entrySet()) {
            this.values.put(e.getKey(), e.getValue());
        }
        this.setMaxVersions(desc.getMaxVersions());
    }

    public HColumnDescriptor(byte[] familyName, int maxVersions, String compression, boolean inMemory, boolean blockCacheEnabled, int timeToLive, String bloomFilter) {
        this(familyName, maxVersions, compression, inMemory, blockCacheEnabled, 65536, timeToLive, bloomFilter, 0);
    }

    public HColumnDescriptor(byte[] familyName, int maxVersions, String compression, boolean inMemory, boolean blockCacheEnabled, int blocksize, int timeToLive, String bloomFilter, int scope) {
        HColumnDescriptor.isLegalFamilyName(familyName);
        this.name = familyName;
        if (maxVersions <= 0) {
            throw new IllegalArgumentException("Maximum versions must be positive");
        }
        this.setMaxVersions(maxVersions);
        this.setInMemory(inMemory);
        this.setBlockCacheEnabled(blockCacheEnabled);
        this.setTimeToLive(timeToLive);
        this.setCompressionType(Compression.Algorithm.valueOf(compression.toUpperCase()));
        this.setBloomFilterType(StoreFile.BloomType.valueOf(bloomFilter.toUpperCase()));
        this.setBlocksize(blocksize);
        this.setScope(scope);
    }

    public static byte[] isLegalFamilyName(byte[] b) {
        if (b == null) {
            return b;
        }
        if (b[0] == 46) {
            throw new IllegalArgumentException("Family names cannot start with a period: " + Bytes.toString(b));
        }
        for (int i = 0; i < b.length; ++i) {
            if (!Character.isISOControl(b[i]) && b[i] != 58) continue;
            throw new IllegalArgumentException("Illegal character <" + b[i] + ">. Family names cannot contain control characters or colons: " + Bytes.toString(b));
        }
        return b;
    }

    public byte[] getName() {
        return this.name;
    }

    public String getNameAsString() {
        return Bytes.toString(this.name);
    }

    public byte[] getValue(byte[] key) {
        ImmutableBytesWritable ibw = this.values.get(new ImmutableBytesWritable(key));
        if (ibw == null) {
            return null;
        }
        return ibw.get();
    }

    public String getValue(String key) {
        byte[] value = this.getValue(Bytes.toBytes(key));
        if (value == null) {
            return null;
        }
        return Bytes.toString(value);
    }

    public Map<ImmutableBytesWritable, ImmutableBytesWritable> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    public void setValue(byte[] key, byte[] value) {
        this.values.put(new ImmutableBytesWritable(key), new ImmutableBytesWritable(value));
    }

    public void remove(byte[] key) {
        this.values.remove(new ImmutableBytesWritable(key));
    }

    public void setValue(String key, String value) {
        this.setValue(Bytes.toBytes(key), Bytes.toBytes(value));
    }

    public Compression.Algorithm getCompression() {
        String n = this.getValue(COMPRESSION);
        if (n == null) {
            return Compression.Algorithm.NONE;
        }
        return Compression.Algorithm.valueOf(n.toUpperCase());
    }

    public Compression.Algorithm getCompactionCompression() {
        String n = this.getValue(COMPRESSION_COMPACT);
        if (n == null) {
            return this.getCompression();
        }
        return Compression.Algorithm.valueOf(n.toUpperCase());
    }

    public int getMaxVersions() {
        return this.cachedMaxVersions;
    }

    public void setMaxVersions(int maxVersions) {
        this.setValue("VERSIONS", Integer.toString(maxVersions));
        this.cachedMaxVersions = maxVersions;
    }

    public synchronized int getBlocksize() {
        if (this.blocksize == null) {
            String value = this.getValue(BLOCKSIZE);
            this.blocksize = value != null ? Integer.decode(value) : Integer.valueOf(65536);
        }
        return this.blocksize;
    }

    public void setBlocksize(int s) {
        this.setValue(BLOCKSIZE, Integer.toString(s));
        this.blocksize = null;
    }

    public Compression.Algorithm getCompressionType() {
        return this.getCompression();
    }

    public void setCompressionType(Compression.Algorithm type) {
        String compressionType;
        switch (type) {
            case LZO: {
                compressionType = "LZO";
                break;
            }
            case GZ: {
                compressionType = "GZ";
                break;
            }
            default: {
                compressionType = "NONE";
            }
        }
        this.setValue(COMPRESSION, compressionType);
    }

    public Compression.Algorithm getCompactionCompressionType() {
        return this.getCompactionCompression();
    }

    public void setCompactionCompressionType(Compression.Algorithm type) {
        String compressionType;
        switch (type) {
            case LZO: {
                compressionType = "LZO";
                break;
            }
            case GZ: {
                compressionType = "GZ";
                break;
            }
            default: {
                compressionType = "NONE";
            }
        }
        this.setValue(COMPRESSION_COMPACT, compressionType);
    }

    public boolean isInMemory() {
        String value = this.getValue("IN_MEMORY");
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return false;
    }

    public void setInMemory(boolean inMemory) {
        this.setValue("IN_MEMORY", Boolean.toString(inMemory));
    }

    public int getTimeToLive() {
        String value = this.getValue(TTL);
        return value != null ? Integer.valueOf(value) : Integer.MAX_VALUE;
    }

    public void setTimeToLive(int timeToLive) {
        this.setValue(TTL, Integer.toString(timeToLive));
    }

    public boolean isBlockCacheEnabled() {
        String value = this.getValue(BLOCKCACHE);
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public void setBlockCacheEnabled(boolean blockCacheEnabled) {
        this.setValue(BLOCKCACHE, Boolean.toString(blockCacheEnabled));
    }

    public StoreFile.BloomType getBloomFilterType() {
        String n = this.getValue(BLOOMFILTER);
        if (n == null) {
            n = DEFAULT_BLOOMFILTER;
        }
        return StoreFile.BloomType.valueOf(n.toUpperCase());
    }

    public void setBloomFilterType(StoreFile.BloomType bt) {
        this.setValue(BLOOMFILTER, bt.toString());
    }

    public int getScope() {
        String value = this.getValue(REPLICATION_SCOPE);
        if (value != null) {
            return Integer.valueOf(value);
        }
        return 0;
    }

    public void setScope(int scope) {
        this.setValue(REPLICATION_SCOPE, Integer.toString(scope));
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append('{');
        s.append("NAME");
        s.append(" => '");
        s.append(Bytes.toString(this.name));
        s.append("'");
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            String key = Bytes.toString(e.getKey().get());
            String value = Bytes.toString(e.getValue().get());
            s.append(", ");
            s.append(key);
            s.append(" => '");
            s.append(value);
            s.append("'");
        }
        s.append('}');
        return s.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HColumnDescriptor)) {
            return false;
        }
        return this.compareTo((HColumnDescriptor)obj) == 0;
    }

    public int hashCode() {
        int result = Bytes.hashCode(this.name);
        result ^= Byte.valueOf((byte)8).hashCode();
        return result ^= ((Object)this.values).hashCode();
    }

    public void readFields(DataInput in) throws IOException {
        byte version = in.readByte();
        if (version < 6) {
            if (version <= 2) {
                Text t = new Text();
                t.readFields(in);
                this.name = t.getBytes();
            } else {
                this.name = Bytes.readByteArray(in);
            }
            this.values.clear();
            this.setMaxVersions(in.readInt());
            int ordinal = in.readInt();
            this.setCompressionType(Compression.Algorithm.values()[ordinal]);
            this.setInMemory(in.readBoolean());
            this.setBloomFilterType(in.readBoolean() ? StoreFile.BloomType.ROW : StoreFile.BloomType.NONE);
            if (this.getBloomFilterType() != StoreFile.BloomType.NONE && version < 5) {
                throw new UnsupportedClassVersionError(this.getClass().getName() + " does not support backward compatibility with versions older " + "than version 5");
            }
            if (version > 1) {
                this.setBlockCacheEnabled(in.readBoolean());
            }
            if (version > 2) {
                this.setTimeToLive(in.readInt());
            }
        } else {
            String value;
            this.name = Bytes.readByteArray(in);
            this.values.clear();
            int numValues = in.readInt();
            for (int i = 0; i < numValues; ++i) {
                ImmutableBytesWritable key = new ImmutableBytesWritable();
                ImmutableBytesWritable value2 = new ImmutableBytesWritable();
                key.readFields(in);
                value2.readFields(in);
                if (version < 8 && Bytes.toString(key.get()).equals(BLOOMFILTER)) {
                    value2.set(Bytes.toBytes(Boolean.getBoolean(Bytes.toString(value2.get())) ? StoreFile.BloomType.ROW.toString() : StoreFile.BloomType.NONE.toString()));
                }
                this.values.put(key, value2);
            }
            if (version == 6) {
                this.setValue(COMPRESSION, Compression.Algorithm.NONE.getName());
            }
            this.cachedMaxVersions = (value = this.getValue("VERSIONS")) != null ? Integer.valueOf(value) : 3;
        }
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(8);
        Bytes.writeByteArray(out, this.name);
        out.writeInt(this.values.size());
        for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> e : this.values.entrySet()) {
            e.getKey().write(out);
            e.getValue().write(out);
        }
    }

    public int compareTo(HColumnDescriptor o) {
        int result = Bytes.compareTo(this.name, o.getName());
        if (result == 0) {
            result = ((Object)this.values).hashCode() - ((Object)o.values).hashCode();
            if (result < 0) {
                result = -1;
            } else if (result > 0) {
                result = 1;
            }
        }
        return result;
    }

    @Deprecated
    public static enum CompressionType {
        NONE,
        RECORD,
        BLOCK;

    }
}

