/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerAddress;
import org.apache.hadoop.hbase.HServerInfo;

public class LoadBalancer {
    private static final Log LOG = LogFactory.getLog(LoadBalancer.class);
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private float slop;
    static RegionPlanComparator rpComparator = new RegionPlanComparator();

    LoadBalancer(Configuration conf) {
        this.slop = conf.getFloat("hbase.regions.slop", 0.0f);
        if (this.slop < 0.0f) {
            this.slop = 0.0f;
        } else if (this.slop > 1.0f) {
            this.slop = 1.0f;
        }
    }

    public List<RegionPlan> balanceCluster(Map<HServerInfo, List<HRegionInfo>> clusterState) {
        Map.Entry entry;
        Map.Entry entry2;
        int regionCount;
        int numTaken;
        long startTime = System.currentTimeMillis();
        TreeMap<HServerInfo, List<HRegionInfo>> serversByLoad = new TreeMap<HServerInfo, List<HRegionInfo>>(new HServerInfo.LoadComparator());
        int numServers = clusterState.size();
        if (numServers == 0) {
            LOG.debug((Object)"numServers=0 so skipping load balancing");
            return null;
        }
        int numRegions = 0;
        for (Map.Entry<HServerInfo, List<HRegionInfo>> server2 : clusterState.entrySet()) {
            server2.getKey().getLoad().setNumberOfRegions(server2.getValue().size());
            numRegions += server2.getKey().getLoad().getNumberOfRegions();
            serversByLoad.put(server2.getKey(), server2.getValue());
        }
        float average = (float)numRegions / (float)numServers;
        int floor = (int)Math.floor(average * (1.0f - this.slop));
        int ceiling = (int)Math.ceil(average * (1.0f + this.slop));
        if (serversByLoad.lastKey().getLoad().getNumberOfRegions() <= ceiling && serversByLoad.firstKey().getLoad().getNumberOfRegions() >= floor) {
            LOG.info((Object)("Skipping load balancing.  servers=" + numServers + " " + "regions=" + numRegions + " average=" + average + " " + "mostloaded=" + serversByLoad.lastKey().getLoad().getNumberOfRegions() + " leastloaded=" + serversByLoad.lastKey().getLoad().getNumberOfRegions()));
            return null;
        }
        int min = numRegions / numServers;
        int max = numRegions % numServers == 0 ? min : min + 1;
        ArrayList<RegionPlan> regionsToMove = new ArrayList<RegionPlan>();
        int regionidx = 0;
        int serversOverloaded = 0;
        TreeMap<HServerInfo, BalanceInfo> serverBalanceInfo = new TreeMap<HServerInfo, BalanceInfo>();
        for (Map.Entry server3 : serversByLoad.descendingMap().entrySet()) {
            HServerInfo serverInfo = (HServerInfo)server3.getKey();
            int n = serverInfo.getLoad().getNumberOfRegions();
            if (n <= max) {
                serverBalanceInfo.put(serverInfo, new BalanceInfo(0, 0));
                break;
            }
            ++serversOverloaded;
            List<HRegionInfo> regions = LoadBalancer.randomize((List)server3.getValue());
            int numToOffload = Math.min(n - max, regions.size());
            numTaken = 0;
            for (int i = regions.size() - 1; i >= 0; --i) {
                HRegionInfo hri = regions.get(i);
                if (hri.isMetaRegion()) continue;
                regionsToMove.add(new RegionPlan(hri, serverInfo, null));
                if (++numTaken >= numToOffload) break;
            }
            serverBalanceInfo.put(serverInfo, new BalanceInfo(numToOffload, -1 * numTaken));
        }
        int serversUnderloaded = 0;
        int neededRegions = 0;
        Iterator i$ = serversByLoad.entrySet().iterator();
        while (i$.hasNext() && (regionCount = (entry2 = i$.next()).getKey().getLoad().getNumberOfRegions()) < min) {
            ++serversUnderloaded;
            int numToTake = min - regionCount;
            for (numTaken = 0; numTaken < numToTake && regionidx < regionsToMove.size(); ++numTaken, ++regionidx) {
                ((RegionPlan)regionsToMove.get(regionidx)).setDestination(entry2.getKey());
            }
            serverBalanceInfo.put(entry2.getKey(), new BalanceInfo(0, numTaken));
            if (numTaken >= numToTake) continue;
            neededRegions += numToTake - numTaken;
        }
        if (neededRegions == 0 && regionidx == regionsToMove.size()) {
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("Calculated a load balance in " + (endTime - startTime) + "ms. " + "Moving " + regionsToMove.size() + " regions off of " + serversOverloaded + " overloaded servers onto " + serversUnderloaded + " less loaded servers"));
            return regionsToMove;
        }
        if (neededRegions != 0) {
            for (Map.Entry entry3 : serversByLoad.descendingMap().entrySet()) {
                int idx;
                BalanceInfo balanceInfo = (BalanceInfo)serverBalanceInfo.get(entry3.getKey());
                int n = idx = balanceInfo == null ? 0 : balanceInfo.getNextRegionForUnload();
                if (idx >= ((List)entry3.getValue()).size()) break;
                HRegionInfo region = (HRegionInfo)((Object)((List)entry3.getValue()).get(idx));
                if (region.isMetaRegion()) continue;
                regionsToMove.add(new RegionPlan(region, entry3.getKey(), null));
                if (--neededRegions != 0) continue;
                break;
            }
        }
        i$ = serversByLoad.entrySet().iterator();
        while (i$.hasNext() && (regionCount = (entry = i$.next()).getKey().getLoad().getNumberOfRegions()) < min) {
            BalanceInfo balanceInfo = (BalanceInfo)serverBalanceInfo.get(entry.getKey());
            if (balanceInfo != null) {
                regionCount += balanceInfo.getNumRegionsAdded();
            }
            if (regionCount >= min) continue;
            int numToTake = min - regionCount;
            for (int numTaken2 = 0; numTaken2 < numToTake && regionidx < regionsToMove.size(); ++numTaken2, ++regionidx) {
                ((RegionPlan)regionsToMove.get(regionidx)).setDestination(entry.getKey());
            }
        }
        if (regionidx != regionsToMove.size()) {
            Map.Entry entry4;
            i$ = serversByLoad.entrySet().iterator();
            while (i$.hasNext() && (regionCount = (entry4 = i$.next()).getKey().getLoad().getNumberOfRegions()) < max) {
                ((RegionPlan)regionsToMove.get(regionidx)).setDestination(entry4.getKey());
                if (++regionidx != regionsToMove.size()) continue;
                break;
            }
        }
        long endTime = System.currentTimeMillis();
        if (regionidx != regionsToMove.size() || neededRegions != 0) {
            LOG.warn((Object)("regionidx=" + regionidx + ", regionsToMove=" + regionsToMove.size() + ", numServers=" + numServers + ", serversOverloaded=" + serversOverloaded + ", serversUnderloaded=" + serversUnderloaded));
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<HServerInfo, List<HRegionInfo>> e : clusterState.entrySet()) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(e.getKey().getServerName());
                sb.append(" ");
                sb.append(e.getValue().size());
            }
            LOG.warn((Object)("Input " + sb.toString()));
        }
        LOG.info((Object)("Calculated a load balance in " + (endTime - startTime) + "ms. " + "Moving " + regionsToMove.size() + " regions off of " + serversOverloaded + " overloaded servers onto " + serversUnderloaded + " less loaded servers"));
        return regionsToMove;
    }

    static List<HRegionInfo> randomize(List<HRegionInfo> regions) {
        Collections.shuffle(regions, RANDOM);
        return regions;
    }

    public static Map<HServerInfo, List<HRegionInfo>> roundRobinAssignment(List<HRegionInfo> regions, List<HServerInfo> servers) {
        if (regions.size() == 0 || servers.size() == 0) {
            return null;
        }
        TreeMap<HServerInfo, List<HRegionInfo>> assignments = new TreeMap<HServerInfo, List<HRegionInfo>>();
        int numRegions = regions.size();
        int numServers = servers.size();
        int max = (int)Math.ceil((float)numRegions / (float)numServers);
        int serverIdx = 0;
        if (numServers > 1) {
            serverIdx = RANDOM.nextInt(numServers);
        }
        int regionIdx = 0;
        for (int j = 0; j < numServers; ++j) {
            HServerInfo server = servers.get((j + serverIdx) % numServers);
            ArrayList<HRegionInfo> serverRegions = new ArrayList<HRegionInfo>(max);
            for (int i = regionIdx; i < numRegions; i += numServers) {
                serverRegions.add(regions.get(i % numRegions));
            }
            assignments.put(server, serverRegions);
            ++regionIdx;
        }
        return assignments;
    }

    public static Map<HServerInfo, List<HRegionInfo>> retainAssignment(Map<HRegionInfo, HServerAddress> regions, List<HServerInfo> servers) {
        TreeMap<HServerInfo, List<HRegionInfo>> assignments = new TreeMap<HServerInfo, List<HRegionInfo>>();
        TreeMap<HServerAddress, HServerInfo> serverMap = new TreeMap<HServerAddress, HServerInfo>();
        for (HServerInfo hServerInfo : servers) {
            serverMap.put(hServerInfo.getServerAddress(), hServerInfo);
            assignments.put(hServerInfo, new ArrayList());
        }
        for (Map.Entry entry : regions.entrySet()) {
            HServerInfo server;
            HServerAddress hsa = (HServerAddress)entry.getValue();
            HServerInfo hServerInfo = server = hsa == null ? null : (HServerInfo)serverMap.get(hsa);
            if (server != null) {
                ((List)assignments.get(server)).add(entry.getKey());
                continue;
            }
            ((List)assignments.get(servers.get(RANDOM.nextInt(assignments.size())))).add(entry.getKey());
        }
        return assignments;
    }

    private List<String> getTopBlockLocations(FileSystem fs, HRegionInfo region) throws IOException {
        String encodedName = region.getEncodedName();
        Path path = new Path("/hbase/table/" + encodedName);
        FileStatus status = fs.getFileStatus(path);
        BlockLocation[] blockLocations = fs.getFileBlockLocations(status, 0L, status.getLen());
        TreeMap<HostAndWeight, HostAndWeight> hostWeights = new TreeMap<HostAndWeight, HostAndWeight>(new HostAndWeight.HostComparator());
        for (BlockLocation bl : blockLocations) {
            String[] hosts = bl.getHosts();
            long len = bl.getLength();
            for (String host : hosts) {
                HostAndWeight haw = (HostAndWeight)hostWeights.get(host);
                if (haw == null) {
                    haw = new HostAndWeight(host, len);
                    hostWeights.put(haw, haw);
                    continue;
                }
                haw.addWeight(len);
            }
        }
        TreeSet<HostAndWeight> orderedHosts = new TreeSet<HostAndWeight>(new HostAndWeight.WeightComparator());
        orderedHosts.addAll(hostWeights.values());
        ArrayList<String> topHosts = new ArrayList<String>(orderedHosts.size());
        for (HostAndWeight haw : orderedHosts.descendingSet()) {
            topHosts.add(haw.getHost());
        }
        return topHosts;
    }

    public static Map<HRegionInfo, HServerInfo> immediateAssignment(List<HRegionInfo> regions, List<HServerInfo> servers) {
        TreeMap<HRegionInfo, HServerInfo> assignments = new TreeMap<HRegionInfo, HServerInfo>();
        for (HRegionInfo region : regions) {
            assignments.put(region, servers.get(RANDOM.nextInt(servers.size())));
        }
        return assignments;
    }

    public static HServerInfo randomAssignment(List<HServerInfo> servers) {
        if (servers == null || servers.isEmpty()) {
            LOG.warn((Object)"Wanted to do random assignment but no servers to assign to");
            return null;
        }
        return servers.get(RANDOM.nextInt(servers.size()));
    }

    public static class RegionPlan
    implements Comparable<RegionPlan> {
        private final HRegionInfo hri;
        private final HServerInfo source;
        private HServerInfo dest;

        public RegionPlan(HRegionInfo hri, HServerInfo source, HServerInfo dest) {
            this.hri = hri;
            this.source = source;
            this.dest = dest;
        }

        public void setDestination(HServerInfo dest) {
            this.dest = dest;
        }

        public HServerInfo getSource() {
            return this.source;
        }

        public HServerInfo getDestination() {
            return this.dest;
        }

        public String getRegionName() {
            return this.hri.getEncodedName();
        }

        public HRegionInfo getRegionInfo() {
            return this.hri;
        }

        @Override
        public int compareTo(RegionPlan o) {
            return this.getRegionName().compareTo(o.getRegionName());
        }

        public String toString() {
            return "hri=" + this.hri.getRegionNameAsString() + ", src=" + (this.source == null ? "" : this.source.getServerName()) + ", dest=" + (this.dest == null ? "" : this.dest.getServerName());
        }
    }

    private static class HostAndWeight {
        private final String host;
        private long weight;

        public HostAndWeight(String host, long weight) {
            this.host = host;
            this.weight = weight;
        }

        public void addWeight(long weight) {
            this.weight += weight;
        }

        public String getHost() {
            return this.host;
        }

        public long getWeight() {
            return this.weight;
        }

        private static class WeightComparator
        implements Comparator<HostAndWeight> {
            private WeightComparator() {
            }

            @Override
            public int compare(HostAndWeight l, HostAndWeight r) {
                if (l.getWeight() == r.getWeight()) {
                    return l.getHost().compareTo(r.getHost());
                }
                return l.getWeight() < r.getWeight() ? -1 : 1;
            }
        }

        private static class HostComparator
        implements Comparator<HostAndWeight> {
            private HostComparator() {
            }

            @Override
            public int compare(HostAndWeight l, HostAndWeight r) {
                return l.getHost().compareTo(r.getHost());
            }
        }
    }

    private static class BalanceInfo {
        private final int nextRegionForUnload;
        private final int numRegionsAdded;

        public BalanceInfo(int nextRegionForUnload, int numRegionsAdded) {
            this.nextRegionForUnload = nextRegionForUnload;
            this.numRegionsAdded = numRegionsAdded;
        }

        public int getNextRegionForUnload() {
            return this.nextRegionForUnload;
        }

        public int getNumRegionsAdded() {
            return this.numRegionsAdded;
        }
    }

    static class RegionPlanComparator
    implements Comparator<RegionPlan> {
        RegionPlanComparator() {
        }

        @Override
        public int compare(RegionPlan l, RegionPlan r) {
            long diff = r.getRegionInfo().getRegionId() - l.getRegionInfo().getRegionId();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

