/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.hadoop.hbase.rest.ResourceBase;
import org.apache.hadoop.hbase.rest.TableResource;

public class ExistsResource
extends ResourceBase {
    static CacheControl cacheControl = new CacheControl();
    TableResource tableResource;

    public ExistsResource(TableResource tableResource) throws IOException {
        this.tableResource = tableResource;
    }

    @GET
    @Produces(value={"text/plain", "text/xml", "application/json", "application/x-protobuf", "application/octet-stream"})
    public Response get(@Context UriInfo uriInfo) {
        try {
            if (!this.tableResource.exists()) {
                throw new WebApplicationException(Response.Status.NOT_FOUND);
            }
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
        }
        Response.ResponseBuilder response = Response.ok();
        response.cacheControl(cacheControl);
        return response.build();
    }

    static {
        cacheControl.setNoCache(true);
        cacheControl.setNoTransform(false);
    }
}

