/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public abstract class ServerCommandLine
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(ServerCommandLine.class);

    protected abstract String getUsage();

    protected void usage(String message) {
        if (message != null) {
            System.err.println(message);
            System.err.println("");
        }
        System.err.println(this.getUsage());
    }

    public static void logJVMInfo() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        if (runtime != null) {
            LOG.info((Object)("vmName=" + runtime.getVmName() + ", vmVendor=" + runtime.getVmVendor() + ", vmVersion=" + runtime.getVmVersion()));
            LOG.info((Object)("vmInputArguments=" + runtime.getInputArguments()));
        }
    }

    public void doMain(String[] args) throws Exception {
        int ret = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)this, (String[])args);
        if (ret != 0) {
            System.exit(ret);
        }
    }
}

