/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.ui.datasources.mondrian;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.pentaho.reporting.engine.classic.core.designtime.DesignTimeContext;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.designtime.swing.BorderlessButton;
import org.pentaho.reporting.libraries.designtime.swing.CommonDialog;
import org.pentaho.reporting.libraries.designtime.swing.GenericCellEditor;
import org.pentaho.reporting.libraries.designtime.swing.GenericCellRenderer;
import org.pentaho.reporting.ui.datasources.mondrian.Messages;

public class MondrianSecurityDialog
extends CommonDialog {
    private DesignTimeContext context;
    private JTextField roleTextField;
    private JTextField jdbcUserTextField;
    private JTextField jdbcPasswordTextField;
    private JComboBox roleFieldBox;
    private JComboBox jdbcUserFieldBox;
    private JComboBox jdbcPasswordFieldBox;
    private JTable propertiesTable;

    public MondrianSecurityDialog(DesignTimeContext context) throws HeadlessException {
        this.init(context);
    }

    public MondrianSecurityDialog(Frame owner, DesignTimeContext context) throws HeadlessException {
        super(owner);
        this.init(context);
    }

    public MondrianSecurityDialog(Dialog owner, DesignTimeContext context) throws HeadlessException {
        super(owner);
        this.init(context);
    }

    protected void init(DesignTimeContext context) {
        this.context = context;
        this.setTitle(Messages.getString("MondrianSecurityDialog.Title", new Object[0]));
        this.roleTextField = new JTextField();
        this.roleTextField.setColumns(35);
        this.jdbcUserTextField = new JTextField();
        this.jdbcUserTextField.setColumns(35);
        this.jdbcPasswordTextField = new JTextField();
        this.jdbcPasswordTextField.setColumns(35);
        String[] reportFields = context.getDataSchemaModel().getColumnNames();
        this.jdbcPasswordFieldBox = new JComboBox<String>(reportFields);
        this.jdbcPasswordFieldBox.setEditable(true);
        this.jdbcUserFieldBox = new JComboBox<String>(reportFields);
        this.jdbcUserFieldBox.setEditable(true);
        this.roleFieldBox = new JComboBox<String>(reportFields);
        this.roleFieldBox.setEditable(true);
        GenericCellEditor cellEditor = new GenericCellEditor(String.class, false);
        this.propertiesTable = new JTable(new MondrianPropertiesTableModel());
        this.propertiesTable.setDefaultEditor(String.class, (TableCellEditor)cellEditor);
        this.propertiesTable.setDefaultRenderer(String.class, (TableCellRenderer)new GenericCellRenderer());
        this.propertiesTable.setShowHorizontalLines(true);
        this.propertiesTable.setShowVerticalLines(true);
        this.propertiesTable.setGridColor(SystemColor.controlShadow);
        this.propertiesTable.setSelectionMode(0);
        this.propertiesTable.setPreferredScrollableViewportSize(new Dimension(200, 100));
        this.propertiesTable.setFillsViewportHeight(false);
        super.init();
    }

    protected String getDialogId() {
        return "MondrianDataSourceEditor.Security";
    }

    protected Component createContentPane() {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new GridBagLayout());
        JPanel securityPanel = new JPanel();
        securityPanel.setLayout(new GridBagLayout());
        securityPanel.setBorder(new TitledBorder(Messages.getString("MondrianSecurityDialog.SecurityProperties", new Object[0])));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        securityPanel.add((Component)this.createRolePanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.anchor = 13;
        securityPanel.add((Component)this.createJdbcUserPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 13;
        securityPanel.add((Component)this.createJdbcPasswordPanel(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 11;
        contentPane.add((Component)securityPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 13;
        contentPane.add((Component)this.createMondrianPropertiesPanel(), gbc);
        return contentPane;
    }

    private JPanel createRolePanel() {
        JPanel rolePanel = new JPanel();
        rolePanel.setBorder(new TitledBorder(Messages.getString("MondrianSecurityDialog.Role", new Object[0])));
        rolePanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        rolePanel.add((Component)new JLabel(Messages.getString("MondrianSecurityDialog.Role.StaticValue", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        rolePanel.add((Component)new JLabel(Messages.getString("MondrianSecurityDialog.Role.FieldValue", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 13;
        rolePanel.add((Component)this.roleTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 13;
        gbc.fill = 2;
        rolePanel.add((Component)this.roleFieldBox, gbc);
        return rolePanel;
    }

    private JPanel createJdbcPasswordPanel() {
        JPanel passwordPanel = new JPanel();
        passwordPanel.setBorder(new TitledBorder(Messages.getString("MondrianSecurityDialog.JDBCPassword", new Object[0])));
        passwordPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        passwordPanel.add((Component)new JLabel(Messages.getString("MondrianSecurityDialog.JDBCPassword.StaticValue", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        passwordPanel.add((Component)new JLabel(Messages.getString("MondrianSecurityDialog.JDBCPassword.FieldValue", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        passwordPanel.add((Component)this.jdbcPasswordTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        passwordPanel.add((Component)this.jdbcPasswordFieldBox, gbc);
        return passwordPanel;
    }

    private JPanel createJdbcUserPanel() {
        JPanel userPanel = new JPanel();
        userPanel.setBorder(new TitledBorder(Messages.getString("MondrianSecurityDialog.JDBCUser", new Object[0])));
        userPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        userPanel.add((Component)new JLabel(Messages.getString("MondrianSecurityDialog.JDBCUser.StaticValue", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        userPanel.add((Component)new JLabel(Messages.getString("MondrianSecurityDialog.JDBCUser.FieldValue", new Object[0])), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        userPanel.add((Component)this.jdbcUserTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        userPanel.add((Component)this.jdbcUserFieldBox, gbc);
        return userPanel;
    }

    public String getRole() {
        return this.roleTextField.getText();
    }

    public void setRole(String role) {
        this.roleTextField.setText(role);
    }

    private JPanel createMondrianPropertiesPanel() {
        JPanel mondrianPropertiesPanel = new JPanel();
        mondrianPropertiesPanel.setBorder(new TitledBorder(Messages.getString("MondrianSecurityDialog.MondrianProperties", new Object[0])));
        mondrianPropertiesPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        JPanel propertiesButtonPanel = new JPanel(new FlowLayout(2, 5, 5));
        propertiesButtonPanel.add((Component)new BorderlessButton((Action)new AddParameterAction(this.propertiesTable)));
        propertiesButtonPanel.add((Component)new BorderlessButton((Action)new RemoveParameterAction(this.propertiesTable)));
        mondrianPropertiesPanel.add((Component)propertiesButtonPanel, gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        mondrianPropertiesPanel.add((Component)new JScrollPane(this.propertiesTable), gbc);
        return mondrianPropertiesPanel;
    }

    public String getRoleField() {
        Object o = this.roleFieldBox.getSelectedItem();
        if (!(o instanceof String)) {
            return null;
        }
        String field = (String)o;
        if (StringUtils.isEmpty((String)field)) {
            return null;
        }
        return field;
    }

    public void setRoleField(String roleField) {
        this.roleFieldBox.setSelectedItem(roleField);
    }

    public String getJdbcUser() {
        return this.jdbcUserTextField.getText();
    }

    public void setJdbcUser(String jdbcUser) {
        this.jdbcUserTextField.setText(jdbcUser);
    }

    public String getJdbcUserField() {
        Object o = this.jdbcUserFieldBox.getSelectedItem();
        if (!(o instanceof String)) {
            return null;
        }
        String field = (String)o;
        if (StringUtils.isEmpty((String)field)) {
            return null;
        }
        return field;
    }

    public void setJdbcUserField(String jdbcUserField) {
        this.jdbcUserFieldBox.setSelectedItem(jdbcUserField);
    }

    public String getJdbcPassword() {
        return this.jdbcPasswordTextField.getText();
    }

    public void setJdbcPassword(String jdbcPassword) {
        this.jdbcPasswordTextField.setText(jdbcPassword);
    }

    public String getJdbcPasswordField() {
        Object o = this.jdbcPasswordFieldBox.getSelectedItem();
        if (!(o instanceof String)) {
            return null;
        }
        String field = (String)o;
        if (StringUtils.isEmpty((String)field)) {
            return null;
        }
        return field;
    }

    public void setJdbcPasswordField(String jdbcPasswordField) {
        this.jdbcPasswordFieldBox.setSelectedItem(jdbcPasswordField);
    }

    public Properties getMondrianProperties() {
        return ((MondrianPropertiesTableModel)this.propertiesTable.getModel()).getProperties();
    }

    public void setMondrianProperties(Properties properties) {
        ((MondrianPropertiesTableModel)this.propertiesTable.getModel()).setMondrianProperties(properties);
    }

    public boolean performEdit() {
        return super.performEdit();
    }

    private static class MondrianPropertiesTableModel
    extends AbstractTableModel {
        private Properties connectionProperties = new Properties();
        private ArrayList<Map.Entry<String, String>> data = new ArrayList();

        private MondrianPropertiesTableModel() {
        }

        public Properties getProperties() {
            Properties mondrianProperties = new Properties();
            for (Map.Entry<String, String> entry : this.data) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key.isEmpty() || value.isEmpty()) continue;
                mondrianProperties.put(key, value);
            }
            return mondrianProperties;
        }

        public void setMondrianProperties(Properties properties) {
            this.connectionProperties = properties;
            if (properties == null) {
                return;
            }
            Enumeration<Object> e = properties.keys();
            while (e.hasMoreElements()) {
                String value;
                String key = (String)e.nextElement();
                AbstractMap.SimpleEntry<String, String> rowData = new AbstractMap.SimpleEntry<String, String>(key, value = (String)properties.get(key));
                if (this.data.contains(rowData)) continue;
                this.data.add(rowData);
            }
            this.fireTableDataChanged();
        }

        public void addRow() {
            AbstractMap.SimpleEntry<String, String> rowData = new AbstractMap.SimpleEntry<String, String>("", "");
            this.data.add(rowData);
            this.fireTableDataChanged();
        }

        public void removeRow(int rowIndex) {
            Map.Entry<String, String> rowData = this.data.get(rowIndex);
            if (rowData != null) {
                this.data.remove(rowIndex);
            }
            this.fireTableDataChanged();
        }

        public Class getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Messages.getString("MondrianSecurityDialog.TableColumn.Key", new Object[0]);
                }
                case 1: {
                    return Messages.getString("MondrianSecurityDialog.TableColumn.Value", new Object[0]);
                }
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Map.Entry<String, String> rowData = this.data.get(rowIndex);
            if (rowData != null) {
                return columnIndex == 0 ? rowData.getKey() : rowData.getValue();
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (aValue == null) {
                return;
            }
            Map.Entry<String, String> rowData = this.data.get(rowIndex);
            if (rowData != null) {
                if (columnIndex == 0) {
                    String paramValue;
                    String colData = (String)this.getValueAt(rowIndex, 1);
                    String string = paramValue = colData != null ? colData : "";
                    if (rowIndex < this.data.size()) {
                        this.data.remove(rowIndex);
                    }
                    this.data.add(new AbstractMap.SimpleEntry<String, String>((String)aValue, paramValue));
                } else {
                    rowData.setValue((String)aValue);
                }
            }
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }
    }

    private static class AddParameterAction
    extends AbstractAction {
        private JTable propertiesTable;

        private AddParameterAction(JTable propertiesTable) {
            this.propertiesTable = propertiesTable;
            URL resource = MondrianSecurityDialog.class.getResource("/org/pentaho/reporting/ui/datasources/mondrian/resources/Add.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("MondrianSecurityDialog.AddParameter.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("MondrianSecurityDialog.AddAction.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MondrianPropertiesTableModel tableModel = (MondrianPropertiesTableModel)this.propertiesTable.getModel();
            tableModel.addRow();
        }
    }

    private static class RemoveParameterAction
    extends AbstractAction
    implements ListSelectionListener {
        private JTable propertiesTable;

        private RemoveParameterAction(JTable propertiesTable) {
            this.propertiesTable = propertiesTable;
            URL resource = MondrianSecurityDialog.class.getResource("/org/pentaho/reporting/ui/datasources/mondrian/resources/Remove.png");
            if (resource != null) {
                this.putValue("SmallIcon", new ImageIcon(resource));
            } else {
                this.putValue("Name", Messages.getString("MondrianSecurityDialog.RemoveParameter.Name", new Object[0]));
            }
            this.putValue("ShortDescription", Messages.getString("MondrianSecurityDialog.RemoveAction.Description", new Object[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int i = this.propertiesTable.getSelectedRow();
            if (i == -1) {
                return;
            }
            MondrianPropertiesTableModel tableModel = (MondrianPropertiesTableModel)this.propertiesTable.getModel();
            tableModel.removeRow(i);
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            this.setEnabled(this.propertiesTable.getSelectedRow() != -1);
        }
    }
}

