/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.boot.AbstractBoot;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.libraries.base.util.FilesystemFilter;
import org.pentaho.reporting.libraries.base.util.Messages;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.base.util.ResourceBundleSupport;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.tools.configeditor.ConfigEditorBoot;
import org.pentaho.reporting.tools.configeditor.ConfigEditorPane;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeModelException;

public class ConfigEditor
extends JFrame {
    private static final Log logger = LogFactory.getLog(ConfigEditor.class);
    private static final String PROPERTIES_FILE_EXTENSION = ".properties";
    private static final int ESCAPE_KEY = 0;
    private static final int ESCAPE_VALUE = 1;
    private static final int ESCAPE_COMMENT = 2;
    private JLabel statusHolder;
    private final ResourceBundleSupport resources;
    private JFileChooser fileChooser;
    private HierarchicalConfiguration configuration;
    private ConfigEditorPane editorPane;

    public ConfigEditor() throws ConfigTreeModelException {
        this(new HierarchicalConfiguration(ConfigEditorBoot.getInstance().getGlobalConfig()), ConfigEditorBoot.getInstance());
    }

    public ConfigEditor(HierarchicalConfiguration configuration, AbstractBoot packageManager) throws ConfigTreeModelException {
        this.configuration = configuration;
        this.resources = new ResourceBundleSupport(this.getLocale(), "org.pentaho.reporting.tools.configeditor.messages", ObjectUtilities.getClassLoader(ConfigEditor.class));
        this.editorPane = new ConfigEditorPane(packageManager, true);
        this.editorPane.updateConfiguration(configuration);
        this.setTitle(this.resources.getString("config-editor.title"));
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.editorPane, "Center");
        contentPane.add((Component)this.createButtonPane(), "South");
        JPanel cPaneStatus = new JPanel();
        cPaneStatus.setLayout(new BorderLayout());
        cPaneStatus.add((Component)contentPane, "Center");
        cPaneStatus.add((Component)this.createStatusBar(), "South");
        this.setContentPane(cPaneStatus);
        this.addWindowListener(new CloseHandler());
    }

    protected ResourceBundleSupport getResources() {
        return this.resources;
    }

    private JPanel createButtonPane() {
        CloseAction closeAction = new CloseAction();
        SaveAction saveAction = new SaveAction();
        LoadAction loadAction = new LoadAction();
        NewAction newAction = new NewAction();
        JPanel buttonHolder = new JPanel();
        buttonHolder.setLayout(new GridLayout(1, 4, 5, 5));
        buttonHolder.add(new JButton(newAction));
        buttonHolder.add(new JButton(loadAction));
        buttonHolder.add(new JButton(saveAction));
        buttonHolder.add(new JButton(closeAction));
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        panel.add(buttonHolder);
        return panel;
    }

    protected JPanel createStatusBar() {
        JPanel statusPane = new JPanel();
        statusPane.setLayout(new BorderLayout());
        statusPane.setBorder(BorderFactory.createLineBorder(UIManager.getDefaults().getColor("controlShadow")));
        this.statusHolder = new JLabel(" ");
        statusPane.setMinimumSize(this.statusHolder.getPreferredSize());
        statusPane.add((Component)this.statusHolder, "West");
        return statusPane;
    }

    private void setStatusText(String text) {
        this.statusHolder.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void load() {
        int option;
        this.setStatusText(this.resources.getString("ConfigEditor.USER_LOADING_FILE"));
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FilesystemFilter filter = new FilesystemFilter(PROPERTIES_FILE_EXTENSION, this.resources.getString("config-editor.file-description.properties"));
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        if ((option = this.fileChooser.showOpenDialog(this)) == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtils.endsWithIgnoreCase((String)selFileName, (String)PROPERTIES_FILE_EXTENSION)) {
                selFileName = selFileName + PROPERTIES_FILE_EXTENSION;
            }
            Properties prop = new Properties();
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(selFileName));
                try {
                    prop.load(in);
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            catch (IOException ioe) {
                logger.debug((Object)this.resources.getString("ConfigEditor.ERROR_0003_FAILED_TO_LOAD_PROPERTIES", (Object)ioe.toString()), (Throwable)ioe);
                this.setStatusText(this.resources.getString("ConfigEditor.ERROR_0003_FAILED_TO_LOAD_PROPERTIES", (Object)ioe.getMessage()));
                return;
            }
            this.reset();
            Enumeration<Object> keys = prop.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = prop.getProperty(key);
                this.configuration.setConfigProperty(key, value);
            }
            this.editorPane.updateConfiguration(this.configuration);
            this.setStatusText(this.resources.getString("ConfigEditor.USER_LOAD_PROPS_COMPLETE"));
        }
    }

    protected void reset() {
        this.editorPane.reset();
    }

    protected void save() {
        int option;
        this.setStatusText(this.resources.getString("ConfigEditor.USER_SAVING"));
        this.editorPane.commit();
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            FilesystemFilter filter = new FilesystemFilter(PROPERTIES_FILE_EXTENSION, this.resources.getString("config-editor.file-description.properties"));
            this.fileChooser.addChoosableFileFilter((FileFilter)filter);
            this.fileChooser.setMultiSelectionEnabled(false);
        }
        if ((option = this.fileChooser.showSaveDialog(this)) == 0) {
            File selFile = this.fileChooser.getSelectedFile();
            String selFileName = selFile.getAbsolutePath();
            if (!StringUtils.endsWithIgnoreCase((String)selFileName, (String)PROPERTIES_FILE_EXTENSION)) {
                selFileName = selFileName + PROPERTIES_FILE_EXTENSION;
            }
            this.write(selFileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(String filename) {
        Properties prop = new Properties();
        ArrayList<String> names = new ArrayList<String>();
        Enumeration defaults = this.configuration.getConfigProperties();
        while (defaults.hasMoreElements()) {
            String key = (String)defaults.nextElement();
            names.add(key);
            prop.setProperty(key, this.configuration.getConfigProperty(key));
        }
        Collections.sort(names);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(filename))));
            for (int i = 0; i < names.size(); ++i) {
                String key = (String)names.get(i);
                String value = prop.getProperty(key);
                String description = this.editorPane.getDescriptionForKey(key);
                if (description != null) {
                    this.writeDescription(description, out);
                }
                this.saveConvert(key, 0, out);
                out.print("=");
                this.saveConvert(value, 1, out);
                out.println();
            }
            out.close();
            this.setStatusText(this.resources.getString("ConfigEditor.USER_SAVING_COMPLETE"));
        }
        catch (IOException ioe) {
            logger.debug((Object)this.resources.getString("ConfigEditor.ERROR_0004_FAILED_PROPERTIES_SAVE", (Object)ioe.toString()), (Throwable)ioe);
            this.setStatusText(this.resources.getString("ConfigEditor.ERROR_0004_FAILED_PROPERTIES_SAVE", (Object)ioe.getMessage()));
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    private void writeDescription(String text, PrintWriter writer) {
        if (text.length() == 0) {
            return;
        }
        writer.println("# ");
        try {
            String s;
            BufferedReader br = new BufferedReader(new StringReader(text));
            while ((s = br.readLine()) != null) {
                writer.print("# ");
                this.saveConvert(s, 2, writer);
                writer.println();
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void saveConvert(String text, int escapeMode, PrintWriter writer) {
        char[] string = text.toCharArray();
        char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        block9: for (int x = 0; x < string.length; ++x) {
            char aChar = string[x];
            switch (aChar) {
                case ' ': {
                    if (escapeMode != 2 && (x == 0 || escapeMode == 0)) {
                        writer.print('\\');
                    }
                    writer.print(' ');
                    continue block9;
                }
                case '\\': {
                    writer.print('\\');
                    writer.print('\\');
                    continue block9;
                }
                case '\t': {
                    if (escapeMode == 2) {
                        writer.print(aChar);
                        continue block9;
                    }
                    writer.print('\\');
                    writer.print('t');
                    continue block9;
                }
                case '\n': {
                    writer.print('\\');
                    writer.print('n');
                    continue block9;
                }
                case '\r': {
                    writer.print('\\');
                    writer.print('r');
                    continue block9;
                }
                case '\f': {
                    if (escapeMode == 2) {
                        writer.print(aChar);
                        continue block9;
                    }
                    writer.print('\\');
                    writer.print('f');
                    continue block9;
                }
                case '!': 
                case '\"': 
                case '#': 
                case ':': 
                case '=': {
                    if (escapeMode == 2) {
                        writer.print(aChar);
                        continue block9;
                    }
                    writer.print('\\');
                    writer.print(aChar);
                    continue block9;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        writer.print('\\');
                        writer.print('u');
                        writer.print(hexChars[aChar >> 12 & 0xF]);
                        writer.print(hexChars[aChar >> 8 & 0xF]);
                        writer.print(hexChars[aChar >> 4 & 0xF]);
                        writer.print(hexChars[aChar & 0xF]);
                        continue block9;
                    }
                    writer.print(aChar);
                }
            }
        }
    }

    protected void attempClose() {
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            ConfigEditorBoot.getInstance().start();
            ConfigEditor ed = new ConfigEditor();
            ed.pack();
            ed.setVisible(true);
        }
        catch (Exception e) {
            Messages messages = new Messages(Locale.getDefault(), "org.pentaho.reporting.tools.configeditor.messages", ObjectUtilities.getClassLoader(ConfigEditorBoot.class));
            String message = messages.getString("ConfigEditor.ERROR_0001_FAILED_TO_INITIALIZE");
            logger.debug((Object)message, (Throwable)e);
            JOptionPane.showMessageDialog(null, message);
        }
    }

    private class CloseHandler
    extends WindowAdapter {
        private CloseHandler() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            ConfigEditor.this.attempClose();
        }
    }

    private class NewAction
    extends AbstractAction {
        protected NewAction() {
            this.putValue("Name", ConfigEditor.this.getResources().getString("action.new.name"));
            this.putValue("SmallIcon", ConfigEditor.this.getResources().getIcon("action.new.small-icon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigEditor.this.reset();
        }
    }

    private class LoadAction
    extends AbstractAction {
        protected LoadAction() {
            this.putValue("Name", ConfigEditor.this.getResources().getString("action.load.name"));
            this.putValue("SmallIcon", ConfigEditor.this.getResources().getIcon("action.load.small-icon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigEditor.this.load();
        }
    }

    private class SaveAction
    extends AbstractAction {
        protected SaveAction() {
            this.putValue("Name", ConfigEditor.this.getResources().getString("action.save.name"));
            this.putValue("SmallIcon", ConfigEditor.this.getResources().getIcon("action.save.small-icon"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigEditor.this.save();
        }
    }

    private class CloseAction
    extends AbstractAction {
        protected CloseAction() {
            this.putValue("Name", ConfigEditor.this.getResources().getString("action.exit.name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigEditor.this.attempClose();
        }
    }
}

