/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.text.html.HTMLEditorKit;
import org.pentaho.reporting.libraries.base.boot.Module;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.tools.configeditor.Messages;
import org.pentaho.reporting.tools.configeditor.editor.AbstractKeyEditor;
import org.pentaho.reporting.tools.configeditor.editor.ClassKeyEditor;
import org.pentaho.reporting.tools.configeditor.editor.EnumKeyEditor;
import org.pentaho.reporting.tools.configeditor.editor.KeyEditor;
import org.pentaho.reporting.tools.configeditor.editor.ModuleEditor;
import org.pentaho.reporting.tools.configeditor.editor.TextKeyEditor;
import org.pentaho.reporting.tools.configeditor.model.ClassConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.EnumConfigDescriptionEntry;
import org.pentaho.reporting.tools.configeditor.model.ModuleNodeFactory;
import org.pentaho.reporting.tools.configeditor.util.ConfigDescriptionEntryComparator;
import org.pentaho.reporting.tools.configeditor.util.VerticalLayout;

public class DefaultModuleEditor
implements ModuleEditor {
    private final JPanel contentpane;
    private final JSplitPane rootpane;
    private final JEditorPane helpPane;
    private final Messages messages = Messages.getInstance();
    private HierarchicalConfiguration config;
    private ConfigDescriptionEntry[] keyNames;
    private EditorCarrier[] activeEditors;
    private Module module;
    private String modulePackage;

    public DefaultModuleEditor() {
        this.contentpane = new JPanel();
        this.contentpane.setLayout(new VerticalLayout());
        this.helpPane = new JEditorPane();
        this.helpPane.setEditable(false);
        this.helpPane.setEditorKit(new HTMLEditorKit());
        this.helpPane.setPreferredSize(new Dimension(600, 100));
        JPanel toolbar = new JPanel();
        toolbar.setLayout(new BorderLayout());
        toolbar.add(new JScrollPane(this.helpPane));
        toolbar.setMinimumSize(new Dimension(100, 150));
        this.rootpane = new JSplitPane(0);
        try {
            Method m = this.rootpane.getClass().getMethod("setResizeWeight", Double.TYPE);
            m.invoke((Object)this.rootpane, new Double(1.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rootpane.setBottomComponent(toolbar);
        this.rootpane.setTopComponent(new JScrollPane(this.contentpane));
    }

    @Override
    public ModuleEditor createInstance(Module module, HierarchicalConfiguration config, ConfigDescriptionEntry[] keyNames) {
        DefaultModuleEditor ed = new DefaultModuleEditor();
        ed.setConfig(config);
        ed.setKeyNames(keyNames);
        ed.setModule(module);
        ed.build();
        return ed;
    }

    protected Module getModule() {
        return this.module;
    }

    protected void setModule(Module module) {
        if (module == null) {
            throw new NullPointerException();
        }
        this.module = module;
        this.modulePackage = ModuleNodeFactory.getPackage(module.getClass());
    }

    @Override
    public boolean canHandle(Module module) {
        return true;
    }

    protected HierarchicalConfiguration getConfig() {
        return this.config;
    }

    protected void setConfig(HierarchicalConfiguration config) {
        this.config = config;
    }

    protected ConfigDescriptionEntry[] getKeyNames() {
        return (ConfigDescriptionEntry[])this.keyNames.clone();
    }

    protected void setKeyNames(ConfigDescriptionEntry[] keyNames) {
        this.keyNames = (ConfigDescriptionEntry[])keyNames.clone();
        Arrays.sort(this.keyNames, new ConfigDescriptionEntryComparator());
    }

    @Override
    public JComponent getComponent() {
        return this.rootpane;
    }

    private String createDisplayName(String keyName) {
        if (keyName.startsWith(this.modulePackage)) {
            return '~' + keyName.substring(this.modulePackage.length());
        }
        return keyName;
    }

    protected void build() {
        int i;
        StringWriter writer = new StringWriter();
        writer.write("<html><head><title></title></head><body>");
        JTextArea mangleInfo = new JTextArea();
        mangleInfo.setText(this.messages.getString("DefaultModuleEditor.USER_GUIDE", this.modulePackage));
        mangleInfo.setName("DescriptionArea");
        mangleInfo.setMinimumSize(new Dimension(100, 10));
        mangleInfo.setEditable(false);
        mangleInfo.setLineWrap(true);
        mangleInfo.setWrapStyleWord(true);
        mangleInfo.setOpaque(false);
        this.contentpane.add(mangleInfo);
        ConfigDescriptionEntry[] keyNames = this.getKeyNames();
        if (keyNames == null) {
            throw new IllegalStateException(this.messages.getString("DefaultModuleEditor.ERROR_0001_NO_KEYS_DEFINED"));
        }
        this.activeEditors = new EditorCarrier[keyNames.length];
        for (int i2 = 0; i2 < keyNames.length; ++i2) {
            AbstractKeyEditor editor;
            ConfigDescriptionEntry entry;
            String displayName = this.createDisplayName(keyNames[i2].getKeyName());
            if (keyNames[i2] instanceof EnumConfigDescriptionEntry) {
                entry = (EnumConfigDescriptionEntry)keyNames[i2];
                editor = new EnumKeyEditor(this.getConfig(), (EnumConfigDescriptionEntry)entry, displayName);
            } else if (keyNames[i2] instanceof ClassConfigDescriptionEntry) {
                entry = (ClassConfigDescriptionEntry)keyNames[i2];
                editor = new ClassKeyEditor(this.getConfig(), (ClassConfigDescriptionEntry)entry, displayName);
            } else {
                editor = new TextKeyEditor(this.getConfig(), keyNames[i2], displayName);
            }
            JCheckBox enableCB = new JCheckBox();
            enableCB.addActionListener(new EnableAction(editor, enableCB));
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            panel.add((Component)enableCB, "West");
            panel.add((Component)editor.getComponent(), "Center");
            this.contentpane.add(panel);
            this.activeEditors[i2] = new EditorCarrier(editor, enableCB);
            writer.write("<h3><b>");
            writer.write(keyNames[i2].getKeyName());
            writer.write("</b></h3>");
            writer.write("<p>");
            writer.write(keyNames[i2].getDescription());
            writer.write("</p><hr>");
        }
        int width = 0;
        for (i = 0; i < this.activeEditors.length; ++i) {
            width = Math.max(width, this.activeEditors[i].getEditor().getLabelWidth());
        }
        for (i = 0; i < this.activeEditors.length; ++i) {
            this.activeEditors[i].getEditor().setLabelWidth(width);
        }
        writer.write("</body></html>");
        this.helpPane.setText(writer.toString());
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.activeEditors.length; ++i) {
            this.activeEditors[i].reset();
        }
    }

    @Override
    public void store() {
        for (int i = 0; i < this.activeEditors.length; ++i) {
            this.activeEditors[i].getEditor().store();
        }
    }

    private static class EditorCarrier {
        private final KeyEditor editor;
        private final JCheckBox enableBox;

        private EditorCarrier(KeyEditor editor, JCheckBox enableBox) {
            this.editor = editor;
            this.enableBox = enableBox;
        }

        public KeyEditor getEditor() {
            return this.editor;
        }

        public void reset() {
            this.enableBox.setSelected(this.editor.isDefined());
            this.editor.setEnabled(this.editor.isDefined());
        }
    }

    private static class EnableAction
    implements ActionListener {
        private final KeyEditor editor;
        private final JCheckBox source;

        private EnableAction(KeyEditor ed, JCheckBox source) {
            this.editor = ed;
            this.source = source;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.editor.setEnabled(this.source.isSelected());
        }
    }
}

