/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.tools.configeditor.editor.AbstractKeyEditor;
import org.pentaho.reporting.tools.configeditor.model.EnumConfigDescriptionEntry;

public class EnumKeyEditor
extends AbstractKeyEditor {
    private final JComboBox content;
    private final JLabel entryLabel;
    private final List options;
    private final JPanel entryLabelCarrier;

    public EnumKeyEditor(HierarchicalConfiguration config, EnumConfigDescriptionEntry entry, String displayName) {
        super(config, entry);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(5, 0));
        this.entryLabel = new JLabel(displayName);
        this.entryLabel.setToolTipText(entry.getDescription());
        this.entryLabelCarrier = new JPanel();
        this.entryLabelCarrier.setLayout(new BorderLayout());
        this.entryLabelCarrier.add(this.entryLabel);
        contentPane.add((Component)this.entryLabelCarrier, "West");
        this.options = Arrays.asList(entry.getOptions());
        this.content = new JComboBox<String>(entry.getOptions());
        this.content.addItemListener(new ComboBoxSelectionHandler());
        contentPane.add((Component)this.content, "Center");
        this.setContentPane(contentPane);
        this.reset();
    }

    @Override
    public void reset() {
        this.content.setSelectedItem(this.loadValue());
    }

    protected void validateInput() {
        this.setValidInput(this.options.contains(this.content.getSelectedItem()));
    }

    @Override
    public void store() {
        if (this.isValidInput()) {
            if (this.isEnabled()) {
                this.storeValue((String)this.content.getSelectedItem());
            } else {
                this.deleteValue();
            }
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.content.setEnabled(enabled);
    }

    @Override
    public void setLabelWidth(int width) {
        Dimension prefSize = this.entryLabel.getPreferredSize();
        this.entryLabelCarrier.setPreferredSize(new Dimension(width, prefSize.height));
    }

    @Override
    public int getLabelWidth() {
        Dimension prefSize = this.entryLabel.getPreferredSize();
        if (prefSize != null) {
            return prefSize.width;
        }
        return 0;
    }

    private class ComboBoxSelectionHandler
    implements ItemListener {
        private ComboBoxSelectionHandler() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            EnumKeyEditor.this.validateInput();
        }
    }
}

