/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.pentaho.reporting.libraries.base.config.HierarchicalConfiguration;
import org.pentaho.reporting.tools.configeditor.editor.AbstractKeyEditor;
import org.pentaho.reporting.tools.configeditor.model.ConfigDescriptionEntry;

public class TextKeyEditor
extends AbstractKeyEditor {
    private final JTextField content;
    private final JLabel entryLabel;
    private final JPanel entryLabelCarrier;

    public TextKeyEditor(HierarchicalConfiguration config, ConfigDescriptionEntry entry, String displayName) {
        super(config, entry);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout(5, 0));
        this.entryLabel = new JLabel(displayName);
        this.entryLabel.setToolTipText(entry.getDescription());
        this.entryLabelCarrier = new JPanel();
        this.entryLabelCarrier.setLayout(new BorderLayout());
        this.entryLabelCarrier.add(this.entryLabel);
        contentPane.add((Component)this.entryLabelCarrier, "West");
        this.content = new JTextField();
        this.content.getDocument().addDocumentListener(new DocumentChangeHandler());
        contentPane.add((Component)this.content, "Center");
        this.setContentPane(contentPane);
        this.reset();
    }

    public void validateContent() {
        this.setValidInput(true);
    }

    @Override
    public void reset() {
        this.content.setText(this.loadValue());
    }

    @Override
    public void store() {
        if (this.isValidInput()) {
            if (this.isEnabled()) {
                this.storeValue(this.content.getText());
            } else {
                this.deleteValue();
            }
        }
    }

    public String getContent() {
        return this.content.getText();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.content.setEnabled(enabled);
    }

    @Override
    public void setLabelWidth(int width) {
        Dimension prefSize = this.entryLabel.getPreferredSize();
        this.entryLabelCarrier.setPreferredSize(new Dimension(width, prefSize.height));
    }

    @Override
    public int getLabelWidth() {
        Dimension prefSize = this.entryLabel.getPreferredSize();
        if (prefSize != null) {
            return prefSize.width;
        }
        return 0;
    }

    private class DocumentChangeHandler
    implements DocumentListener {
        private DocumentChangeHandler() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            TextKeyEditor.this.validateContent();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            TextKeyEditor.this.validateContent();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            TextKeyEditor.this.validateContent();
        }
    }
}

