/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.tools.configeditor.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.pentaho.reporting.tools.configeditor.model.ConfigTreeNode;

public abstract class AbstractConfigTreeNode
implements ConfigTreeNode {
    private final ArrayList<ConfigTreeNode> childs = new ArrayList();
    private final String name;
    private TreeNode parent;

    protected AbstractConfigTreeNode(String name) {
        this.name = name;
    }

    public void add(ConfigTreeNode node) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (!this.childs.contains(node)) {
            this.childs.add(node);
            node.setParent(this);
        }
    }

    protected void reset() {
        for (int i = 0; i < this.childs.size(); ++i) {
            ConfigTreeNode node = this.childs.get(i);
            node.setParent(null);
        }
        this.childs.clear();
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.childs.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.childs.size();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.childs.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Enumeration children() {
        return Collections.enumeration(this.childs);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(TreeNode parent) {
        this.parent = parent;
    }
}

