/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.PostfixOperator;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class PercentageOperator
implements PostfixOperator {
    private static final BigDecimal HUNDRED = new BigDecimal(100.0);
    private static final long serialVersionUID = -5578115447971169716L;

    @Override
    public TypeValuePair evaluate(FormulaContext context, TypeValuePair value1) throws EvaluationException {
        Object rawValue = value1.getValue();
        if (rawValue == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        Type type = value1.getType();
        TypeRegistry typeRegistry = context.getTypeRegistry();
        if (!type.isFlagSet(16) && !type.isFlagSet(1)) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        Number number = typeRegistry.convertToNumber(type, rawValue);
        BigDecimal value = NumberUtil.getAsBigDecimal(number);
        BigDecimal percentage = NumberUtil.divide(value, HUNDRED);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, percentage);
    }

    public String toString() {
        return "%";
    }
}

